/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.BaseCapabilityProvider;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CapabilityProvider;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.util.Map;

public class DefaultCapabilityRegistry
extends BaseCapabilityProvider
implements CapabilityProvider,
CapabilityRegistry<DocumentRepository> {
    private final DocumentRepository _documentRepository;

    public DefaultCapabilityRegistry(DocumentRepository documentRepository) {
        this._documentRepository = documentRepository;
    }

    public <S extends Capability> void addExportedCapability(Class<S> capabilityClass, S capability) {
        super.addExportedCapability(capabilityClass, capability);
    }

    public <S extends Capability> void addSupportedCapability(Class<S> capabilityClass, S capability) {
        super.addSupportedCapability(capabilityClass, capability);
    }

    public DocumentRepository getTarget() {
        return this._documentRepository;
    }

    public LocalRepository invokeCapabilityWrappers(LocalRepository localRepository) {
        Map capabilities = this.getCapabilities();
        for (Capability capability : capabilities.values()) {
            if (!(capability instanceof RepositoryWrapperAware)) continue;
            RepositoryWrapperAware repositoryWrapperAware = (RepositoryWrapperAware)capability;
            localRepository = repositoryWrapperAware.wrapLocalRepository(localRepository);
        }
        return localRepository;
    }

    public Repository invokeCapabilityWrappers(Repository repository) {
        Map capabilities = this.getCapabilities();
        for (Capability capability : capabilities.values()) {
            if (!(capability instanceof RepositoryWrapperAware)) continue;
            RepositoryWrapperAware repositoryWrapperAware = (RepositoryWrapperAware)capability;
            repository = repositoryWrapperAware.wrapRepository(repository);
        }
        return repository;
    }

    public void registerCapabilityRepositoryEvents(RepositoryEventRegistry repositoryEventRegistry) {
        Map capabilities = this.getCapabilities();
        for (Capability capability : capabilities.values()) {
            if (!(capability instanceof RepositoryEventAware)) continue;
            RepositoryEventAware repositoryEventAware = (RepositoryEventAware)capability;
            repositoryEventAware.registerRepositoryEventListeners(repositoryEventRegistry);
        }
    }

    protected String getProviderKey() {
        return String.valueOf(this._documentRepository.getRepositoryId());
    }
}

