/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.ContactBirthdayException;
import com.liferay.portal.kernel.exception.ContactClassNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.ContactLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class ContactLocalServiceImpl
extends ContactLocalServiceBaseImpl {
    @BeanReference(type=AddressLocalService.class)
    private AddressLocalService _addressLocalService;
    @BeanReference(type=EmailAddressLocalService.class)
    private EmailAddressLocalService _emailAddressLocalService;
    @BeanReference(type=PhoneLocalService.class)
    private PhoneLocalService _phoneLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;
    @BeanReference(type=WebsiteLocalService.class)
    private WebsiteLocalService _websiteLocalService;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Contact addContact(Contact contact) {
        try {
            this.validateBirthday(contact.getBirthday());
        }
        catch (ContactBirthdayException contactBirthdayException) {
            throw new SystemException((Throwable)contactBirthdayException);
        }
        return super.addContact(contact);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Contact addContact(long userId, String className, long classPK, String emailAddress, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        this.validate(className, classPK);
        this.validateBirthday(birthday);
        long contactId = this.counterLocalService.increment();
        Contact contact = this.contactPersistence.create(contactId);
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(user.getUserId());
        contact.setUserName(user.getFullName());
        contact.setClassName(className);
        contact.setClassPK(classPK);
        contact.setEmailAddress(emailAddress);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setFacebookSn(facebookSn);
        contact.setJabberSn(jabberSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setJobTitle(jobTitle);
        return (Contact)this.contactPersistence.update((BaseModel)contact);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public Contact deleteContact(Contact contact) {
        contact = (Contact)this.contactPersistence.remove((BaseModel)contact);
        this._addressLocalService.deleteAddresses(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this._emailAddressLocalService.deleteEmailAddresses(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this._phoneLocalService.deletePhones(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        this._websiteLocalService.deleteWebsites(contact.getCompanyId(), Contact.class.getName(), contact.getContactId());
        return contact;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Contact deleteContact(long contactId) {
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact != null) {
            contact = this.deleteContact(contact);
        }
        return contact;
    }

    public List<Contact> getCompanyContacts(long companyId, int start, int end) {
        return this.contactPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyContactsCount(long companyId) {
        return this.contactPersistence.countByCompanyId(companyId);
    }

    public List<Contact> getContacts(long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) {
        return this.contactPersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public int getContactsCount(long classNameId, long classPK) {
        return this.contactPersistence.countByC_C(classNameId, classPK);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Contact updateContact(Contact contact) {
        try {
            this.validateBirthday(contact.getBirthday());
        }
        catch (ContactBirthdayException contactBirthdayException) {
            throw new SystemException((Throwable)contactBirthdayException);
        }
        return super.updateContact(contact);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Contact updateContact(long contactId, String emailAddress, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle) throws PortalException {
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        this.validateBirthday(birthday);
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        contact.setEmailAddress(emailAddress);
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setFacebookSn(facebookSn);
        contact.setJabberSn(jabberSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setJobTitle(jobTitle);
        return (Contact)this.contactPersistence.update((BaseModel)contact);
    }

    protected void validate(String className, long classPK) throws PortalException {
        if (Validator.isNull((String)className) || className.equals(User.class.getName()) || classPK <= 0L) {
            throw new ContactClassNameException();
        }
    }

    protected void validateBirthday(Date birthday) throws ContactBirthdayException {
        if (birthday != null && birthday.after(new Date())) {
            throw new ContactBirthdayException("Birthday is in the future");
        }
    }
}

