/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;

public class LayoutSetPrototypeLayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutModelListener.class);

    public void onAfterCreate(Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    public void onAfterRemove(Layout layout) {
        this.updateLayoutSetPrototype(layout, new Date());
    }

    public void onAfterUpdate(Layout originalLayout, Layout layout) {
        this.updateLayoutSetPrototype(layout, layout.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(Layout layout, Date modifiedDate) {
        if (layout == null) {
            return;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)layout.getGroupId());
        if (group == null || !group.isLayoutSetPrototype()) {
            return;
        }
        try {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
            LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
            layoutSet.setModifiedDate(modifiedDate);
            UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
            settingsUnicodeProperties.remove((Object)"merge-fail-count");
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

