/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.RegionServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class RegionServiceImpl
extends RegionServiceBaseImpl {
    @BeanReference(type=CountryService.class)
    private CountryService _countryService;

    public Region addRegion(long countryId, boolean active, String name, double position, String regionCode, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.regionLocalService.addRegion(countryId, active, name, position, regionCode, serviceContext);
    }

    public void deleteRegion(long regionId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        this.regionLocalService.deleteRegion(regionId);
    }

    public Region fetchRegion(long regionId) {
        return this.regionPersistence.fetchByPrimaryKey(regionId);
    }

    public Region fetchRegion(long countryId, String regionCode) {
        return this.regionPersistence.fetchByC_R(countryId, regionCode);
    }

    public Region getRegion(long regionId) throws PortalException {
        return this.regionPersistence.findByPrimaryKey(regionId);
    }

    public Region getRegion(long countryId, String regionCode) throws PortalException {
        return this.regionPersistence.findByC_R(countryId, regionCode);
    }

    public List<Region> getRegions() {
        return this.regionPersistence.findAll();
    }

    public List<Region> getRegions(boolean active) {
        return this.regionPersistence.findByActive(active);
    }

    public List<Region> getRegions(long countryId) {
        return this.regionPersistence.findByCountryId(countryId, -1, -1);
    }

    @AccessControlled(guestAccessEnabled=true)
    public List<Region> getRegions(long countryId, boolean active) {
        return this.regionPersistence.findByC_A(countryId, active, -1, -1);
    }

    public List<Region> getRegions(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionLocalService.getRegions(countryId, active, start, end, orderByComparator);
    }

    public List<Region> getRegions(long countryId, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionLocalService.getRegions(countryId, start, end, orderByComparator);
    }

    public List<Region> getRegions(long companyId, String a2, boolean active) throws PortalException {
        return this.regionLocalService.getRegions(companyId, a2, active);
    }

    public int getRegionsCount(long countryId) {
        return this.regionLocalService.getRegionsCount(countryId);
    }

    public int getRegionsCount(long countryId, boolean active) {
        return this.regionLocalService.getRegionsCount(countryId, active);
    }

    public BaseModelSearchResult<Region> searchRegions(long companyId, Boolean active, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Region> orderByComparator) throws PortalException {
        return this.regionLocalService.searchRegions(companyId, active, keywords, params, start, end, orderByComparator);
    }

    public Region updateActive(long regionId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.regionLocalService.updateActive(regionId, active);
    }

    public Region updateRegion(long regionId, boolean active, String name, double position, String regionCode) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COUNTRIES");
        return this.regionLocalService.updateRegion(regionId, active, name, position, regionCode);
    }
}

