/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.ImageTable;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.ImagePersistence;
import com.liferay.portal.kernel.service.persistence.ImageUtil;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelperUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.model.impl.ImageModelImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImagePersistenceImpl
extends BasePersistenceImpl<Image>
implements ImagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ImageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByLtSize;
    private FinderPath _finderPathWithPaginationCountByLtSize;
    private static final String _FINDER_COLUMN_LTSIZE_SIZE_2 = "image.size < ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private static final String _SQL_SELECT_IMAGE = "SELECT image FROM Image image";
    private static final String _SQL_SELECT_IMAGE_WHERE = "SELECT image FROM Image image WHERE ";
    private static final String _SQL_COUNT_IMAGE = "SELECT COUNT(image) FROM Image image";
    private static final String _SQL_COUNT_IMAGE_WHERE = "SELECT COUNT(image) FROM Image image WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "image.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Image exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Image exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;

    public List<Image> findByLtSize(int size) {
        return this.findByLtSize(size, -1, -1, null);
    }

    public List<Image> findByLtSize(int size, int start, int end) {
        return this.findByLtSize(size, start, end, null);
    }

    public List<Image> findByLtSize(int size, int start, int end, OrderByComparator<Image> orderByComparator) {
        return this.findByLtSize(size, start, end, orderByComparator, true);
    }

    public List<Image> findByLtSize(int size, int start, int end, OrderByComparator<Image> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(Image.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtSize;
        finderArgs = new Object[]{size, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs)) != null && !list.isEmpty()) {
            for (Image image : list) {
                if (size > image.getSize()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_IMAGE_WHERE);
            sb.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY image.imageId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(size);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Image findByLtSize_First(int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.fetchByLtSize_First(size, orderByComparator);
        if (image != null) {
            return image;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("size<");
        sb.append(size);
        sb.append("}");
        throw new NoSuchImageException(sb.toString());
    }

    public Image fetchByLtSize_First(int size, OrderByComparator<Image> orderByComparator) {
        List<Image> list = this.findByLtSize(size, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Image findByLtSize_Last(int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.fetchByLtSize_Last(size, orderByComparator);
        if (image != null) {
            return image;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("size<");
        sb.append(size);
        sb.append("}");
        throw new NoSuchImageException(sb.toString());
    }

    public Image fetchByLtSize_Last(int size, OrderByComparator<Image> orderByComparator) {
        int count = this.countByLtSize(size);
        if (count == 0) {
            return null;
        }
        List<Image> list = this.findByLtSize(size, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Image[] findByLtSize_PrevAndNext(long imageId, int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.findByPrimaryKey(imageId);
        Session session = null;
        try {
            session = this.openSession();
            Image[] array = new ImageImpl[]{this.getByLtSize_PrevAndNext(session, image, size, orderByComparator, true), image, this.getByLtSize_PrevAndNext(session, image, size, orderByComparator, false)};
            Image[] imageArray = array;
            return imageArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Image getByLtSize_PrevAndNext(Session session, Image image, int size, OrderByComparator<Image> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_IMAGE_WHERE);
        sb.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY image.imageId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(size);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)image)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Image)list.get(1);
        }
        return null;
    }

    public void removeByLtSize(int size) {
        for (Image image : this.findByLtSize(size, -1, -1, null)) {
            this.remove((BaseModel)image);
        }
    }

    public int countByLtSize(int size) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(Image.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathWithPaginationCountByLtSize;
            finderArgs = new Object[]{size};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_IMAGE_WHERE);
            sb.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(size);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ImagePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Image.class);
        this.setModelImplClass(ImageImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)ImageTable.INSTANCE);
    }

    public void cacheResult(Image image) {
        if (image.getCtCollectionId() != 0L) {
            return;
        }
        EntityCacheUtil.putResult(ImageImpl.class, (Serializable)Long.valueOf(image.getPrimaryKey()), (Serializable)image);
    }

    public void cacheResult(List<Image> images) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && images.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Image image : images) {
            if (image.getCtCollectionId() != 0L || EntityCacheUtil.getResult(ImageImpl.class, (Serializable)Long.valueOf(image.getPrimaryKey())) != null) continue;
            this.cacheResult(image);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(ImageImpl.class);
        FinderCacheUtil.clearCache(ImageImpl.class);
    }

    public void clearCache(Image image) {
        EntityCacheUtil.removeResult(ImageImpl.class, (BaseModel)image);
    }

    public void clearCache(List<Image> images) {
        for (Image image : images) {
            EntityCacheUtil.removeResult(ImageImpl.class, (BaseModel)image);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(ImageImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(ImageImpl.class, (Serializable)primaryKey);
        }
    }

    public Image create(long imageId) {
        ImageImpl image = new ImageImpl();
        image.setNew(true);
        image.setPrimaryKey(imageId);
        image.setCompanyId(CompanyThreadLocal.getCompanyId());
        return image;
    }

    public Image remove(long imageId) throws NoSuchImageException {
        return this.remove(Long.valueOf(imageId));
    }

    public Image remove(Serializable primaryKey) throws NoSuchImageException {
        Session session = null;
        try {
            session = this.openSession();
            Image image = (Image)session.get(ImageImpl.class, primaryKey);
            if (image == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchImageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Image image2 = (Image)this.remove((BaseModel)image);
            return image2;
        }
        catch (NoSuchImageException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Image removeImpl(Image image) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)image)) {
                image = (Image)session.get(ImageImpl.class, image.getPrimaryKeyObj());
            }
            if (image != null && CTPersistenceHelperUtil.isRemove((CTModel)image)) {
                session.delete((Object)image);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (image != null) {
            this.clearCache(image);
        }
        return image;
    }

    public Image updateImpl(Image image) {
        boolean isNew = image.isNew();
        if (!(image instanceof ImageModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(image.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)image);
                throw new IllegalArgumentException("Implement ModelWrapper in image proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Image implementation " + image.getClass());
        }
        ImageModelImpl imageModelImpl = (ImageModelImpl)image;
        if (!imageModelImpl.hasSetModifiedDate()) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                image.setModifiedDate(date);
            } else {
                image.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (CTPersistenceHelperUtil.isInsert((CTModel)image)) {
                if (!isNew) {
                    session.evict(ImageImpl.class, image.getPrimaryKeyObj());
                }
                session.save((Object)image);
            } else {
                image = (Image)session.merge((Object)image);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (image.getCtCollectionId() != 0L) {
            if (isNew) {
                image.setNew(false);
            }
            image.resetOriginalValues();
            return image;
        }
        EntityCacheUtil.putResult(ImageImpl.class, (BaseModel)image, (boolean)false, (boolean)true);
        if (isNew) {
            image.setNew(false);
        }
        image.resetOriginalValues();
        return image;
    }

    public Image findByPrimaryKey(Serializable primaryKey) throws NoSuchImageException {
        Image image = this.fetchByPrimaryKey(primaryKey);
        if (image == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchImageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return image;
    }

    public Image findByPrimaryKey(long imageId) throws NoSuchImageException {
        return this.findByPrimaryKey(Long.valueOf(imageId));
    }

    public Image fetchByPrimaryKey(Serializable primaryKey) {
        if (CTPersistenceHelperUtil.isProductionMode(Image.class)) {
            return (Image)super.fetchByPrimaryKey(primaryKey);
        }
        Image image = null;
        Session session = null;
        try {
            session = this.openSession();
            image = (Image)session.get(ImageImpl.class, primaryKey);
            if (image != null) {
                this.cacheResult(image);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return image;
    }

    public Image fetchByPrimaryKey(long imageId) {
        return this.fetchByPrimaryKey(Long.valueOf(imageId));
    }

    public Map<Serializable, Image> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (CTPersistenceHelperUtil.isProductionMode(Image.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Image> map = new HashMap<Serializable, Image>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Image image = this.fetchByPrimaryKey(primaryKey);
            if (image != null) {
                map.put(primaryKey, image);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (Image image : query.list()) {
                map.put(image.getPrimaryKeyObj(), image);
                this.cacheResult(image);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<Image> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Image> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Image> findAll(int start, int end, OrderByComparator<Image> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Image> findAll(int start, int end, OrderByComparator<Image> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(Image.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_IMAGE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_IMAGE;
                sql = sql.concat(" ORDER BY image.imageId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Image image : this.findAll()) {
            this.remove((BaseModel)image);
        }
    }

    public int countAll() {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(Image.class);
        Long count = null;
        if (productionMode) {
            count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_IMAGE);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "imageId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_IMAGE;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return ImageModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "Image";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByLtSize = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtSize", new String[]{Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"size_"}, true);
        this._finderPathWithPaginationCountByLtSize = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtSize", new String[]{Integer.class.getName()}, new String[]{"size_"}, false);
        this._setImageUtilPersistence(this);
    }

    public void destroy() {
        this._setImageUtilPersistence(null);
        EntityCacheUtil.removeCache((String)ImageImpl.class.getName());
    }

    private void _setImageUtilPersistence(ImagePersistence imagePersistence) {
        try {
            Field field = ImageUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, imagePersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctIgnoreColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctIgnoreColumnNames.add("modifiedDate");
        ctStrictColumnNames.add("type_");
        ctStrictColumnNames.add("height");
        ctStrictColumnNames.add("width");
        ctStrictColumnNames.add("size_");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("imageId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _log = LogFactoryUtil.getLog(ImagePersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type", "size"});
    }
}

