/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.persistence.OrganizationFinder;
import com.liferay.portal.kernel.service.persistence.OrganizationUtil;
import com.liferay.portal.kernel.service.persistence.UserUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.OrganizationImpl;
import com.liferay.portal.service.persistence.impl.OrganizationFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrganizationFinderImpl
extends OrganizationFinderBaseImpl
implements OrganizationFinder {
    public static final String COUNT_O_BY_GROUP_ID = OrganizationFinder.class.getName() + ".countO_ByGroupId";
    public static final String COUNT_O_BY_ORGANIZATION_ID = OrganizationFinder.class.getName() + ".countO_ByOrganizationId";
    public static final String COUNT_O_BY_C_PO = OrganizationFinder.class.getName() + ".countO_ByC_PO";
    public static final String COUNT_O_BY_C_PO_N_S_C_Z_R_C = OrganizationFinder.class.getName() + ".countO_ByC_PO_N_S_C_Z_R_C";
    public static final String COUNT_O_BY_C_PO_N_L_S_C_Z_R_C = OrganizationFinder.class.getName() + ".countO_ByC_PO_N_L_S_C_Z_R_C";
    public static final String COUNT_U_BY_C_S_O = OrganizationFinder.class.getName() + ".countU_ByC_S_O";
    public static final String FIND_O_BY_NO_ASSETS = OrganizationFinder.class.getName() + ".findO_ByNoAssets";
    public static final String FIND_O_BY_GROUP_ID = OrganizationFinder.class.getName() + ".findO_ByGroupId";
    public static final String FIND_O_BY_C_P = OrganizationFinder.class.getName() + ".findO_ByC_P";
    public static final String FIND_O_BY_C_PO = OrganizationFinder.class.getName() + ".findO_ByC_PO";
    public static final String FIND_O_BY_C_PO_N_S_C_Z_R_C = OrganizationFinder.class.getName() + ".findO_ByC_PO_N_S_C_Z_R_C";
    public static final String FIND_O_BY_C_PO_N_L_S_C_Z_R_C = OrganizationFinder.class.getName() + ".findO_ByC_PO_N_L_S_C_Z_R_C";
    public static final String FIND_U_BY_C_S_O = OrganizationFinder.class.getName() + ".findU_ByC_S_O";
    public static final String JOIN_O_BY_ORGANIZATIONS_GROUPS = OrganizationFinder.class.getName() + ".joinO_ByOrganizationsGroups";
    public static final String JOIN_O_BY_ORGANIZATIONS_PASSWORD_POLICIES = OrganizationFinder.class.getName() + ".joinO_ByOrganizationsPasswordPolicies";
    public static final String JOIN_O_BY_ORGANIZATIONS_ROLES = OrganizationFinder.class.getName() + ".joinO_ByOrganizationsRoles";
    public static final String JOIN_O_BY_ORGANIZATIONS_USERS = OrganizationFinder.class.getName() + ".joinO_ByOrganizationsUsers";
    public static final String JOIN_O_BY_USERS_ORGS = OrganizationFinder.class.getName() + ".joinO_ByUsersOrgs";
    private static final String _COUNTRY_ID_SQL = "((Organization_.countryId = ?) OR (Address.countryId = ?)) [$AND_OR_CONNECTOR$]";
    private static final String _REGION_ID_SQL = "((Organization_.regionId = ?) OR (Address.regionId = ?)) [$AND_OR_CONNECTOR$]";

    public int countO_ByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator);
    }

    public int countO_ByO_U(long organizationId, long userId) {
        LinkedHashMap params1 = LinkedHashMapBuilder.put((Object)"usersOrgs", (Object)userId).build();
        Session session = null;
        try {
            session = this.openSession();
            int n = this.countO_ByOrganizationId(session, organizationId, params1);
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countO_ByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] streets = CustomSQLUtil.keywords((String)street);
        String[] cities = CustomSQLUtil.keywords((String)city);
        String[] zips = CustomSQLUtil.keywords((String)zip);
        return this.countO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator);
    }

    public int countO_ByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(5);
            boolean doUnion = false;
            Long groupOrganization = null;
            if (params != null && (groupOrganization = (Long)params.get("groupOrganization")) != null) {
                doUnion = true;
            }
            if (doUnion) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_O_BY_GROUP_ID));
                sb.append(") UNION ALL (");
            }
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)COUNT_O_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)COUNT_O_BY_C_PO_N_S_C_Z_R_C));
            }
            if (doUnion) {
                sb.append(")");
            }
            String sql = sb.toString();
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.removeSubstring((String)sql, (String)_REGION_ID_SQL);
            }
            if (countryId == null) {
                sql = StringUtil.removeSubstring((String)sql, (String)_COUNTRY_ID_SQL);
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = parentOrganizationIdComparator.equals("=") ? StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)"=") : StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)"!=");
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (doUnion) {
                queryPos.add(groupOrganization);
            }
            this.setJoin(queryPos, params);
            queryPos.add(companyId);
            queryPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                queryPos.add(type);
            }
            queryPos.add(names, 2);
            queryPos.add(streets, 6);
            if (regionId != null) {
                queryPos.add(regionId);
                queryPos.add(regionId);
            }
            if (countryId != null) {
                queryPos.add(countryId);
                queryPos.add(countryId);
            }
            queryPos.add(cities, 2);
            queryPos.add(zips, 2);
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countO_U_ByC_P(long companyId, long parentOrganizationId, QueryDefinition<?> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"(", CustomSQLUtil.get((String)COUNT_O_BY_C_PO), ") UNION ALL (", this.getUsersSQL(COUNT_U_BY_C_S_O, queryDefinition), ")"}));
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentOrganizationId);
            queryPos.add(companyId);
            int status = queryDefinition.getStatus();
            if (status != -1) {
                queryPos.add(status);
            }
            queryPos.add(parentOrganizationId);
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Organization> findO_ByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Organization> orderByComparator) {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator, start, end, orderByComparator);
    }

    public List<Organization> findO_ByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_O_BY_NO_ASSETS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Organization_", OrganizationImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)Organization.class.getName()));
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findO_ByC_P(long companyId, long parentOrganizationId, long previousOrganizationId, int size) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_O_BY_C_P);
            if (previousOrganizationId == 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(organizationId > ?) AND");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("organizationId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (previousOrganizationId > 0L) {
                queryPos.add(previousOrganizationId);
            }
            queryPos.add(companyId);
            queryPos.add(parentOrganizationId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)0, (int)size);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Organization> findO_ByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Organization> orderByComparator) {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] streets = CustomSQLUtil.keywords((String)street);
        String[] cities = CustomSQLUtil.keywords((String)city);
        String[] zips = CustomSQLUtil.keywords((String)zip);
        return this.findO_ByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator, start, end, orderByComparator);
    }

    public List<Organization> findO_ByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Organization> orderByComparator) {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        if (params == null) {
            params = new LinkedHashMap();
        }
        StringBundler sb = new StringBundler(4);
        sb.append("(");
        Long groupOrganization = (Long)params.get("groupOrganization");
        boolean doUnion = Validator.isNotNull((Long)groupOrganization);
        if (doUnion) {
            sb.append(CustomSQLUtil.get((String)FIND_O_BY_GROUP_ID));
            sb.append(") UNION ALL (");
        }
        if (Validator.isNotNull((String)type)) {
            sb.append(CustomSQLUtil.get((String)FIND_O_BY_C_PO_N_L_S_C_Z_R_C));
        } else {
            sb.append(CustomSQLUtil.get((String)FIND_O_BY_C_PO_N_S_C_Z_R_C));
        }
        String sql = sb.toString();
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        sql = sql.concat(")");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
        sql = parentOrganizationIdComparator.equals("=") ? StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)"=") : StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)"!=");
        if (regionId == null) {
            sql = StringUtil.removeSubstring((String)sql, (String)_REGION_ID_SQL);
        }
        if (countryId == null) {
            sql = StringUtil.removeSubstring((String)sql, (String)_COUNTRY_ID_SQL);
        }
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        sql = CustomSQLUtil.replaceOrderBy((String)sql, orderByComparator);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("orgId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (doUnion) {
                queryPos.add(groupOrganization);
            }
            this.setJoin(queryPos, params);
            queryPos.add(companyId);
            queryPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                queryPos.add(type);
            }
            queryPos.add(names, 2);
            queryPos.add(streets, 6);
            if (regionId != null) {
                queryPos.add(regionId);
                queryPos.add(regionId);
            }
            if (countryId != null) {
                queryPos.add(countryId);
                queryPos.add(countryId);
            }
            queryPos.add(cities, 2);
            queryPos.add(zips, 2);
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            while (iterator.hasNext()) {
                Long organizationId = (Long)iterator.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findO_U_ByC_P(long companyId, long parentOrganizationId, QueryDefinition<?> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.replaceOrderBy((String)StringBundler.concat((String[])new String[]{"(", CustomSQLUtil.get((String)FIND_O_BY_C_PO), ") UNION ALL (", this.getUsersSQL(FIND_U_BY_C_S_O, queryDefinition), ")"}), (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("organizationId", Type.LONG);
            sqlQuery.addScalar("userId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentOrganizationId);
            queryPos.add(companyId);
            int status = queryDefinition.getStatus();
            if (status != -1) {
                queryPos.add(status);
            }
            queryPos.add(parentOrganizationId);
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                long organizationId = (Long)array[0];
                Organization object = null;
                if (organizationId > 0L) {
                    object = OrganizationUtil.findByPrimaryKey((long)organizationId);
                } else {
                    long userId = (Long)array[1];
                    object = UserUtil.findByPrimaryKey((long)userId);
                }
                models.add(object);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countO_ByOrganizationId(Session session, long organizationId, LinkedHashMap<String, Object> params) throws PortalException {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_O_BY_ORGANIZATION_ID);
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        this.setJoin(queryPos, params);
        queryPos.add(organizationId);
        Iterator iterator = sqlQuery.iterate();
        if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)entry.getValue())) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("organizationsGroups")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_GROUPS);
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getUsersSQL(String id, QueryDefinition<?> queryDefinition) {
        String sql = CustomSQLUtil.get((String)id);
        int status = queryDefinition.getStatus();
        if (status == -1) {
            sql = StringUtil.removeSubstring((String)sql, (String)"(User_.status = ?) AND");
        }
        return sql;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)(value = entry.getValue()))) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        return this.getWhere(key, null);
    }

    protected String getWhere(String key, Object value) {
        String join = "";
        if (key.equals("organizations")) {
            Long[] organizationIds = (Long[])value;
            if (organizationIds.length == 0) {
                join = "WHERE ((Organization_.organizationId = -1) )";
            } else {
                StringBundler sb = new StringBundler(organizationIds.length * 2 + 1);
                sb.append("WHERE (");
                for (int i = 0; i < organizationIds.length; ++i) {
                    sb.append("(Organization_.organizationId = ?) ");
                    if (i + 1 >= organizationIds.length) continue;
                    sb.append("OR ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsGroups")) {
            if (value instanceof Long) {
                join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_GROUPS);
            } else if (value instanceof Long[]) {
                Long[] organizationGroupIds = (Long[])value;
                if (organizationGroupIds.length == 0) {
                    join = "WHERE (Groups_Orgs.groupId = -1)";
                } else {
                    StringBundler sb = new StringBundler(organizationGroupIds.length * 2 + 1);
                    sb.append("WHERE (");
                    for (int i = 0; i < organizationGroupIds.length; ++i) {
                        sb.append("(Groups_Orgs.groupId = ?) ");
                        if (i + 1 >= organizationGroupIds.length) continue;
                        sb.append("OR ");
                    }
                    sb.append(")");
                    join = sb.toString();
                }
            }
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsTree")) {
            List organizationsTree = (List)value;
            int size = organizationsTree.size();
            if (size == 0) {
                join = "WHERE (Organization_.treePath = '')";
            } else {
                StringBundler sb = new StringBundler(size * 2 + 1);
                sb.append("WHERE (");
                for (int i = 0; i < size; ++i) {
                    sb.append("(Organization_.treePath LIKE ?) ");
                    if (i + 1 >= size) continue;
                    sb.append("OR ");
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_O_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                join = join.substring(pos + 5);
                join = join.concat(" AND ");
            } else {
                join = "";
            }
        }
        return join;
    }

    protected void setJoin(QueryPos queryPos, LinkedHashMap<String, Object> params) throws PortalException {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || key.equals("groupOrganization")) continue;
            Object value = entry.getValue();
            if (key.equals("organizationsTree")) {
                List organizationsTree = (List)value;
                if (organizationsTree.isEmpty()) continue;
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                for (Organization organization : organizationsTree) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("%");
                    sb.append("/");
                    sb.append(organization.getOrganizationId());
                    sb.append("/");
                    if (permissionChecker != null && (permissionChecker.isOrganizationAdmin(organization.getOrganizationId()) || permissionChecker.isOrganizationOwner(organization.getOrganizationId()) || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS"))) {
                        sb.append("%");
                    }
                    queryPos.add(sb.toString());
                }
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                queryPos.add(valueLong);
                continue;
            }
            if (value instanceof Long[]) {
                Long[] valueArray;
                for (Long element : valueArray = (Long[])value) {
                    if (!Validator.isNotNull((Long)element)) continue;
                    queryPos.add(element);
                }
                continue;
            }
            if (value instanceof Long[][]) {
                Long[][] valueDoubleArray = (Long[][])value;
                Long[] longArray = valueDoubleArray;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    Long valueArray;
                    for (Long valueLong : valueArray = longArray[i]) {
                        queryPos.add(valueLong);
                    }
                }
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            queryPos.add(valueString);
        }
    }
}

