/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters;

import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class IgnoreModuleRequestFilter
extends BasePortalFilter {
    private static final String _MODULE_REQUEST_PREFIX = PortalUtil.getPathModule() + "/";

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.isModuleRequest(httpServletRequest)) {
            return false;
        }
        return super.isFilterEnabled(httpServletRequest, httpServletResponse);
    }

    protected boolean isModuleRequest(HttpServletRequest httpServletRequest) {
        String requestURI;
        String contextPath = httpServletRequest.getContextPath();
        String resourcePath = requestURI = httpServletRequest.getRequestURI();
        int index = requestURI.indexOf(contextPath);
        if (index == 0) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        return resourcePath.startsWith(_MODULE_REQUEST_PREFIX);
    }
}

