/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.util.Map;

public class UpgradePostgreSQL
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.POSTGRESQL) {
            return;
        }
        this.updatePostgreSQLRules(HashMapBuilder.put((Object)"DLContent", (Object)"data_").build());
    }

    protected void updatePostgreSQLRules(Map<String, String> oidColumnNames) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (Map.Entry<String, String> entry : oidColumnNames.entrySet()) {
                String tableName = entry.getKey();
                String columnName = entry.getValue();
                PreparedStatement preparedStatement = this.connection.prepareStatement(PostgreSQLDB.getCreateRulesSQL(tableName, columnName));
                Throwable throwable = null;
                try {
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
        }
    }
}

