/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeMessageBoards
extends UpgradeProcess {
    protected void deleteEmptyMBDiscussion() throws Exception {
        String tempTableName = "TEMP_TABLE_" + StringUtil.randomString((int)4);
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL(StringBundler.concat((String[])new String[]{"create table ", tempTableName, " (threadId LONG NOT NULL ", "PRIMARY KEY)"}));
            this.runSQL(StringBundler.concat((String[])new String[]{"insert into ", tempTableName, " select MBMessage.threadId from MBMessage inner join ", "MBThread on MBMessage.threadId = MBThread.threadId where ", "MBThread.categoryId = -1 group by MBMessage.threadId ", "having count(MBMessage.messageId) = 1"}));
            this._deleteAssetEntry(tempTableName);
            this._deleteTable("MBDiscussion", tempTableName);
            this._deleteTable("MBMessage", tempTableName);
            this._deleteTable("MBThread", tempTableName);
        }
        catch (Exception exception) {
            throw new UpgradeException((Throwable)exception);
        }
        finally {
            this.runSQL("drop table " + tempTableName);
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteEmptyMBDiscussion();
        this.populateMBDiscussionGroupId();
    }

    protected void populateMBDiscussionGroupId() throws Exception {
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update MBDiscussion set groupId = ? where discussionId = ?");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select MBThread.groupId, MBDiscussion.discussionId from ", "MBDiscussion inner join MBThread on ", "MBDiscussion.threadId = MBThread.threadId where ", "MBDiscussion.groupId = 0"}));
             ResultSet resultSet = preparedStatement2.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong(1);
                long discussionId = resultSet.getLong(2);
                preparedStatement1.setLong(1, groupId);
                preparedStatement1.setLong(2, discussionId);
                preparedStatement1.addBatch();
            }
            preparedStatement1.executeBatch();
        }
    }

    private void _deleteAssetEntry(String tempTableName) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)"com.liferay.message.boards.kernel.model.MBDiscussion");
        DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(StringBundler.concat((Object[])new Object[]{"delete from AssetEntry where classPK in (", "select MBMessage.messageId from MBMessage inner join ", tempTableName, " on MBMessage.threadId = ", tempTableName, ".threadId) and classNameId = ", classNameId}));
        String sql = StringBundler.concat((Object[])new Object[]{"delete AssetEntry from AssetEntry inner join MBMessage on ", "AssetEntry.classPK = MBMessage.messageId and ", "AssetEntry.classNameId = ", classNameId, " inner join ", tempTableName, " on MBMessage.threadId = ", tempTableName, ".threadId"});
        dbTypeToSQLMap.add(DBType.MARIADB, sql);
        dbTypeToSQLMap.add(DBType.MYSQL, sql);
        this.runSQL(dbTypeToSQLMap);
    }

    private void _deleteTable(String tableName, String tempTableName) throws Exception {
        DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(StringBundler.concat((String[])new String[]{"delete from ", tableName, " where threadId in (select threadId from ", tempTableName, ")"}));
        String sql = StringBundler.concat((String[])new String[]{"delete ", tableName, " from ", tableName, " inner join ", tempTableName, " on ", tableName, ".threadId = ", tempTableName, ".threadId"});
        dbTypeToSQLMap.add(DBType.MARIADB, sql);
        dbTypeToSQLMap.add(DBType.MYSQL, sql);
        this.runSQL(dbTypeToSQLMap);
    }
}

