/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class JarUtil {
    private static final Log _log = LogFactoryUtil.getLog(JarUtil.class);
    private static final Method _addURLMethod;

    public static void downloadAndInstallJar(URL url, Path path, String sha1) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Downloading ", url, " to ", path}));
        }
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        inputStream = Files.newInputStream(path, new OpenOption[0]);
        var4_4 = null;
        try {
            String digest = DigesterUtil.digestHex((String)"SHA-1", (InputStream)inputStream);
            if (!StringUtil.equalsIgnoreCase((String)sha1, (String)digest)) {
                throw new Exception(StringBundler.concat((Object[])new Object[]{"Unable to download ", url, " to ", path, " because ", sha1, " does not equal ", digest}));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Downloaded ", url, " to ", path}));
        }
    }

    public static void downloadAndInstallJar(URL url, Path path, URLClassLoader urlClassLoader, String sha1) throws Exception {
        JarUtil.downloadAndInstallJar(url, path, sha1);
        URI uri = path.toUri();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Installing ", path, " to ", urlClassLoader}));
        }
        _addURLMethod.invoke((Object)urlClassLoader, uri.toURL());
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Installed ", path, " to ", urlClassLoader}));
        }
    }

    static {
        try {
            _addURLMethod = ReflectionUtil.getDeclaredMethod(URLClassLoader.class, (String)"addURL", (Class[])new Class[]{URL.class});
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

