/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFolderPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutLocalServiceBaseImpl;
import com.liferay.trash.kernel.service.TrashEntryLocalService;
import com.liferay.trash.kernel.service.TrashVersionLocalService;
import java.util.Date;
import java.util.List;

public class DLFileShortcutLocalServiceImpl
extends DLFileShortcutLocalServiceBaseImpl {
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=AssetTagLocalService.class)
    private AssetTagLocalService _assetTagLocalService;
    @BeanReference(type=DLAppLocalService.class)
    private DLAppLocalService _dlAppLocalService;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;
    @BeanReference(type=DLFolderPersistence.class)
    private DLFolderPersistence _dlFolderPersistence;
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=TrashEntryLocalService.class)
    private TrashEntryLocalService _trashEntryLocalService;
    @BeanReference(type=TrashVersionLocalService.class)
    private TrashVersionLocalService _trashVersionLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public DLFileShortcut addFileShortcut(long userId, long groupId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        this.validate(user, toFileEntryId);
        long fileShortcutId = this.counterLocalService.increment();
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.create(fileShortcutId);
        fileShortcut.setUuid(serviceContext.getUuid());
        fileShortcut.setGroupId(groupId);
        fileShortcut.setCompanyId(user.getCompanyId());
        fileShortcut.setUserId(user.getUserId());
        fileShortcut.setUserName(user.getFullName());
        fileShortcut.setRepositoryId(repositoryId);
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        fileShortcut.setActive(true);
        fileShortcut.setStatus(0);
        fileShortcut.setStatusByUserId(userId);
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(new Date());
        fileShortcut = (DLFileShortcut)this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileShortcutResources(fileShortcut, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileShortcutResources(fileShortcut, serviceContext.getModelPermissions());
        }
        if (folderId != 0L) {
            this._dlFolderLocalService.updateLastPostDate(folderId, fileShortcut.getModifiedDate());
        }
        this.copyAssetTags(this._dlAppLocalService.getFileEntry(toFileEntryId), serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), modelPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, addGroupPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, ModelPermissions modelPermissions) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, modelPermissions);
    }

    @SystemEvent(type=1)
    public void deleteFileShortcut(DLFileShortcut fileShortcut) throws PortalException {
        this.dlFileShortcutPersistence.remove((BaseModel)fileShortcut);
        this._resourceLocalService.deleteResource(fileShortcut.getCompanyId(), DLFileShortcutConstants.getClassName(), 4, fileShortcut.getFileShortcutId());
        this._assetEntryLocalService.deleteEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        if (fileShortcut.isInTrashExplicitly()) {
            this._trashEntryLocalService.deleteEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        }
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
        }
    }

    public void deleteFileShortcuts(long groupId, long folderId) throws PortalException {
        this.deleteFileShortcuts(groupId, folderId, true);
    }

    public void deleteFileShortcuts(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByG_F(groupId, folderId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            if (!includeTrashedEntries && fileShortcut.isInTrashExplicitly()) continue;
            this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
        }
    }

    public void deleteRepositoryFileShortcuts(long repositoryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.dlFileShortcutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"repositoryId", (Object)repositoryId)));
        long groupId = repositoryId;
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            groupId = repository.getGroupId();
        }
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(fileShortcut -> this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut));
        actionableDynamicQuery.performActions();
    }

    public void disableFileShortcuts(long toFileEntryId) {
        this.updateFileShortcutsActive(toFileEntryId, false);
    }

    public void enableFileShortcuts(long toFileEntryId) {
        this.updateFileShortcutsActive(toFileEntryId, true);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
    }

    public List<DLFileShortcut> getFileShortcuts(long toFileEntryId) {
        return this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
    }

    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status, int start, int end) {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status, start, end);
    }

    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    public void rebuildTree(long companyId) throws PortalException {
        this._dlFolderLocalService.rebuildTree(companyId);
    }

    public void setTreePaths(long folderId, String treePath) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
            dynamicQuery.add(folderIdProperty.eq((Object)folderId));
            Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileShortcut -> {
            dlFileShortcut.setTreePath(treePath);
            this.updateDLFileShortcut((DLFileShortcut)dlFileShortcut);
        });
        actionableDynamicQuery.performActions();
    }

    public void updateAsset(long userId, DLFileShortcut fileShortcut, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileShortcut.getToFileEntryId());
        this._assetEntryLocalService.updateEntry(userId, fileShortcut.getGroupId(), fileShortcut.getCreateDate(), fileShortcut.getModifiedDate(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, fileShortcut.getCreateDate(), null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.validate(user, toFileEntryId);
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        fileShortcut = (DLFileShortcut)this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        if (folderId != 0L) {
            this._dlFolderLocalService.updateLastPostDate(folderId, fileShortcut.getModifiedDate());
        }
        this.copyAssetTags(this._dlAppLocalService.getFileEntry(toFileEntryId), serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(oldToFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setToFileEntryId(newToFileEntryId);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public void updateFileShortcutsActive(long toFileEntryId, boolean active) {
        List fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setActive(active);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
        }
    }

    public DLFileShortcut updateStatus(long userId, long fileShortcutId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        fileShortcut.setStatus(status);
        fileShortcut.setStatusByUserId(user.getUserId());
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(serviceContext.getModifiedDate(null));
        return (DLFileShortcut)this.dlFileShortcutPersistence.update((BaseModel)fileShortcut);
    }

    protected void copyAssetTags(FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        String[] assetTagNames = this._assetTagLocalService.getTagNames(FileEntry.class.getName(), fileEntry.getFileEntryId());
        this._assetTagLocalService.checkTags(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetTagNames);
        serviceContext.setAssetTagNames(assetTagNames);
    }

    protected long getFolderId(long companyId, long folderId) {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this._dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected void validate(User user, long toFileEntryId) throws PortalException {
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(toFileEntryId);
        if (user.getCompanyId() != fileEntry.getCompanyId()) {
            throw new NoSuchFileEntryException("{fileEntryId=" + toFileEntryId + "}");
        }
    }
}

