/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.VideoConverter;
import com.liferay.document.library.kernel.util.VideoProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.event.FileVersionPreviewEventListener;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang.time.StopWatch;

public class VideoProcessorImpl
extends DLPreviewableProcessor
implements VideoProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_CONTAINERS;
    private static final Log _log = LogFactoryUtil.getLog(VideoProcessorImpl.class);
    private static volatile FileVersionPreviewEventListener _fileVersionPreviewEventListener = (FileVersionPreviewEventListener)ServiceProxyFactory.newServiceTrackedInstance(FileVersionPreviewEventListener.class, VideoProcessorImpl.class, (String)"_fileVersionPreviewEventListener", (boolean)false, (boolean)false);
    private static volatile VideoConverter _videoConverter = (VideoConverter)ServiceProxyFactory.newServiceTrackedInstance(VideoConverter.class, VideoProcessorImpl.class, (String)"_videoConverter", (boolean)false);
    private final List<Long> _fileVersionIds = new Vector<Long>();
    private final Set<String> _videoMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_MIME_TYPES);

    public void afterPropertiesSet() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            for (String previewType : _PREVIEW_TYPES) {
                if (previewType.equals("mp4") || previewType.equals("ogv")) continue;
                valid = false;
                break;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay is incorrectly configured to generate video ", "previews using video containers other than MP4 or OGV. ", "Please change the property ", "dl.file.entry.preview.video.containers", " in portal-ext.properties."}));
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateVideo(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public String getType() {
        return "VideoProcessor";
    }

    public Set<String> getVideoMimeTypes() {
        return this._videoMimeTypes;
    }

    public boolean hasVideo(FileVersion fileVersion) {
        boolean hasVideo = false;
        try {
            hasVideo = this._hasVideo(fileVersion);
            if (!hasVideo && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return hasVideo;
    }

    public boolean isAvailable() {
        return _videoConverter.isEnabled();
    }

    public boolean isSupported(String mimeType) {
        return this._videoMimeTypes.contains(mimeType) && _videoConverter.isEnabled();
    }

    public boolean isVideoSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isVideoSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "video");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            for (String previewType : _PREVIEW_TYPES) {
                if (!previewType.equals("mp4") && !previewType.equals("ogv")) continue;
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "video", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "jpg";
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        for (String previewType : _PREVIEW_TYPES) {
            if (!previewType.equals("mp4") && !previewType.equals("ogv")) continue;
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video", previewType);
        }
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        if (!this.hasThumbnail(fileVersion, 0)) {
            this.addFileToStore(fileVersion.getCompanyId(), "document_thumbnail/", this.getThumbnailFilePath(fileVersion, 0), file);
        }
        if (this.isThumbnailEnabled(1) || this.isThumbnailEnabled(2)) {
            ImageBag imageBag = ImageToolUtil.read((File)file);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this.storeThumbnailImage(fileVersion, renderedImage, 1);
            this.storeThumbnailImage(fileVersion, renderedImage, 2);
        }
    }

    private void _generateThumbnail(FileVersion fileVersion, File file) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File thumbnailTempFile = this.getThumbnailTempFile(DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion()));
        try {
            try {
                FileUtil.write((File)thumbnailTempFile, (InputStream)_videoConverter.generateVideoThumbnail(file, "jpg"));
            }
            catch (CancellationException cancellationException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Cancellation received for ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}), (Throwable)cancellationException);
                }
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}), (Throwable)exception);
            }
            this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Generated a thumbnail for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"}));
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    private void _generateVideo(FileVersion fileVersion, File sourceFile, File destinationFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            FileUtil.write((File)destinationFile, (InputStream)_videoConverter.generateVideoPreview(sourceFile, containerType));
            _fileVersionPreviewEventListener.onSuccess(fileVersion);
        }
        catch (Exception exception) {
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw exception;
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destinationFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Generated a ", containerType, " preview video for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"}));
        }
    }

    private void _generateVideo(FileVersion fileVersion, File sourceFile, File[] destinationFiles) {
        try {
            for (int i = 0; i < destinationFiles.length; ++i) {
                this._generateVideo(fileVersion, sourceFile, destinationFiles[i], _PREVIEW_TYPES[i]);
            }
        }
        catch (CancellationException cancellationException) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Cancellation received for ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}), (Throwable)cancellationException);
            }
            _fileVersionPreviewEventListener.onFailure(fileVersion);
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}), (Throwable)exception);
            _fileVersionPreviewEventListener.onFailure(fileVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        if (!_videoConverter.isEnabled() || this._hasVideo(destinationFileVersion)) {
            return;
        }
        File[] previewTempFiles = new File[_PREVIEW_TYPES.length];
        File videoTempFile = null;
        try {
            if (sourceFileVersion != null) {
                this.copy(sourceFileVersion, destinationFileVersion);
                return;
            }
            if (!this.hasPreviews(destinationFileVersion) || !this.hasThumbnails(destinationFileVersion)) {
                try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                    videoTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                    FileUtil.write((File)videoTempFile, (InputStream)inputStream);
                }
            }
            if (!this.hasPreviews(destinationFileVersion)) {
                String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                for (int i = 0; i < _PREVIEW_TYPES.length; ++i) {
                    previewTempFiles[i] = this.getPreviewTempFile(tempFileId, _PREVIEW_TYPES[i]);
                }
                try {
                    this._generateVideo(destinationFileVersion, videoTempFile, previewTempFiles);
                }
                catch (Exception exception) {
                    _fileVersionPreviewEventListener.onFailure(destinationFileVersion);
                    _log.error((Throwable)exception);
                }
            }
            if (!this.hasThumbnails(destinationFileVersion)) {
                try {
                    this._generateThumbnail(destinationFileVersion, videoTempFile);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            _fileVersionPreviewEventListener.onFailure(destinationFileVersion);
        }
        finally {
            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            for (File previewTempFile : previewTempFiles) {
                FileUtil.delete((File)previewTempFile);
            }
            FileUtil.delete((File)videoTempFile);
        }
    }

    private boolean _hasVideo(FileVersion fileVersion) throws Exception {
        return this.hasPreviews(fileVersion) && this.hasThumbnails(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_video_processor", sourceFileVersion, destinationFileVersion);
    }
}

