/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.portlet.MutablePortletParameters;
import javax.portlet.PortletParameters;

public abstract class BasePortletParametersImpl<T extends MutablePortletParameters>
implements PortletParameters {
    private final Function<Map<String, String[]>, T> _mutablePortletParametersCreator;
    private final String _namespace;
    private final Map<String, String[]> _parameterMap;

    public BasePortletParametersImpl(Map<String, String[]> parameterMap, String namespace, Function<Map<String, String[]>, T> mutablePortletParametersCreator) {
        this._parameterMap = parameterMap;
        this._namespace = namespace;
        this._mutablePortletParametersCreator = mutablePortletParametersCreator;
    }

    public T clone() {
        return (T)((MutablePortletParameters)this._mutablePortletParametersCreator.apply(this.deepCopyMap(this.getParameterMap())));
    }

    public Set<String> getNames() {
        if (this._parameterMap == null) {
            return Collections.emptySet();
        }
        Set<String> keySet = this._parameterMap.keySet();
        if (this._namespace == null) {
            return keySet;
        }
        return new NameHashSet(keySet, this._namespace);
    }

    public String getValue(String name) {
        String[] values = this.getValues(name);
        if (values == null || values.length < 1) {
            return null;
        }
        return values[0];
    }

    public String[] getValues(String name) {
        String[] values = this._parameterMap.get(name);
        if (values != null) {
            return values;
        }
        if (this._namespace != null && name != null && (values = this._parameterMap.get(this._namespace.concat(name))) == null && name.startsWith(this._namespace)) {
            values = this._parameterMap.get(name.substring(this._namespace.length()));
        }
        return values;
    }

    public boolean isEmpty() {
        return this._parameterMap.isEmpty();
    }

    public int size() {
        return this._parameterMap.size();
    }

    protected Map<String, String[]> deepCopyMap(Map<String, String[]> map) {
        HashMap<String, String[]> copiedMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            String[] values = entry.getValue();
            if (values == null) {
                copiedMap.put(key, null);
                continue;
            }
            String[] copiedParameterValues = (String[])values.clone();
            copiedMap.put(key, copiedParameterValues);
        }
        return copiedMap;
    }

    protected Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    private static class NameHashSet
    extends HashSet<String> {
        private String _namespace;

        @Override
        public boolean contains(Object name) {
            if (super.contains(name)) {
                return true;
            }
            if (!(name instanceof String)) {
                return false;
            }
            String nameString = (String)name;
            if (nameString.startsWith(this._namespace)) {
                return super.contains(nameString.substring(this._namespace.length()));
            }
            return false;
        }

        private NameHashSet(Set<String> names, String namespace) {
            for (String name : names) {
                if (name.startsWith(namespace)) {
                    this.add(name.substring(namespace.length()));
                    continue;
                }
                this.add(name);
            }
            this._namespace = namespace;
        }
    }
}

