/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeHotDeployListener
extends BaseHotDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(ThemeHotDeployListener.class);
    private static final Map<String, List<Theme>> _themes = new HashMap<String, List<Theme>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error registering themes for ", throwable);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable throwable) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering themes for ", throwable);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-look-and-feel.xml"))})[0] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering themes for " + servletContextName));
        }
        FileTimestampUtil.reset((ServletContext)servletContext);
        List themes = ThemeLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        _themes.put(servletContextName, themes);
        servletContext.setAttribute("PLUGIN_THEMES", (Object)themes);
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{themes.size(), " themes for ", servletContextName, " are available for use"}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Theme> themes;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((themes = _themes.remove(servletContextName)) != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unregistering themes for " + servletContextName));
            }
            try {
                ThemeLocalServiceUtil.uninstallThemes(themes);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        } else {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            TemplateResourceLoaderUtil.clearCache((String)"ftl");
            TemplateResourceLoaderUtil.clearCache((String)"vm");
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{themes.size(), " themes for ", servletContextName, " were unregistered"}));
            }
        }
    }
}

