/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.osgi.framework.BundleContext;

public class Log4jLogContextLogWrapper
extends LogWrapper {
    private static volatile ServiceTrackerList<LogContext> _serviceTrackerList;

    public Log4jLogContextLogWrapper(Log log) {
        super(log);
        this.setLogWrapperClassName(Log4jLogContextLogWrapper.class.getName());
    }

    public void debug(Object message) {
        this._populateThreadContext();
        super.debug(message);
    }

    public void debug(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.debug(message, throwable);
    }

    public void debug(Throwable throwable) {
        this._populateThreadContext();
        super.debug(null, throwable);
    }

    public void error(Object message) {
        this._populateThreadContext();
        super.error(message);
    }

    public void error(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.error(message, throwable);
    }

    public void error(Throwable throwable) {
        this._populateThreadContext();
        super.error(null, throwable);
    }

    public void fatal(Object message) {
        this._populateThreadContext();
        super.fatal(message);
    }

    public void fatal(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.fatal(message, throwable);
    }

    public void fatal(Throwable throwable) {
        this._populateThreadContext();
        super.fatal(null, throwable);
    }

    public void info(Object message) {
        this._populateThreadContext();
        super.info(message);
    }

    public void info(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.info(message, throwable);
    }

    public void info(Throwable throwable) {
        this._populateThreadContext();
        super.info(null, throwable);
    }

    public void trace(Object message) {
        this._populateThreadContext();
        super.trace(message);
    }

    public void trace(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.trace(message, throwable);
    }

    public void trace(Throwable throwable) {
        this._populateThreadContext();
        super.trace(null, throwable);
    }

    public void warn(Object message) {
        this._populateThreadContext();
        super.warn(message);
    }

    public void warn(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.warn(message, throwable);
    }

    public void warn(Throwable throwable) {
        this._populateThreadContext();
        super.warn(null, throwable);
    }

    private void _populateThreadContext() {
        ServiceTrackerList<LogContext> serviceTrackerList = _serviceTrackerList;
        if (serviceTrackerList == null) {
            return;
        }
        for (LogContext logContext : serviceTrackerList) {
            Map context = logContext.getContext();
            for (Map.Entry entry : context.entrySet()) {
                ThreadContext.put((String)(logContext.getName() + "." + (String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
    }

    static {
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                ServiceTrackerList serviceTrackerList = _serviceTrackerList;
                _serviceTrackerList = null;
                if (serviceTrackerList != null) {
                    serviceTrackerList.close();
                }
            }

            protected void doPortalInit() {
                _serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), LogContext.class);
            }
        }, (int)0);
    }
}

