/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PersistedModelLocalServiceRegistryImpl
implements PersistedModelLocalServiceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PersistedModelLocalServiceRegistryImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final Map<String, PersistedModelLocalService> _persistedModelLocalServices = new ConcurrentHashMap<String, PersistedModelLocalService>();
    private final ServiceTracker<?, ?> _serviceTracker = new ServiceTracker(this._bundleContext, SystemBundleUtil.createFilter((String)StringBundler.concat((String[])new String[]{"(&(model.class.name=*)(objectClass=", PersistedModelLocalService.class.getName(), "))"})), (ServiceTrackerCustomizer)new PersistenceModelLocalServiceServiceTrackerCustomizer());

    public PersistedModelLocalServiceRegistryImpl() {
        this._serviceTracker.open();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    public PersistedModelLocalService getPersistedModelLocalService(String className) {
        return this._persistedModelLocalServices.get(className);
    }

    public List<PersistedModelLocalService> getPersistedModelLocalServices() {
        return ListUtil.fromMapValues(this._persistedModelLocalServices);
    }

    public void register(String className, PersistedModelLocalService persistedModelLocalService) {
        PersistedModelLocalService oldPersistedModelLocalService = this._persistedModelLocalServices.put(className, persistedModelLocalService);
        if (oldPersistedModelLocalService != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Duplicate class name " + className));
        }
    }

    public void unregister(String className) {
        this._persistedModelLocalServices.remove(className);
    }

    private class PersistenceModelLocalServiceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PersistedModelLocalService, String> {
        private PersistenceModelLocalServiceServiceTrackerCustomizer() {
        }

        public String addingService(ServiceReference<PersistedModelLocalService> serviceReference) {
            String className = (String)serviceReference.getProperty("model.class.name");
            PersistedModelLocalService persistedModelLocalService = (PersistedModelLocalService)PersistedModelLocalServiceRegistryImpl.this._bundleContext.getService(serviceReference);
            PersistedModelLocalServiceRegistryImpl.this.register(className, persistedModelLocalService);
            return className;
        }

        public void modifiedService(ServiceReference<PersistedModelLocalService> serviceReference, String className) {
            if (!Objects.equals(serviceReference.getProperty("model.class.name"), className)) {
                this.removedService(serviceReference, className);
                this.addingService((ServiceReference)serviceReference);
            }
        }

        public void removedService(ServiceReference<PersistedModelLocalService> serviceReference, String className) {
            PersistedModelLocalServiceRegistryImpl.this.unregister(className);
            PersistedModelLocalServiceRegistryImpl.this._bundleContext.ungetService(serviceReference);
        }
    }
}

