/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceHttp.class);
    private static final Class<?>[] _addTeamParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteTeamParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupTeamsParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserTeamsParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserTeamsParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _hasUserTeamParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _searchParameterTypes8 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class};
    private static final Class<?>[] _updateTeamParameterTypes10 = new Class[]{Long.TYPE, String.class, String.class};

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "addTeam", (Class[])_addTeamParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Team)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "deleteTeam", (Class[])_deleteTeamParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Team> getGroupTeams(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getGroupTeams", (Class[])_getGroupTeamsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Team)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Team)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static boolean hasUserTeam(HttpPrincipal httpPrincipal, long userId, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "hasUserTeam", (Class[])_hasUserTeamParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Team> search(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> orderByComparator) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "search", (Class[])_searchParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, params, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "searchCount", (Class[])_searchCountParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, params});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Team updateTeam(HttpPrincipal httpPrincipal, long teamId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "updateTeam", (Class[])_updateTeamParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Team)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

