/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.absoluteredirects;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.TryFilter;
import com.liferay.portal.kernel.servlet.WrapHttpServletResponseFilter;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.util.PortalInstances;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AbsoluteRedirectsFilter
extends BasePortalFilter
implements TryFilter,
WrapHttpServletResponseFilter {
    private static final boolean _FILTER_ENABLED = true;
    private static final Log _log = LogFactoryUtil.getLog(AbsoluteRedirectsFilter.class);

    public Object doFilterTry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (httpServletRequest.getCharacterEncoding() == null) {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        long companyId = PortalInstances.getCompanyId(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id " + companyId));
        }
        PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest);
        PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        Boolean httpsInitial = (Boolean)httpSession.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null) {
            httpsInitial = httpServletRequest.isSecure();
            httpSession.setAttribute("HTTPS_INITIAL", (Object)httpsInitial);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting httpsInitial to " + httpsInitial));
            }
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        return null;
    }

    public HttpServletResponse getWrappedHttpServletResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new AbsoluteRedirectsResponse(httpServletRequest, httpServletResponse);
    }

    @Override
    public boolean isFilterEnabled() {
        return true;
    }
}

