/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeKernelPackage
extends UpgradeProcess {
    private static final String[][] _CLASS_NAMES = new String[][]{{"com.liferay.counter.model.Counter", "com.liferay.counter.kernel.model.Counter"}, {"com.liferay.portal.kernel.mail.Account", "com.liferay.mail.kernel.model.Account"}, {"com.liferay.portal.model.BackgroundTask", "com.liferay.portal.background.task.model.BackgroundTask"}, {"com.liferay.portal.model.Lock", "com.liferay.portal.lock.model.Lock"}, {"com.liferay.portal.model.", "com.liferay.portal.kernel.model."}, {"com.liferay.portlet.announcements.model.", "com.liferay.announcements.kernel.model."}, {"com.liferay.portlet.asset.model.", "com.liferay.asset.kernel.model."}, {"com.liferay.portlet.blogs.model.", "com.liferay.blogs.kernel.model."}, {"com.liferay.portlet.documentlibrary.model.", "com.liferay.document.library.kernel.model."}, {"com.liferay.portlet.documentlibrary.util.", "com.liferay.document.library.kernel.util."}, {"com.liferay.portlet.expando.model.", "com.liferay.expando.kernel.model."}, {"com.liferay.portlet.journal.model.", "com.liferay.journal.model."}, {"com.liferay.portlet.messageboards.model.", "com.liferay.message.boards.kernel.model."}, {"com.liferay.portlet.mobiledevicerules.model.", "com.liferay.mobile.device.rules.model."}, {"com.liferay.portlet.ratings.model.", "com.liferay.ratings.kernel.model."}, {"com.liferay.portlet.social.model.", "com.liferay.social.kernel.model."}, {"com.liferay.portlet.trash.model.", "com.liferay.trash.kernel.model."}, {"com.liferay.socialnetworking.model.", "com.liferay.social.networking.model."}};
    private static final String[][] _RESOURCE_NAMES = new String[][]{{"com.liferay.portlet.asset", "com.liferay.asset"}, {"com.liferay.portlet.blogs", "com.liferay.blogs"}, {"com.liferay.portlet.documentlibrary", "com.liferay.document.library"}, {"com.liferay.portlet.journal", "com.liferay.journal"}, {"com.liferay.portlet.messageboards", "com.liferay.message.boards"}};

    protected void doUpgrade() throws UpgradeException {
        try {
            this.upgradeTable("ClassName_", "value", this.getClassNames(), WildcardMode.SURROUND, true);
            this.upgradeTable("Counter", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("Lock_", "className", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ResourceAction", "name", this.getClassNames(), WildcardMode.SURROUND, true);
            this.upgradeTable("ResourcePermission", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeLongTextTable("UserNotificationEvent", "payload", "userNotificationEventId", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ListType", "type_", this.getClassNames(), WildcardMode.TRAILING);
            this.upgradeTable("ResourceAction", "name", this.getResourceNames(), WildcardMode.LEADING, true);
            this.upgradeTable("ResourcePermission", "name", this.getResourceNames(), WildcardMode.LEADING);
            this.upgradeLongTextTable("UserNotificationEvent", "payload", "userNotificationEventId", this.getResourceNames(), WildcardMode.LEADING);
            DBInspector dbInspector = new DBInspector(this.connection);
            if (dbInspector.hasTable("ResourceBlock")) {
                this.upgradeTable("ResourceBlock", "name", this.getClassNames(), WildcardMode.SURROUND);
                this.upgradeTable("ResourceBlock", "name", this.getResourceNames(), WildcardMode.LEADING);
            }
        }
        catch (Exception exception) {
            throw new UpgradeException((Throwable)exception);
        }
    }

    protected String[][] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String[][] getResourceNames() {
        return _RESOURCE_NAMES;
    }

    protected void upgradeLongTextTable(String columnName, String primaryKeyColumnName, String selectSQL, String updateSQL, String[] name) throws SQLException {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(selectSQL);
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(updateSQL));){
            while (resultSet.next()) {
                preparedStatement2.setString(1, StringUtil.replace((String)resultSet.getString(columnName), (String)name[0], (String)name[1]));
                preparedStatement2.setLong(2, resultSet.getLong(primaryKeyColumnName));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void upgradeLongTextTable(String tableName, String columnName, String primaryKeyColumnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SYBASE) {
            this.upgradeTable(tableName, columnName, names, wildcardMode);
            return;
        }
        try (LoggingTimer loggingTimer = new LoggingTimer(((Object)((Object)this)).getClass(), tableName);){
            String updateSQL = StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ? where ", primaryKeyColumnName, " = ?"});
            String selectPrefix = StringBundler.concat((String[])new String[]{"select ", columnName, ", ", primaryKeyColumnName, " from ", tableName, " where ", columnName, " like '", wildcardMode.getLeadingWildcard()});
            String selectPostfix = wildcardMode.getTrailingWildcard() + "'";
            for (String[] name : names) {
                this.upgradeLongTextTable(columnName, primaryKeyColumnName, StringBundler.concat((String[])new String[]{selectPrefix, name[0], selectPostfix}), updateSQL, name);
            }
        }
    }

    protected void upgradeTable(String tableName, String columnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        this.upgradeTable(tableName, columnName, names, wildcardMode, false);
    }

    protected void upgradeTable(String tableName, String columnName, String[][] names, WildcardMode wildcardMode, boolean preventDuplicates) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(((Object)((Object)this)).getClass(), tableName);){
            if (preventDuplicates) {
                this._executeDelete(tableName, columnName, names, wildcardMode);
            }
            this._executeUpdate(tableName, columnName, names, wildcardMode);
        }
    }

    private void _executeDelete(String tableName, String columnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        for (Object[] objectArray : names) {
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from ", tableName, this._getWhereClause(columnName, objectArray[1], wildcardMode), this._getNotLikeClause(columnName, (String)ArrayUtil.getValue((Object[])objectArray, (int)2), wildcardMode)}));
        }
    }

    private void _executeUpdate(String tableName, String columnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        String tableSQL = StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = replace(", this._transformColumnName(columnName), ", '"});
        StringBundler sb2 = new StringBundler(6);
        for (String[] name : names) {
            sb2.append(tableSQL);
            sb2.append(name[0]);
            sb2.append("', '");
            sb2.append(name[1]);
            sb2.append("') ");
            sb2.append(this._getWhereClause(columnName, name[0], wildcardMode));
            this.runSQL(sb2.toString());
            sb2.setIndex(0);
        }
    }

    private String _getNotLikeClause(String columnName, String value, WildcardMode wildcardMode) {
        if (value == null) {
            return "";
        }
        return StringBundler.concat((String[])new String[]{" and ", columnName, " not like '", wildcardMode.getLeadingWildcard(), value, wildcardMode.getTrailingWildcard(), "'"});
    }

    private String _getWhereClause(String columnName, String columnValue, WildcardMode wildcardMode) {
        return StringBundler.concat((String[])new String[]{" where ", columnName, " like '", wildcardMode.getLeadingWildcard(), columnValue, wildcardMode.getTrailingWildcard(), "'"});
    }

    private String _transformColumnName(String columnName) {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.SQLSERVER) {
            return "CAST_TEXT(" + columnName + ")";
        }
        return columnName;
    }
}

