/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.exception.EntryContentException;
import com.liferay.announcements.kernel.exception.EntryExpirationDateException;
import com.liferay.announcements.kernel.exception.EntryTitleException;
import com.liferay.announcements.kernel.exception.EntryURLException;
import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.announcements.kernel.service.AnnouncementsFlagLocalService;
import com.liferay.announcements.kernel.service.persistence.AnnouncementsDeliveryPersistence;
import com.liferay.announcements.kernel.service.persistence.AnnouncementsFlagPersistence;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryLocalServiceBaseImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;

public class AnnouncementsEntryLocalServiceImpl
extends AnnouncementsEntryLocalServiceBaseImpl {
    @BeanReference(type=MailService.class)
    protected MailService mailService;
    private static final long _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL = (long)PropsValues.ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL * 60000L;
    private static final Log _log = LogFactoryUtil.getLog(AnnouncementsEntryLocalServiceImpl.class);
    @BeanReference(type=AnnouncementsDeliveryLocalService.class)
    private AnnouncementsDeliveryLocalService _announcementsDeliveryLocalService;
    @BeanReference(type=AnnouncementsDeliveryPersistence.class)
    private AnnouncementsDeliveryPersistence _announcementsDeliveryPersistence;
    @BeanReference(type=AnnouncementsFlagLocalService.class)
    private AnnouncementsFlagLocalService _announcementsFlagLocalService;
    @BeanReference(type=AnnouncementsFlagPersistence.class)
    private AnnouncementsFlagPersistence _announcementsFlagPersistence;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=CompanyPersistence.class)
    private CompanyPersistence _companyPersistence;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=OrganizationPersistence.class)
    private OrganizationPersistence _organizationPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=RolePersistence.class)
    private RolePersistence _rolePersistence;
    @BeanReference(type=UserGroupPersistence.class)
    private UserGroupPersistence _userGroupPersistence;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public AnnouncementsEntry addEntry(long userId, long classNameId, long classPK, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority, boolean alert) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        this.validate(title, content, url, displayDate, expirationDate);
        long entryId = this.counterLocalService.increment();
        AnnouncementsEntry entry = this.announcementsEntryPersistence.create(entryId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setClassNameId(classNameId);
        entry.setClassPK(classPK);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        entry.setAlert(alert);
        entry = (AnnouncementsEntry)this.announcementsEntryPersistence.update((BaseModel)entry);
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), false, false, false);
        return entry;
    }

    public void checkEntries() throws PortalException {
        Date date = new Date();
        Date previousCheckDate = new Date(date.getTime() - _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL);
        this.checkEntries(previousCheckDate, date);
    }

    public void checkEntries(Date startDate, Date endDate) throws PortalException {
        List entries = this.announcementsEntryFinder.findByDisplayDate(endDate, startDate);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries"));
        }
        for (AnnouncementsEntry entry : entries) {
            this.notifyUsers(entry);
        }
    }

    public void deleteEntries(long companyId) {
        this._announcementsDeliveryPersistence.removeByCompanyId(companyId);
        this._announcementsFlagPersistence.removeByCompanyId(companyId);
        this.announcementsEntryPersistence.removeByCompanyId(companyId);
    }

    public void deleteEntries(long classNameId, long classPK) throws PortalException {
        List entries = this.announcementsEntryPersistence.findByC_C(classNameId, classPK);
        for (AnnouncementsEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntries(long companyId, long classNameId, long classPK) throws PortalException {
        List entries = this.announcementsEntryPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (AnnouncementsEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    @SystemEvent(type=1)
    public void deleteEntry(AnnouncementsEntry entry) throws PortalException {
        this.announcementsEntryPersistence.remove((BaseModel)entry);
        this._resourceLocalService.deleteResource(entry.getCompanyId(), AnnouncementsEntry.class.getName(), 4, entry.getEntryId());
        this._announcementsFlagLocalService.deleteFlags(entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException {
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue, int start, int end) {
        return this.getEntries(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        return this.announcementsEntryFinder.findByScopes(user.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long companyId, long classNameId, long classPK, boolean alert, int start, int end) {
        return this.announcementsEntryPersistence.findByC_C_C_A(companyId, classNameId, classPK, alert, start, end);
    }

    public List<AnnouncementsEntry> getEntries(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        return this.announcementsEntryFinder.findByScope(user.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return 0;
        }
        return this.announcementsEntryFinder.countByScopes(user.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public int getEntriesCount(long companyId, long classNameId, long classPK, boolean alert) {
        return this.announcementsEntryPersistence.countByC_C_C_A(companyId, classNameId, classPK, alert);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, classNameId, classPKs, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    public int getEntriesCount(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return 0;
        }
        return this.announcementsEntryFinder.countByScope(user.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    public AnnouncementsEntry getEntry(long entryId) throws PortalException {
        return this.announcementsEntryPersistence.findByPrimaryKey(entryId);
    }

    public List<AnnouncementsEntry> getUserEntries(long userId, int start, int end) {
        return this.announcementsEntryPersistence.findByUserId(userId, start, end);
    }

    public int getUserEntriesCount(long userId) {
        return this.announcementsEntryPersistence.countByUserId(userId);
    }

    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority) throws PortalException {
        this.validate(title, content, url, displayDate, expirationDate);
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        entry = (AnnouncementsEntry)this.announcementsEntryPersistence.update((BaseModel)entry);
        this._announcementsFlagLocalService.deleteFlags(entry.getEntryId());
        return entry;
    }

    protected void notifyUsers(AnnouncementsEntry entry) throws PortalException {
        Company company = this._companyPersistence.findByPrimaryKey(entry.getCompanyId());
        String className = entry.getClassName();
        long classPK = entry.getClassPK();
        String toName = PropsValues.ANNOUNCEMENTS_EMAIL_TO_NAME;
        long teamId = 0L;
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"announcementsDeliveryEmailOrSms", (Object)entry.getType()).build();
        if (classPK > 0L) {
            if (className.equals(Group.class.getName())) {
                Group group = this._groupPersistence.findByPrimaryKey(classPK);
                toName = group.getDescriptiveName();
                params.put("inherit", Boolean.TRUE);
                params.put("usersGroups", classPK);
            } else if (className.equals(Organization.class.getName())) {
                Organization organization = this._organizationPersistence.findByPrimaryKey(classPK);
                toName = organization.getName();
                params.put("usersOrgsTree", ListUtil.fromArray((Object[])new Organization[]{organization}));
            } else if (className.equals(Role.class.getName())) {
                Role role = this._rolePersistence.findByPrimaryKey(classPK);
                toName = role.getName();
                if (role.getType() == 1) {
                    params.put("inherit", Boolean.TRUE);
                    params.put("usersRoles", classPK);
                } else if (role.isTeam()) {
                    teamId = role.getClassPK();
                } else {
                    params.put("userGroupRole", new Long[]{0L, classPK});
                }
            } else if (className.equals(UserGroup.class.getName())) {
                UserGroup userGroup = this._userGroupPersistence.findByPrimaryKey(classPK);
                toName = userGroup.getName();
                params.put("usersUserGroups", classPK);
            }
        }
        if (className.equals(User.class.getName())) {
            User user = this._userPersistence.findByPrimaryKey(classPK);
            if (Validator.isNull((String)user.getEmailAddress())) {
                return;
            }
            this.notifyUsers(ListUtil.fromArray((Object[])new User[]{user}), entry, company.getLocale(), user.getEmailAddress(), user.getFullName());
        } else {
            String toAddress = PropsValues.ANNOUNCEMENTS_EMAIL_TO_ADDRESS;
            this.notifyUsers(entry, teamId, params, toName, toAddress, company);
        }
    }

    protected void notifyUsers(AnnouncementsEntry entry, long teamId, LinkedHashMap<String, Object> params, String toName, String toAddress, Company company) throws PortalException {
        int total = 0;
        total = teamId > 0L ? this._userLocalService.getTeamUsersCount(teamId) : this._userLocalService.searchCount(company.getCompanyId(), null, 0, params);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List users = null;
            users = teamId > 0L ? this._userLocalService.getTeamUsers(teamId, start, end) : this._userLocalService.search(company.getCompanyId(), null, 0, params, start, end, (OrderByComparator)null);
            this.notifyUsers(users, entry, company.getLocale(), toAddress, toName);
            intervalActionProcessor.incrementStart(users.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void notifyUsers(List<User> users, AnnouncementsEntry entry, Locale locale, String toAddress, String toName) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Notifying " + users.size() + " users"));
        }
        HashMap<String, String> notifyUsersFullNames = new HashMap<String, String>();
        for (User user : users) {
            AnnouncementsDelivery announcementsDelivery = this._announcementsDeliveryLocalService.getUserDelivery(user.getUserId(), entry.getType());
            if (announcementsDelivery.isEmail()) {
                notifyUsersFullNames.put(user.getEmailAddress(), user.getFullName());
            }
            if (!announcementsDelivery.isSms()) continue;
            Contact contact = user.getContact();
            notifyUsersFullNames.put(contact.getSmsSn(), user.getFullName());
        }
        if (notifyUsersFullNames.isEmpty()) {
            return;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String body = null;
        try {
            body = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)PropsValues.ANNOUNCEMENTS_EMAIL_BODY);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read the content for " + PropsValues.ANNOUNCEMENTS_EMAIL_BODY));
        }
        String fromAddress = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.address", "admin.email.from.address");
        String fromName = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.name", "admin.email.from.name");
        String subject = null;
        try {
            subject = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)PropsValues.ANNOUNCEMENTS_EMAIL_SUBJECT);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read the content for " + PropsValues.ANNOUNCEMENTS_EMAIL_SUBJECT));
        }
        Company company = this._companyLocalService.getCompany(entry.getCompanyId());
        this._sendNotificationEmail(fromAddress, fromName, toAddress, toName, subject, body, company, entry);
        for (Map.Entry curEntry : notifyUsersFullNames.entrySet()) {
            this._sendNotificationEmail(fromAddress, fromName, (String)curEntry.getKey(), (String)curEntry.getValue(), subject, body, company, entry);
        }
    }

    protected void validate(String title, String content, String url, Date displayDate, Date expirationDate) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        int titleMaxLength = ModelHintsUtil.getMaxLength((String)AnnouncementsEntry.class.getName(), (String)"title");
        if (title.length() > titleMaxLength) {
            throw new EntryTitleException("Title has more than " + titleMaxLength + " characters");
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
        if (Validator.isNotNull((String)url) && !Validator.isUrl((String)url)) {
            throw new EntryURLException();
        }
        if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
            throw new EntryExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
    }

    private void _sendNotificationEmail(String fromAddress, String fromName, String toAddress, String toName, String subject, String body, Company company, AnnouncementsEntry entry) throws PortalException {
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$COMPANY_ID$]", String.valueOf(company.getCompanyId()));
        mailTemplateContextBuilder.put("[$COMPANY_MX$]", company.getMx());
        mailTemplateContextBuilder.put("[$COMPANY_NAME$]", HtmlUtil.escape((String)company.getName()));
        mailTemplateContextBuilder.put("[$ENTRY_CONTENT$]", entry.getContent());
        mailTemplateContextBuilder.put("[$ENTRY_ID$]", String.valueOf(entry.getEntryId()));
        mailTemplateContextBuilder.put("[$ENTRY_TITLE$]", HtmlUtil.escape((String)entry.getTitle()));
        mailTemplateContextBuilder.put("[$ENTRY_TYPE$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get((Locale)locale, (String)entry.getType())));
        mailTemplateContextBuilder.put("[$ENTRY_URL$]", entry.getUrl());
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", fromAddress);
        mailTemplateContextBuilder.put("[$FROM_NAME$]", HtmlUtil.escape((String)fromName));
        mailTemplateContextBuilder.put("[$PORTAL_URL$]", company.getPortalURL(0L));
        mailTemplateContextBuilder.put("[$PORTLET_NAME$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get((Locale)locale, (String)(entry.isAlert() ? "alert" : "announcement"))));
        if (entry.getGroupId() > 0L) {
            Group group = this._groupLocalService.getGroup(entry.getGroupId());
            mailTemplateContextBuilder.put("[$SITE_NAME$]", HtmlUtil.escape((String)group.getDescriptiveName()));
        }
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", toAddress);
        mailTemplateContextBuilder.put("[$TO_NAME$]", HtmlUtil.escape((String)toName));
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        try {
            MailTemplate subjectTemplate = MailTemplateFactoryUtil.createMailTemplate((String)subject, (boolean)false);
            MailTemplate bodyTemplate = MailTemplateFactoryUtil.createMailTemplate((String)body, (boolean)true);
            User user = this._userLocalService.fetchUserByEmailAddress(entry.getCompanyId(), toAddress);
            Locale locale2 = LocaleUtil.getSiteDefault();
            if (user != null) {
                locale2 = user.getLocale();
            }
            MailMessage mailMessage = new MailMessage(new InternetAddress(fromAddress, fromName), new InternetAddress(toAddress, toName), subjectTemplate.renderAsString(locale2, mailTemplateContext), bodyTemplate.renderAsString(locale2, mailTemplateContext), true);
            mailMessage.setMessageId(PortalUtil.getMailId((String)company.getMx(), (String)"announcements_entry", (Object[])new Object[]{entry.getEntryId()}));
            this.mailService.sendEmail(mailMessage);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

