/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashSet;

public class AssetVocabularySettingsHelper {
    public static final long[] DEFAULT_SELECTED_CLASS_NAME_IDS = new long[]{0L};
    public static final long[] DEFAULT_SELECTED_CLASS_TYPE_PKS = new long[]{-1L};
    private static final String _KEY_MULTI_VALUED = "multiValued";
    private static final String _KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS = "requiredClassNameIds";
    private static final String _KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS = "selectedClassNameIds";
    private final UnicodeProperties _unicodeProperties = new UnicodeProperties(true);

    public AssetVocabularySettingsHelper() {
    }

    public AssetVocabularySettingsHelper(String propertiesString) {
        this();
        this._unicodeProperties.fastLoad(propertiesString);
    }

    public long[] getClassNameIds() {
        return this.getClassNameIds(this.getClassNameIdsAndClassTypePKs());
    }

    public long[] getClassTypePKs() {
        return this.getClassTypePKs(this.getClassNameIdsAndClassTypePKs());
    }

    public long[] getRequiredClassNameIds() {
        String[] classNameIdsAndClassTypePKs = this.getRequiredClassNameIdsAndClassTypePKs();
        return this.getClassNameIds(classNameIdsAndClassTypePKs);
    }

    public long[] getRequiredClassTypePKs() {
        String[] classNameIdsAndClassTypePKs = this.getRequiredClassNameIdsAndClassTypePKs();
        return this.getClassTypePKs(classNameIdsAndClassTypePKs);
    }

    public boolean hasClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        return this.isClassNameIdAndClassTypePKSpecified(classNameId, classTypePK, this.getClassNameIdsAndClassTypePKs());
    }

    public boolean isClassNameIdAndClassTypePKRequired(long classNameId, long classTypePK) {
        return this.isClassNameIdAndClassTypePKSpecified(classNameId, classTypePK, this.getRequiredClassNameIdsAndClassTypePKs());
    }

    public boolean isMultiValued() {
        String value = this._unicodeProperties.getProperty(_KEY_MULTI_VALUED);
        return GetterUtil.getBoolean((String)value, (boolean)true);
    }

    public void setClassNameIdsAndClassTypePKs(long[] classNameIds, long[] classTypePKs, boolean[] requireds) {
        LinkedHashSet<String> requiredClassNameIds = new LinkedHashSet<String>();
        LinkedHashSet<String> selectedClassNameIds = new LinkedHashSet<String>();
        for (int i = 0; i < classNameIds.length; ++i) {
            long classNameId = classNameIds[i];
            long classTypePK = classTypePKs[i];
            boolean required = requireds[i];
            String classNameIdAndClassTypePK = this.getClassNameIdAndClassTypePK(classNameId, classTypePK);
            if (classNameIdAndClassTypePK.equals("0:-1") && required) {
                requiredClassNameIds.clear();
                requiredClassNameIds.add(classNameIdAndClassTypePK);
                selectedClassNameIds.clear();
                selectedClassNameIds.add(classNameIdAndClassTypePK);
                break;
            }
            if (required) {
                requiredClassNameIds.add(classNameIdAndClassTypePK);
            }
            selectedClassNameIds.add(classNameIdAndClassTypePK);
        }
        if (selectedClassNameIds.contains("0:-1")) {
            selectedClassNameIds.clear();
            selectedClassNameIds.add("0:-1");
            selectedClassNameIds.addAll(requiredClassNameIds);
        }
        this._unicodeProperties.setProperty(_KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS, StringUtil.merge(requiredClassNameIds));
        this._unicodeProperties.setProperty(_KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS, StringUtil.merge(selectedClassNameIds));
    }

    public void setMultiValued(boolean multiValued) {
        this._unicodeProperties.setProperty(_KEY_MULTI_VALUED, String.valueOf(multiValued));
    }

    public String toString() {
        return this._unicodeProperties.toString();
    }

    protected long getClassNameId(String classNameIdAndClassTypePK) {
        String[] parts = StringUtil.split((String)classNameIdAndClassTypePK, (char)':');
        return GetterUtil.getLong((String)parts[0]);
    }

    protected String getClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        return StringBundler.concat((Object[])new Object[]{classNameId, ":", classTypePK});
    }

    protected long[] getClassNameIds(String[] classNameIdsAndClassTypePKs) {
        long[] classNameIds = new long[classNameIdsAndClassTypePKs.length];
        for (int i = 0; i < classNameIdsAndClassTypePKs.length; ++i) {
            long classNameId;
            classNameIds[i] = classNameId = this.getClassNameId(classNameIdsAndClassTypePKs[i]);
        }
        return classNameIds;
    }

    protected String[] getClassNameIdsAndClassTypePKs() {
        String value = this._unicodeProperties.getProperty(_KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS);
        if (Validator.isNull((String)value)) {
            return new String[]{this.getClassNameIdAndClassTypePK(0L, -1L)};
        }
        return StringUtil.split((String)value);
    }

    protected long getClassTypePK(String classNameIdAndClassTypePK) {
        String[] parts = StringUtil.split((String)classNameIdAndClassTypePK, (char)':');
        if (parts.length == 1) {
            return -1L;
        }
        return GetterUtil.getLong((String)parts[1]);
    }

    protected long[] getClassTypePKs(String[] classNameIdsAndClassTypePKs) {
        long[] classTypePKs = new long[classNameIdsAndClassTypePKs.length];
        for (int i = 0; i < classNameIdsAndClassTypePKs.length; ++i) {
            long classTypePK;
            classTypePKs[i] = classTypePK = this.getClassTypePK(classNameIdsAndClassTypePKs[i]);
        }
        return classTypePKs;
    }

    protected String[] getRequiredClassNameIdsAndClassTypePKs() {
        String value = this._unicodeProperties.getProperty(_KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS);
        if (Validator.isNull((String)value)) {
            return new String[0];
        }
        return StringUtil.split((String)value);
    }

    protected boolean isClassNameIdAndClassTypePKSpecified(long classNameId, long classTypePK, String[] classNameIdsAndClassTypePKs) {
        if (classNameIdsAndClassTypePKs.length == 0) {
            return false;
        }
        if (classNameIdsAndClassTypePKs[0].equals("0:-1") || ArrayUtil.contains((Object[])classNameIdsAndClassTypePKs, (Object)this.getClassNameIdAndClassTypePK(classNameId, classTypePK))) {
            return true;
        }
        String classNameIdAndAllClassTypePK = this.getClassNameIdAndClassTypePK(classNameId, -1L);
        return ArrayUtil.contains((Object[])classNameIdsAndClassTypePKs, (Object)classNameIdAndAllClassTypePK);
    }
}

