/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util.comparator;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.portal.kernel.util.CollatorUtil;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class AssetVocabularyGroupLocalizedTitleComparator
implements Comparator<AssetVocabulary> {
    private final boolean _ascending;
    private final long _groupId;
    private final Locale _locale;

    public AssetVocabularyGroupLocalizedTitleComparator(long groupId, Locale locale, boolean ascending) {
        this._groupId = groupId;
        this._locale = locale;
        this._ascending = ascending;
    }

    @Override
    public int compare(AssetVocabulary assetVocabulary1, AssetVocabulary assetVocabulary2) {
        int value = 0;
        if (assetVocabulary1.getGroupId() == this._groupId && assetVocabulary2.getGroupId() != this._groupId) {
            value = -1;
        } else if (assetVocabulary1.getGroupId() != this._groupId && assetVocabulary2.getGroupId() == this._groupId) {
            value = 1;
        } else if (this._groupId == 0L || assetVocabulary1.getGroupId() != assetVocabulary2.getGroupId()) {
            value = Long.compare(assetVocabulary1.getGroupId(), assetVocabulary2.getGroupId());
        }
        if (value == 0) {
            Collator collator = CollatorUtil.getInstance((Locale)this._locale);
            String assetVocabularyTitle1 = assetVocabulary1.getTitle(this._locale);
            String assetVocabularyTitle2 = assetVocabulary2.getTitle(this._locale);
            value = collator.compare(assetVocabularyTitle1, assetVocabularyTitle2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }
}

