/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletFilterUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.InvokerPortletUtil;
import com.liferay.portlet.internal.FilterChainImpl;
import com.liferay.portlet.internal.HeaderResponseImpl;
import com.liferay.portlet.internal.PortletTypeUtil;
import com.liferay.portlet.internal.RenderRequestImpl;
import com.liferay.portlet.internal.RenderResponseImpl;
import com.liferay.portlet.internal.StateAwareResponseImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public class InvokerPortletImpl
implements InvokerFilterContainer,
InvokerPortlet {
    private static final Log _log = LogFactoryUtil.getLog(InvokerPortletImpl.class);
    private boolean _checkAuthToken;
    private String _errorKey;
    private Integer _expCache;
    private boolean _facesPortlet;
    private boolean _headerPortlet;
    private InvokerFilterContainer _invokerFilterContainer;
    private LiferayPortletConfig _liferayPortletConfig;
    private LiferayPortletContext _liferayPortletContext;
    private Portlet _portlet;
    private ClassLoader _portletClassLoader;
    private String _portletId;
    private com.liferay.portal.kernel.model.Portlet _portletModel;

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean headerPortlet) {
        this._initialize(portletModel, portlet, portletConfig, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, headerPortlet);
    }

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer) {
        Map initParams = portletModel.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        boolean facesPortlet = false;
        Class<?> portletClass = portlet.getClass();
        if (ClassUtil.isSubclass(portletClass, (String)"javax.portlet.faces.GenericFacesPortlet")) {
            facesPortlet = true;
        } else if (portlet instanceof InvokerPortlet) {
            InvokerPortlet invokerPortlet = (InvokerPortlet)portlet;
            facesPortlet = invokerPortlet.isFacesPortlet();
        }
        boolean headerPortlet = PortletTypeUtil.isHeaderPortlet(portlet);
        this._initialize(portletModel, portlet, null, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, headerPortlet);
    }

    public void destroy() {
        if (PortletIdCodec.hasInstanceId((String)this._portletModel.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Destroying an instanced portlet is not allowed");
            }
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(this._portletClassLoader);
            }
            this.cleanUp();
            this._portlet.destroy();
        }
        finally {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public List<ActionFilter> getActionFilters() {
        return this._invokerFilterContainer.getActionFilters();
    }

    public List<EventFilter> getEventFilters() {
        return this._invokerFilterContainer.getEventFilters();
    }

    public Integer getExpCache() {
        return this._expCache;
    }

    public List<HeaderFilter> getHeaderFilters() {
        return this._invokerFilterContainer.getHeaderFilters();
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public ClassLoader getPortletClassLoader() {
        if (this._portlet instanceof InvokerPortlet) {
            InvokerPortlet invokerPortlet = (InvokerPortlet)this._portlet;
            return invokerPortlet.getPortletClassLoader();
        }
        Class<?> portletClass = this._portlet.getClass();
        return portletClass.getClassLoader();
    }

    public PortletConfig getPortletConfig() {
        return this._liferayPortletConfig;
    }

    public PortletContext getPortletContext() {
        return this._liferayPortletContext;
    }

    public Portlet getPortletInstance() {
        return this._portlet;
    }

    public List<RenderFilter> getRenderFilters() {
        return this._invokerFilterContainer.getRenderFilters();
    }

    public List<ResourceFilter> getResourceFilters() {
        return this._invokerFilterContainer.getResourceFilters();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        this._portletClassLoader = this.getPortletClassLoader();
        try {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(this._portletClassLoader);
            }
            this._portlet.init(portletConfig);
        }
        catch (Throwable throwable) {
            this.cleanUp();
            throw throwable;
        }
        finally {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public boolean isCheckAuthToken() {
        return this._checkAuthToken;
    }

    public boolean isFacesPortlet() {
        return this._facesPortlet;
    }

    public boolean isHeaderPortlet() {
        return this._headerPortlet;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeAction(actionRequest, actionResponse);
        }
        catch (Exception exception) {
            this.processException(exception, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"processAction for ", this._portletId, " takes ", stopWatch.getTime(), " ms"}));
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeEvent(eventRequest, eventResponse);
        }
        catch (Exception exception) {
            this.processException(exception, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"processEvent for ", this._portletId, " takes ", stopWatch.getTime(), " ms"}));
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        RenderResponseImpl renderResponseImpl;
        PortletException portletException = (PortletException)((Object)renderRequest.getAttribute(this._errorKey));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = renderRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeRender(renderRequest, renderResponse);
        } else {
            String sessionResponseId;
            renderResponseImpl = (RenderResponseImpl)renderResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)renderResponseImpl.getHttpServletResponse();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)renderRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletUtil.getResponses(renderRequest.getPortletSession());
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletUtil.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)renderRequest)));
            if (response == null) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response = new InvokerPortletResponse(title, bufferCacheServletResponse.getString(), now + 1000L * (long)this._expCache.intValue());
                sessionResponses.put(sessionResponseId, response);
            } else if (response.getTime() < now && this._expCache > 0) {
                response.setTitle(this.invokeRender(renderRequest, renderResponse));
                response.setContent(bufferCacheServletResponse.getString());
                response.setTime(now + 1000L * (long)this._expCache.intValue());
            } else {
                renderResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        renderResponseImpl = (RenderResponseImpl)renderResponse;
        Map<String, String[]> properties = renderResponseImpl.getProperties();
        if (properties.containsKey("clear-request-parameters")) {
            RenderRequestImpl renderRequestImpl = (RenderRequestImpl)renderRequest;
            renderRequestImpl.clearRenderParameters();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"render for ", this._portletId, " takes ", stopWatch.getTime(), " ms"}));
        }
    }

    public void renderHeaders(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        PortletException portletException = (PortletException)((Object)headerRequest.getAttribute(this._errorKey));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = headerRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeHeader(headerRequest, headerResponse);
        } else {
            String sessionResponseId;
            HeaderResponseImpl headerResponseImpl = (HeaderResponseImpl)headerResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)headerResponseImpl.getHttpServletResponse();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)headerRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletUtil.getResponses(headerRequest.getPortletSession());
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletUtil.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)headerRequest)));
            if (response == null) {
                this.invokeHeader(headerRequest, headerResponse);
            } else if (response.getTime() < now && this._expCache > 0) {
                this.invokeHeader(headerRequest, headerResponse);
                response.setContent(bufferCacheServletResponse.getString());
            } else {
                headerResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"header for", this._portletId, " takes ", stopWatch.getTime(), " ms"}));
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeResource(resourceRequest, resourceResponse);
        }
        catch (Exception exception) {
            this.processException(exception, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"serveResource for ", this._portletId, " takes ", stopWatch.getTime(), " ms"}));
        }
    }

    public void setPortletFilters() {
    }

    protected void cleanUp() {
        try {
            Closeable closeable = (Closeable)this._invokerFilterContainer;
            closeable.close();
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to close invoker filter container", (Throwable)ioException);
        }
    }

    protected void invoke(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String lifecycle, List<? extends PortletFilter> filters) throws IOException, PortletException {
        String[] expCache;
        FilterChainImpl filterChain = new FilterChainImpl(this._portlet, filters);
        if (this._liferayPortletConfig.isWARFile()) {
            String invokerPortletName = this._liferayPortletConfig.getInitParameter("com.liferay.portal.invokerPortletName");
            if (invokerPortletName == null) {
                invokerPortletName = PortalUtil.getJsSafePortletId((String)this._liferayPortletConfig.getPortletName());
            }
            String path = "/" + invokerPortletName + "/invoke";
            ServletContext servletContext = this._liferayPortletContext.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            HttpServletRequest httpServletRequest = liferayPortletRequest.getHttpServletRequest();
            HttpServletResponse httpServletResponse = liferayPortletResponse.getHttpServletResponse();
            httpServletRequest.setAttribute("javax.portlet.portlet", (Object)this._portlet);
            httpServletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            httpServletRequest.setAttribute("com.liferay.portal.kernel.servlet.PortletServletFilterChain", (Object)filterChain);
            try {
                if (lifecycle.equals("RESOURCE_PHASE")) {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (ServletException servletException) {
                Throwable throwable = servletException.getRootCause();
                if (throwable instanceof PortletException) {
                    throw (PortletException)throwable;
                }
                throw new PortletException(throwable);
            }
        } else {
            PortletFilterUtil.doFilter((PortletRequest)liferayPortletRequest, (PortletResponse)liferayPortletResponse, (String)lifecycle, (FilterChain)filterChain);
        }
        liferayPortletResponse.transferMarkupHeadElements();
        Map properties = liferayPortletResponse.getProperties();
        if (MapUtil.isNotEmpty((Map)properties) && this._expCache != null && (expCache = (String[])properties.get("portlet.expiration-cache")) != null && expCache.length > 0 && expCache[0] != null) {
            this._expCache = GetterUtil.getInteger((String)expCache[0]);
        }
    }

    protected void invokeAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.invoke(PortalUtil.getLiferayPortletRequest((PortletRequest)actionRequest), PortalUtil.getLiferayPortletResponse((PortletResponse)actionResponse), "ACTION_PHASE", this._invokerFilterContainer.getActionFilters());
    }

    protected void invokeEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this.invoke(PortalUtil.getLiferayPortletRequest((PortletRequest)eventRequest), PortalUtil.getLiferayPortletResponse((PortletResponse)eventResponse), "EVENT_PHASE", this._invokerFilterContainer.getEventFilters());
    }

    protected void invokeHeader(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)headerRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)headerResponse);
        try {
            this.invoke(liferayPortletRequest, liferayPortletResponse, "HEADER_PHASE", this._invokerFilterContainer.getHeaderFilters());
        }
        catch (Exception exception) {
            this.processException(exception, (PortletRequest)headerRequest, (PortletResponse)headerResponse);
            throw exception;
        }
    }

    protected String invokeRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)renderRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)renderResponse);
        try {
            this.invoke(liferayPortletRequest, liferayPortletResponse, "RENDER_PHASE", this._invokerFilterContainer.getRenderFilters());
        }
        catch (Exception exception) {
            this.processException(exception, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
            throw exception;
        }
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
        return renderResponseImpl.getTitle();
    }

    protected void invokeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.invoke(PortalUtil.getLiferayPortletRequest((PortletRequest)resourceRequest), PortalUtil.getLiferayPortletResponse((PortletResponse)resourceResponse), "RESOURCE_PHASE", this._invokerFilterContainer.getResourceFilters());
    }

    protected void processException(Exception exception, PortletRequest liferayPortletRequest, PortletResponse liferayPortletResponse) {
        if (liferayPortletResponse instanceof StateAwareResponseImpl) {
            StateAwareResponseImpl stateAwareResponseImpl = (StateAwareResponseImpl)liferayPortletResponse;
            stateAwareResponseImpl.reset();
        }
        if (exception instanceof RuntimeException) {
            exception = new PortletException(exception);
        }
        if (exception instanceof UnavailableException) {
            this.destroy();
            PortletLocalServiceUtil.deletePortlet((com.liferay.portal.kernel.model.Portlet)this._portletModel);
        }
        if (exception instanceof PortletException) {
            if (liferayPortletResponse instanceof StateAwareResponseImpl && !(exception instanceof UnavailableException)) {
                return;
            }
            if (!(liferayPortletRequest instanceof RenderRequest)) {
                liferayPortletRequest.setAttribute(this._errorKey, (Object)exception);
            }
        } else {
            ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private void _initialize(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean headerPortlet) {
        this._portletModel = portletModel;
        this._portlet = portlet;
        this._invokerFilterContainer = invokerFilterContainer;
        this._checkAuthToken = checkAuthToken;
        this._facesPortlet = facesPortlet;
        this._headerPortlet = headerPortlet;
        this._expCache = portletModel.getExpCache();
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._liferayPortletContext = (LiferayPortletContext)portletContext;
        this._portletId = this._portletModel.getPortletId();
        this._errorKey = this._portletId.concat(PortletException.class.getName());
        if (_log.isDebugEnabled()) {
            com.liferay.portal.kernel.model.Portlet portletContextPortlet = this._liferayPortletContext.getPortlet();
            _log.debug((Object)("Create instance cache wrapper for " + portletContextPortlet.getPortletId()));
        }
    }
}

