/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portlet.internal.PortletRequestDispatcherImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;

public class PortletContextImpl
implements LiferayPortletContext {
    private static final int _MAJOR_VERSION = 3;
    private static final int _MINOR_VERSION = 0;
    private static final Log _log = LogFactoryUtil.getLog(PortletContextImpl.class);
    private static final Set<String> _supportedRuntimeOptions = new HashSet<String>(Arrays.asList("javax.portlet.escapeXml", "com.liferay.portal.portalContext"));
    private final Portlet _portlet;
    private final ServletContext _servletContext;
    private final String _servletContextName;

    public PortletContextImpl(Portlet portlet, ServletContext servletContext) {
        this._portlet = portlet;
        this._servletContext = servletContext;
        this._servletContextName = GetterUtil.getString((String)this._servletContext.getServletContextName());
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._servletContext.getAttributeNames();
    }

    public ClassLoader getClassLoader() {
        return this._servletContext.getClassLoader();
    }

    public Enumeration<String> getContainerRuntimeOptions() {
        return Collections.enumeration(_supportedRuntimeOptions);
    }

    public String getContextPath() {
        return this._servletContext.getContextPath();
    }

    public int getEffectiveMajorVersion() {
        PortletApp portletApp = this._portlet.getPortletApp();
        return portletApp.getSpecMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        PortletApp portletApp = this._portlet.getPortletApp();
        return portletApp.getSpecMinorVersion();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this._servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return this._servletContext.getMimeType(file);
    }

    public int getMinorVersion() {
        return 0;
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher requestDispatcher = null;
        try {
            requestDispatcher = this._servletContext.getNamedDispatcher(name);
        }
        catch (Throwable throwable) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get request dispatcher for name " + name), throwable);
            }
            return null;
        }
        if (requestDispatcher == null) {
            return null;
        }
        return new PortletRequestDispatcherImpl(requestDispatcher, true, (PortletContext)this);
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public String getPortletContextName() {
        return this._servletContextName;
    }

    public String getRealPath(String path) {
        return this._servletContext.getRealPath(path);
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher requestDispatcher = null;
        try {
            requestDispatcher = this._servletContext.getRequestDispatcher(path);
        }
        catch (Throwable throwable) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get request dispatcher for path " + path), throwable);
            }
            return null;
        }
        if (requestDispatcher == null) {
            return null;
        }
        return new PortletRequestDispatcherImpl(requestDispatcher, false, (PortletContext)this, path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException();
        }
        return this._servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this._servletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this._servletContext.getResourcePaths(path);
    }

    public String getServerInfo() {
        return ReleaseInfo.getServerInfo();
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public boolean isWARFile() {
        PortletApp portletApp = this._portlet.getPortletApp();
        return portletApp.isWARFile();
    }

    public void log(String msg) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)msg);
        }
    }

    public void log(String msg, Throwable throwable) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)msg, throwable);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._servletContext.setAttribute(name, object);
    }
}

