/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sitesadmin.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserSiteMembershipChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserSiteMembershipChecker.class);
    private final Group _group;

    public UserSiteMembershipChecker(RenderResponse renderResponse, Group group) {
        super((PortletResponse)renderResponse);
        this._group = group;
    }

    public boolean isChecked(Object object) {
        User user = null;
        if (object instanceof User) {
            user = (User)object;
        } else if (object instanceof Object[]) {
            user = (User)((Object[])object)[0];
        } else {
            throw new IllegalArgumentException(object + " is not a user");
        }
        try {
            return UserLocalServiceUtil.hasGroupUser((long)this._group.getGroupId(), (long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isDisabled(Object object) {
        User user = (User)object;
        try {
            if (this.isChecked(user) || !SiteMembershipPolicyUtil.isMembershipAllowed((long)user.getUserId(), (long)this._group.getGroupId())) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return super.isDisabled(object);
    }
}

