/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.JSONAction;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditLayoutAction
extends JSONAction {
    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jsonObject;
        block13: {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
            jsonObject = JSONFactoryUtil.createJSONObject();
            try {
                if (cmd.equals("add")) {
                    String[] array = this.addPage(themeDisplay, httpServletRequest, httpServletResponse);
                    jsonObject.put("deletable", (Object)Boolean.valueOf(array[2])).put("layoutId", array[0]).put("sortable", (Object)Boolean.valueOf(array[3])).put("updateable", (Object)Boolean.valueOf(array[4])).put("url", array[1]);
                } else if (cmd.equals("delete")) {
                    SitesUtil.deleteLayout((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                } else if (cmd.equals("display_order")) {
                    this.updateDisplayOrder(httpServletRequest);
                } else if (cmd.equals("name")) {
                    this.updateName(httpServletRequest);
                } else if (cmd.equals("parent_layout_id")) {
                    this.updateParentLayoutId(httpServletRequest);
                } else if (cmd.equals("priority")) {
                    this.updatePriority(httpServletRequest);
                }
                jsonObject.put("status", 200);
            }
            catch (LayoutTypeException layoutTypeException) {
                jsonObject.put("message", this.getLayoutTypeExceptionMessage(themeDisplay, layoutTypeException, cmd));
                long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
                if (layoutTypeException.getType() != 2 || plid <= 0L) break block13;
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                jsonObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("originalParentLayoutId", layout.getParentLayoutId()).put("originalParentPlid", layout.getParentPlid()).put("originalPriority", layout.getPriority()).put("plid", plid).put("status", 400);
            }
        }
        return jsonObject.toString();
    }

    protected String[] addPage(ThemeDisplay themeDisplay, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String doAsUserId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserLanguageId");
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentLayoutId");
        String name = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"name", (String)"New Page");
        String title = "";
        String description = "";
        String friendlyURL = "";
        long layoutPrototypeId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutPrototypeId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        Layout layout = null;
        if (layoutPrototypeId > 0L) {
            LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
            serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)name, (String)title, (String)description, (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        } else {
            layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)name, (String)title, (String)description, (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        }
        LayoutType layoutType = layout.getLayoutType();
        EventsProcessorUtil.process("layout.configuration.action.update", layoutType.getConfigurationActionUpdate(), httpServletRequest, httpServletResponse);
        String layoutURL = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        if (Validator.isNotNull((String)doAsUserId)) {
            layoutURL = HttpComponentsUtil.addParameter((String)layoutURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            layoutURL = HttpComponentsUtil.addParameter((String)layoutURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        boolean deleteable = LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE");
        boolean sortable = GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS") && SitesUtil.isLayoutSortable((Layout)layout);
        boolean updateable = LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
        return new String[]{String.valueOf(layout.getLayoutId()), layoutURL, String.valueOf(deleteable), String.valueOf(sortable), String.valueOf(updateable)};
    }

    protected String getLayoutTypeExceptionMessage(ThemeDisplay themeDisplay, LayoutTypeException layoutTypeException, String cmd) {
        if (Validator.isNotNull((String)cmd)) {
            if (cmd.equals("delete") && layoutTypeException.getType() == 2) {
                return themeDisplay.translate("you-cannot-delete-this-page-because-the-next-page-is-of-type-x-and-so-cannot-be-the-first-page", new Object[]{"layout.types." + layoutTypeException.getLayoutType()});
            }
            if (cmd.equals("delete") && layoutTypeException.getType() == 3) {
                return themeDisplay.translate("you-cannot-delete-this-page-because-the-next-page-is-not-vieweable-by-unathenticated-users-and-so-cannot-be-the-first-page");
            }
            if ((cmd.equals("display_order") || cmd.equals("priority")) && layoutTypeException.getType() == 2) {
                return themeDisplay.translate("you-cannot-move-this-page-because-the-resulting-order-would-place-a-page-of-type-x-as-the-first-page", new Object[]{"layout.types." + layoutTypeException.getLayoutType()});
            }
            if (cmd.equals("parent_layout_id") && layoutTypeException.getType() == 2) {
                return themeDisplay.translate("you-cannot-move-this-page-because-the-resulting-order-would-place-a-page-of-type-x-as-the-first-page", new Object[]{"layout.types." + layoutTypeException.getLayoutType()});
            }
        }
        if (layoutTypeException.getType() == 2) {
            return themeDisplay.translate("the-first-page-cannot-be-of-type-x", new Object[]{"layout.types." + layoutTypeException.getLayoutType()});
        }
        if (layoutTypeException.getType() == 1) {
            return themeDisplay.translate("a-page-cannot-become-a-child-of-a-page-that-is-not-parentable");
        }
        return "";
    }

    protected void updateDisplayOrder(HttpServletRequest httpServletRequest) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentLayoutId");
        long[] layoutIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"layoutIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        LayoutServiceUtil.setLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long[])layoutIds, (ServiceContext)serviceContext);
    }

    protected void updateName(HttpServletRequest httpServletRequest) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
        String name = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"name");
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId");
        if (plid <= 0L) {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutId");
            LayoutServiceUtil.updateName((long)groupId, (boolean)privateLayout, (long)layoutId, (String)name, (String)languageId);
        } else {
            LayoutServiceUtil.updateName((long)plid, (String)name, (String)languageId);
        }
    }

    protected void updateParentLayoutId(HttpServletRequest httpServletRequest) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
        long parentPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentPlid");
        int priority = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"priority");
        LayoutServiceUtil.updateParentLayoutIdAndPriority((long)plid, (long)parentPlid, (int)priority);
    }

    protected void updatePriority(HttpServletRequest httpServletRequest) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
        if (plid <= 0L) {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"layoutId");
            long nextLayoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"nextLayoutId");
            long previousLayoutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"previousLayoutId");
            LayoutServiceUtil.updatePriority((long)groupId, (boolean)privateLayout, (long)layoutId, (long)nextLayoutId, (long)previousLayoutId);
        } else {
            int priority = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"priority");
            LayoutServiceUtil.updatePriority((long)plid, (int)priority);
        }
    }
}

