/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.pool.metrics.HikariConnectionPoolMetrics;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.jdbc.util.RetryDataSourceWrapper;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactory;
import com.liferay.portal.kernel.dao.jdbc.pool.metrics.ConnectionPoolMetrics;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.DigesterImpl;
import com.liferay.portal.util.JarUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.sql.DataSource;
import jodd.bean.BeanUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DataSourceFactoryImpl
implements DataSourceFactory {
    private static final Log _log = LogFactoryUtil.getLog(DataSourceFactoryImpl.class);
    private ServiceRegistration<?> _serviceRegistration;

    public void destroyDataSource(DataSource dataSource) throws Exception {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
        while (dataSource instanceof DataSourceWrapper) {
            DataSourceWrapper dataSourceWrapper = (DataSourceWrapper)dataSource;
            dataSource = dataSourceWrapper.getWrappedDataSource();
        }
        if (dataSource instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)dataSource);
            closeable.close();
        }
    }

    public DataSource initDataSource(Properties properties) throws Exception {
        DBType dbType;
        String driverClassName;
        String jndiName;
        block13: {
            jndiName = properties.getProperty("jndi.name");
            driverClassName = properties.getProperty("driverClassName");
            if (JavaDetector.isIBM() && (Validator.isNotNull((String)jndiName) || driverClassName.startsWith("com.mysql.cj"))) {
                if (Validator.isNull((String)jndiName)) {
                    this.testDatabaseClass(driverClassName);
                }
                try {
                    this._populateIBMCipherSuites(Class.forName("com.mysql.cj.protocol.ExportControlled"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug((Throwable)classNotFoundException);
                }
            }
        }
        if (Validator.isNotNull((String)jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (DataSource)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to lookup " + jndiName), (Throwable)exception);
            }
        } else {
            try {
                this.testDatabaseClass(driverClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to find the JDBC driver class ", driverClassName, " in a JAR in the directory ", PropsValues.LIFERAY_SHIELDED_CONTAINER_LIB_PORTAL_DIR}));
                throw classNotFoundException;
            }
            this._waitForJDBCConnection(properties);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Data source properties:\n");
            _log.debug((Object)PropertiesUtil.toString((Properties)properties));
        }
        DataSource dataSource = this.initDataSourceHikariCP(properties);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Created data source " + dataSource.getClass()));
        }
        if (PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES > 0 && (dbType = DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource))) == DBType.SYBASE) {
            dataSource = new RetryDataSourceWrapper(dataSource);
        }
        return dataSource;
    }

    public DataSource initDataSource(String driverClassName, String url, String userName, String password, String jndiName) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", driverClassName);
        properties.setProperty("url", url);
        properties.setProperty("username", userName);
        properties.setProperty("password", password);
        properties.setProperty("jndi.name", jndiName);
        return this.initDataSource(properties);
    }

    protected DataSource initDataSourceHikariCP(Properties properties) throws Exception {
        HikariDataSource hikariDataSource = new HikariDataSource();
        String connectionPropertiesString = (String)properties.remove("connectionProperties");
        if (connectionPropertiesString != null) {
            Properties connectionProperties = PropertiesUtil.load((String)StringUtil.replace((String)connectionPropertiesString, (char)';', (char)'\n'));
            hikariDataSource.setDataSourceProperties(connectionProperties);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtil.equalsIgnoreCase((String)key, (String)"url")) {
                key = "jdbcUrl";
            }
            if (this.isPropertyLiferay(key)) continue;
            try {
                BeanUtil.pojo.setProperty((Object)hikariDataSource, key, (Object)((String)entry.getValue()));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is an invalid HikariCP property"), (Throwable)exception);
            }
        }
        this.registerConnectionPoolMetrics(new HikariConnectionPoolMetrics(hikariDataSource));
        return hikariDataSource;
    }

    protected boolean isPropertyLiferay(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"jndi.name");
    }

    protected void registerConnectionPoolMetrics(ConnectionPoolMetrics connectionPoolMetrics) {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        this._serviceRegistration = bundleContext.registerService(ConnectionPoolMetrics.class, (Object)connectionPoolMetrics, null);
    }

    protected void testDatabaseClass(String driverClassName) throws Exception {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!ServerDetector.isTomcat()) {
                throw classNotFoundException;
            }
            String url = PropsUtil.get("setup.database.jar.url", new Filter(driverClassName));
            String name = PropsUtil.get("setup.database.jar.name", new Filter(driverClassName));
            String sha1 = PropsUtil.get("setup.database.jar.sha1", new Filter(driverClassName));
            if (Validator.isNull((String)url) || Validator.isNull((String)name) || Validator.isNull((String)sha1)) {
                throw classNotFoundException;
            }
            ClassLoader classLoader = SystemException.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                _log.error((Object)"Unable to install JAR because the system class loader is not an instance of URLClassLoader");
                return;
            }
            try {
                DigesterUtil digesterUtil = new DigesterUtil();
                digesterUtil.setDigester((Digester)new DigesterImpl());
                JarUtil.downloadAndInstallJar(new URL(url), Paths.get(PropsValues.LIFERAY_SHIELDED_CONTAINER_LIB_PORTAL_DIR, name), (URLClassLoader)classLoader, sha1);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to download and install ", name, " to ", PropsValues.LIFERAY_SHIELDED_CONTAINER_LIB_PORTAL_DIR, " from ", url}), (Throwable)exception);
                throw classNotFoundException;
            }
        }
    }

    private void _populateIBMCipherSuites(Class<?> clazz) {
        try {
            SSLContext sslContext = SSLContext.getDefault();
            SSLEngine sslEngine = sslContext.createSSLEngine();
            String[] ibmSupportedCipherSuites = sslEngine.getSupportedCipherSuites();
            if (ibmSupportedCipherSuites == null || ibmSupportedCipherSuites.length == 0) {
                return;
            }
            Field allowedCiphersField = ReflectionUtil.getDeclaredField(clazz, (String)"ALLOWED_CIPHERS");
            List allowedCiphers = (List)allowedCiphersField.get(null);
            for (String ibmSupportedCipherSuite : ibmSupportedCipherSuites) {
                if (allowedCiphers.contains(ibmSupportedCipherSuite)) continue;
                allowedCiphers.add(ibmSupportedCipherSuite);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to populate IBM JDK TLS cipher suite into MySQL Connector/J's allowed cipher list, consider disabling SSL for the connection", (Throwable)exception);
        }
    }

    private void _waitForJDBCConnection(Properties properties) {
        int maxRetries = PropsValues.RETRY_JDBC_ON_STARTUP_MAX_RETRIES;
        if (maxRetries <= 0) {
            return;
        }
        int delay = PropsValues.RETRY_JDBC_ON_STARTUP_DELAY;
        if (delay < 0) {
            delay = 0;
        }
        String url = properties.getProperty("url");
        String username = properties.getProperty("username");
        String password = properties.getProperty("password");
        int count = maxRetries;
        while (count-- > 0) {
            block25: {
                try (Connection connection = DriverManager.getConnection(url, username, password);){
                    if (connection != null) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Successfully acquired JDBC connection");
                        }
                        return;
                    }
                }
                catch (SQLException sqlException) {
                    if (!_log.isDebugEnabled()) break block25;
                    _log.error((Object)"Unable to acquire JDBC connection", (Throwable)sqlException);
                }
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"At attempt ", maxRetries - count, " of ", maxRetries, " in acquiring a JDBC connection after a ", delay, " second ", delay}));
            }
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isWarnEnabled()) break;
                _log.warn((Object)"Interruptted acquiring a JDBC connection", (Throwable)interruptedException);
                break;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to acquire a direct JDBC connection, proceeding to use a data source instead");
        }
    }
}

