/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.PortletDecoratorFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeCompanyLimit;
import com.liferay.portal.kernel.theme.ThemeGroupLimit;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.PluginBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class ThemeImpl
extends PluginBaseImpl
implements Theme {
    private static final Log _log = LogFactoryUtil.getLog(ThemeImpl.class);
    private final Map<String, ColorScheme> _colorSchemesMap = new HashMap<String, ColorScheme>();
    private boolean _controlPanelTheme;
    private String _cssPath = "${root-path}/css";
    private PortletDecorator _defaultPortletDecorator;
    private String _imagesPath = "${root-path}/images";
    private String _javaScriptPath = "${root-path}/js";
    private boolean _loadFromServletContext;
    private String _name;
    private boolean _pageTheme;
    private final Map<String, PortletDecorator> _portletDecoratorsMap = new HashMap<String, PortletDecorator>();
    private final Map<String, Boolean> _resourceExistsMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> _resourcePathsMap = new ConcurrentHashMap<String, String>();
    private String _rootPath = "/";
    private String _servletContextName = "";
    private String _templateExtension = "ftl";
    private String _templatesPath = "${root-path}/templates";
    private ThemeCompanyLimit _themeCompanyLimit;
    private ThemeGroupLimit _themeGroupLimit;
    private final String _themeId;
    private final Map<String, ThemeSetting> _themeSettingsMap = new LinkedHashMap<String, ThemeSetting>();
    private long _timestamp;
    private String _virtualPath = "";
    private boolean _warFile;

    public ThemeImpl() {
        this(null);
    }

    public ThemeImpl(String themeId) {
        this(themeId, null);
    }

    public ThemeImpl(String themeId, String name) {
        this._themeId = themeId;
        this._name = name;
    }

    public void addSetting(String key, String value, boolean configurable, String type, String[] options, String script) {
        ThemeSettingImpl themeSetting = new ThemeSettingImpl(configurable, options, script, type, value);
        this._themeSettingsMap.put(key, themeSetting);
    }

    public int compareTo(Theme theme) {
        return this.getName().compareTo(theme.getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Theme)) {
            return false;
        }
        Theme theme = (Theme)object;
        return this.getThemeId().equals(theme.getThemeId());
    }

    public List<ColorScheme> getColorSchemes() {
        List colorSchemes = ListUtil.fromMapValues(this._colorSchemesMap);
        return ListUtil.sort((List)colorSchemes);
    }

    public Map<String, ColorScheme> getColorSchemesMap() {
        return this._colorSchemesMap;
    }

    public Map<String, ThemeSetting> getConfigurableSettings() {
        LinkedHashMap<String, ThemeSetting> configurableSettings = new LinkedHashMap<String, ThemeSetting>();
        for (Map.Entry<String, ThemeSetting> entry : this._themeSettingsMap.entrySet()) {
            ThemeSetting themeSetting = entry.getValue();
            if (!themeSetting.isConfigurable()) continue;
            configurableSettings.put(entry.getKey(), entry.getValue());
        }
        return configurableSettings;
    }

    public String getContextPath() {
        if (!this.isWARFile()) {
            return PortalUtil.getPathContext();
        }
        String servletContextName = this.getServletContextName();
        if (ServletContextPool.containsKey((String)servletContextName)) {
            ServletContext servletContext = ServletContextPool.get((String)servletContextName);
            String proxyPath = PortalUtil.getPathProxy();
            return proxyPath.concat(servletContext.getContextPath());
        }
        String portalPathContext = PortalUtil.getPathContext();
        return portalPathContext.concat("/".concat(servletContextName));
    }

    public String getCssPath() {
        return this._cssPath;
    }

    public PortletDecorator getDefaultPortletDecorator() {
        if (this._defaultPortletDecorator == null) {
            List<PortletDecorator> portletDecorators = this.getPortletDecorators();
            for (int i = portletDecorators.size() - 1; i >= 0; --i) {
                PortletDecorator portletDecorator = portletDecorators.get(i);
                if (!portletDecorator.isDefaultPortletDecorator()) continue;
                this._defaultPortletDecorator = portletDecorator;
                break;
            }
            if (this._defaultPortletDecorator == null) {
                this._defaultPortletDecorator = PortletDecoratorFactoryUtil.getDefaultPortletDecorator();
            }
        }
        return this._defaultPortletDecorator;
    }

    public String getDevice() {
        return "regular";
    }

    public String getFreeMarkerTemplateLoader() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public String getImagesPath() {
        return this._imagesPath;
    }

    public String getJavaScriptPath() {
        return this._javaScriptPath;
    }

    public boolean getLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public String getName() {
        return this._name;
    }

    public String getPluginId() {
        return this.getThemeId();
    }

    public String getPluginType() {
        return "theme";
    }

    public List<PortletDecorator> getPortletDecorators() {
        List portletDecorators = ListUtil.fromMapValues(this._portletDecoratorsMap);
        return ListUtil.sort((List)portletDecorators);
    }

    public Map<String, PortletDecorator> getPortletDecoratorsMap() {
        return this._portletDecoratorsMap;
    }

    public String getResourcePath(ServletContext servletContext, String portletId, String path) {
        String resourcePath;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return this._getResourcePath(servletContext, portletId, path);
        }
        String key = path;
        if (Validator.isNotNull((String)portletId)) {
            key = StringBundler.concat((String[])new String[]{path, "#", portletId});
        }
        if ((resourcePath = this._resourcePathsMap.get(key)) != null) {
            return resourcePath;
        }
        resourcePath = this._getResourcePath(servletContext, portletId, path);
        this._resourcePathsMap.put(key, resourcePath);
        return resourcePath;
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public String getSetting(String key) {
        String value = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            value = themeSetting.getValue();
        }
        return value;
    }

    public String[] getSettingOptions(String key) {
        String[] options = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            options = themeSetting.getOptions();
        }
        return options;
    }

    public Map<String, ThemeSetting> getSettings() {
        return this._themeSettingsMap;
    }

    public Properties getSettingsProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, ThemeSetting> entry : this._themeSettingsMap.entrySet()) {
            ThemeSetting setting = entry.getValue();
            if (setting == null) continue;
            properties.setProperty(entry.getKey(), setting.getValue());
        }
        return properties;
    }

    public String getStaticResourcePath() {
        String proxyPath = PortalUtil.getPathProxy();
        String virtualPath = this.getVirtualPath();
        if (Validator.isNotNull((String)virtualPath)) {
            return proxyPath.concat(virtualPath);
        }
        if (this.isWARFile()) {
            return this.getContextPath();
        }
        String contextPath = null;
        if (this._themeId.equals("admin")) {
            contextPath = PortalWebResourcesUtil.getModuleContextPath((String)"theme_admin");
        } else if (this._themeId.equals("classic")) {
            contextPath = PortalWebResourcesUtil.getModuleContextPath((String)"theme_classic");
        }
        if (Validator.isNull((String)contextPath)) {
            return proxyPath;
        }
        return proxyPath.concat(contextPath);
    }

    public String getTemplateExtension() {
        return this._templateExtension;
    }

    public String getTemplatesPath() {
        return this._templatesPath;
    }

    public ThemeCompanyLimit getThemeCompanyLimit() {
        return this._themeCompanyLimit;
    }

    public ThemeGroupLimit getThemeGroupLimit() {
        return this._themeGroupLimit;
    }

    public String getThemeId() {
        return this._themeId;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public String getVelocityResourceListener() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public String getVirtualPath() {
        return this._virtualPath;
    }

    public boolean getWARFile() {
        return this._warFile;
    }

    public boolean hasColorSchemes() {
        return !this._colorSchemesMap.isEmpty();
    }

    public int hashCode() {
        return this._themeId.hashCode();
    }

    public boolean isCompanyAvailable(long companyId) {
        return this.isAvailable(this.getThemeCompanyLimit(), companyId);
    }

    public boolean isControlPanelTheme() {
        return this._controlPanelTheme;
    }

    public boolean isGroupAvailable(long groupId) {
        return this.isAvailable((ThemeCompanyLimit)this.getThemeGroupLimit(), groupId);
    }

    public boolean isLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public boolean isPageTheme() {
        return this._pageTheme;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public boolean resourceExists(ServletContext servletContext, String portletId, String path) throws Exception {
        Boolean resourceExists;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return this._resourceExists(servletContext, portletId, path);
        }
        if (Validator.isNull((String)path)) {
            return false;
        }
        String key = path;
        if (Validator.isNotNull((String)portletId)) {
            key = StringBundler.concat((String[])new String[]{path, "#", portletId});
        }
        if ((resourceExists = this._resourceExistsMap.get(key)) != null) {
            return resourceExists;
        }
        resourceExists = this._resourceExists(servletContext, portletId, path);
        this._resourceExistsMap.put(key, resourceExists);
        return resourceExists;
    }

    public void setControlPanelTheme(boolean controlPanelTheme) {
        this._controlPanelTheme = controlPanelTheme;
    }

    public void setCssPath(String cssPath) {
        this._cssPath = cssPath;
    }

    public void setImagesPath(String imagesPath) {
        this._imagesPath = imagesPath;
    }

    public void setJavaScriptPath(String javaScriptPath) {
        this._javaScriptPath = javaScriptPath;
    }

    public void setLoadFromServletContext(boolean loadFromServletContext) {
        this._loadFromServletContext = loadFromServletContext;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPageTheme(boolean pageTheme) {
        this._pageTheme = pageTheme;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull((String)this._servletContextName);
    }

    public void setSetting(String key, String value) {
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            themeSetting.setValue(value);
        } else {
            this.addSetting(key, value, false, null, null, null);
        }
    }

    public void setTemplateExtension(String templateExtension) {
        this._templateExtension = templateExtension;
    }

    public void setTemplatesPath(String templatesPath) {
        this._templatesPath = templatesPath;
    }

    public void setThemeCompanyLimit(ThemeCompanyLimit themeCompanyLimit) {
        this._themeCompanyLimit = themeCompanyLimit;
    }

    public void setThemeGroupLimit(ThemeGroupLimit themeGroupLimit) {
        this._themeGroupLimit = themeGroupLimit;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public void setVirtualPath(String virtualPath) {
        if (this._warFile && Validator.isNull((String)virtualPath)) {
            virtualPath = PropsValues.THEME_VIRTUAL_PATH;
        }
        this._virtualPath = virtualPath;
    }

    protected boolean isAvailable(ThemeCompanyLimit limit, long id) {
        boolean available = true;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Check if theme ", this.getThemeId(), " is available for ", id}));
        }
        if (limit != null) {
            List includes = limit.getIncludes();
            List excludes = limit.getExcludes();
            if (!includes.isEmpty() && !excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes and excludes");
                }
                if (available = limit.isIncluded(id)) {
                    available = !limit.isExcluded(id);
                }
            } else if (includes.isEmpty() && !excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check excludes");
                }
                available = !limit.isExcluded(id);
            } else if (!includes.isEmpty() && excludes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes");
                }
                available = limit.isIncluded(id);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"No includes or excludes set");
                }
                available = true;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Theme ", this.getThemeId(), " is ", !available ? "NOT " : "", "available for ", id}));
        }
        return available;
    }

    private String _getResourcePath(ServletContext servletContext, String portletId, String path) {
        StringBundler sb = new StringBundler(11);
        String themeContextName = GetterUtil.getString((String)this.getServletContextName());
        sb.append(themeContextName);
        String servletContextName = "";
        if (!Objects.equals(PortalUtil.getPathContext((String)servletContext.getContextPath()), PortalUtil.getPathContext())) {
            servletContextName = GetterUtil.getString((String)servletContext.getServletContextName());
        }
        sb.append(this.getFreeMarkerTemplateLoader());
        sb.append(this.getTemplatesPath());
        if (Validator.isNotNull((String)servletContextName) && !path.startsWith("/".concat(servletContextName))) {
            sb.append("/");
            sb.append(servletContextName);
        }
        sb.append("/");
        int start = 0;
        if (path.startsWith("/")) {
            start = 1;
        }
        int end = path.lastIndexOf(46);
        sb.append(path.substring(start, end));
        sb.append(".");
        if (Validator.isNotNull((String)portletId)) {
            sb.append(portletId);
            sb.append(".");
        }
        sb.append("ftl");
        return sb.toString();
    }

    private boolean _resourceExists(ServletContext servletContext, String portletId, String path) throws Exception {
        if (Validator.isNull((String)path)) {
            return false;
        }
        Boolean exists = null;
        if (Validator.isNotNull((String)portletId)) {
            exists = TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)this.getResourcePath(servletContext, portletId, path));
            if (!exists.booleanValue() && PortletIdCodec.hasInstanceId((String)portletId)) {
                String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                exists = TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)this.getResourcePath(servletContext, rootPortletId, path));
            }
            if (!exists.booleanValue()) {
                exists = TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)this.getResourcePath(servletContext, null, path));
            }
        }
        if (exists == null) {
            exists = TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)this.getResourcePath(servletContext, portletId, path));
        }
        return exists;
    }
}

