/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactory;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.UserBagImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class UserBagFactoryImpl
implements UserBagFactory {
    public UserBag create(long userId) throws PortalException {
        UserBag userBag = PermissionCacheUtil.getUserBag(userId);
        if (userBag != null) {
            return userBag;
        }
        HashSet<Long> allGroupIds = new HashSet<Long>();
        Collection<Organization> userOrgs = this.getUserOrgs(userId);
        HashSet<Long> userOrgGroupIds = new HashSet<Long>();
        for (Organization organization : userOrgs) {
            userOrgGroupIds.add(organization.getGroupId());
        }
        allGroupIds.addAll(userOrgGroupIds);
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId);
        long[] userUserGroupGroupIds = new long[userUserGroups.size()];
        for (int i = 0; i < userUserGroups.size(); ++i) {
            long groupId;
            UserGroup userUserGroup = (UserGroup)userUserGroups.get(i);
            userUserGroupGroupIds[i] = groupId = userUserGroup.getGroupId();
            allGroupIds.add(groupId);
        }
        long[] userGroupIds = UserLocalServiceUtil.getGroupPrimaryKeys((long)userId);
        HashSet<Long> userGroupIdsSet = new HashSet<Long>();
        for (long userGroupId : userGroupIds) {
            userGroupIdsSet.add(userGroupId);
            allGroupIds.add(userGroupId);
        }
        if (!userOrgs.isEmpty() || !userUserGroups.isEmpty()) {
            List userGroups = GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true);
            for (Group userGroup : userGroups) {
                long groupId = userGroup.getGroupId();
                userGroupIdsSet.add(groupId);
                allGroupIds.add(groupId);
            }
            userGroupIds = ArrayUtil.toLongArray(userGroupIdsSet);
        }
        if (allGroupIds.isEmpty()) {
            long[] userRoleIds = UserLocalServiceUtil.getRolePrimaryKeys((long)userId);
            userBag = new UserBagImpl(userId, userGroupIds, userOrgs, userOrgGroupIds, (Collection<UserGroup>)userUserGroups, userUserGroupGroupIds, userRoleIds);
        } else {
            List userRoles = RoleLocalServiceUtil.getUserRelatedRoles((long)userId, (long[])ArrayUtil.toLongArray(allGroupIds));
            userBag = new UserBagImpl(userId, userGroupIds, userOrgs, userOrgGroupIds, (Collection<UserGroup>)userUserGroups, userUserGroupGroupIds, userRoles);
        }
        PermissionCacheUtil.putUserBag(userId, userBag);
        return userBag;
    }

    protected Collection<Organization> getUserOrgs(long userId) throws PortalException {
        List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        if (userOrgs.isEmpty()) {
            return Collections.emptyList();
        }
        if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
            return userOrgs;
        }
        LinkedHashSet<Organization> organizations = new LinkedHashSet<Organization>();
        for (Organization organization : userOrgs) {
            if (!organizations.add(organization)) continue;
            List ancestorOrganizations = OrganizationLocalServiceUtil.getParentOrganizations((long)organization.getOrganizationId());
            organizations.addAll(ancestorOrganizations);
        }
        return organizations;
    }
}

