/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserBagImpl
implements UserBag {
    private static final long[] _EMPTY = new long[0];
    private final long[] _userGroupIds;
    private final long _userId;
    private final long[] _userOrgGroupIds;
    private final long[] _userOrgIds;
    private final long[] _userRoleIds;
    private final long[] _userUserGroupGroupIds;
    private final long[] _userUserGroupIds;

    public UserBagImpl(long userId, long[] userGroupIds, Collection<Organization> userOrgs, Collection<Long> userOrgGroups, Collection<UserGroup> userUserGroups, long[] userUserGroupGroupIds, Collection<Role> userRoles) {
        this._userId = userId;
        this._userGroupIds = userGroupIds;
        Arrays.sort(this._userGroupIds);
        this._userOrgGroupIds = ArrayUtil.toLongArray(userOrgGroups);
        Arrays.sort(this._userOrgGroupIds);
        this._userOrgIds = this._toSortedLongArray(userOrgs);
        this._userRoleIds = this._toSortedLongArray(userRoles);
        this._userUserGroupGroupIds = userUserGroupGroupIds;
        Arrays.sort(this._userUserGroupGroupIds);
        this._userUserGroupIds = this._toSortedLongArray(userUserGroups);
    }

    public UserBagImpl(long userId, long[] userGroupIds, Collection<Organization> userOrgs, Collection<Long> userOrgGroups, Collection<UserGroup> userUserGroups, long[] userUserGroupGroupIds, long[] userRoleIds) {
        this._userId = userId;
        this._userGroupIds = userGroupIds;
        Arrays.sort(userGroupIds);
        this._userOrgIds = this._toSortedLongArray(userOrgs);
        this._userOrgGroupIds = ArrayUtil.toLongArray(userOrgGroups);
        Arrays.sort(this._userOrgGroupIds);
        this._userUserGroupIds = this._toSortedLongArray(userUserGroups);
        this._userUserGroupGroupIds = userUserGroupGroupIds;
        Arrays.sort(this._userUserGroupGroupIds);
        this._userRoleIds = userRoleIds;
        Arrays.sort(this._userRoleIds);
    }

    public Set<Group> getGroups() throws PortalException {
        HashSet<Group> groups = new HashSet<Group>(this.getUserGroups());
        groups.addAll(this.getUserOrgGroups());
        groups.addAll(this.getUserUserGroupGroups());
        return groups;
    }

    public long[] getRoleIds() {
        return (long[])this._userRoleIds.clone();
    }

    public List<Role> getRoles() throws PortalException {
        return RoleLocalServiceUtil.getRoles((long[])this._userRoleIds);
    }

    public long[] getUserGroupIds() {
        return (long[])this._userGroupIds.clone();
    }

    public List<Group> getUserGroups() throws PortalException {
        return GroupLocalServiceUtil.getGroups((long[])this._userGroupIds);
    }

    public long getUserId() {
        return this._userId;
    }

    public long[] getUserOrgGroupIds() {
        return (long[])this._userOrgGroupIds.clone();
    }

    public List<Group> getUserOrgGroups() throws PortalException {
        return GroupLocalServiceUtil.getGroups((long[])this._userOrgGroupIds);
    }

    public long[] getUserOrgIds() {
        return (long[])this._userOrgIds.clone();
    }

    public List<Organization> getUserOrgs() throws PortalException {
        return OrganizationLocalServiceUtil.getOrganizations((long[])this._userOrgIds);
    }

    public List<Group> getUserUserGroupGroups() throws PortalException {
        return GroupLocalServiceUtil.getGroups((long[])this._userUserGroupGroupIds);
    }

    public long[] getUserUserGroupsIds() {
        return this._userUserGroupIds;
    }

    public boolean hasRole(Role role) {
        return this._search(this._userRoleIds, role.getRoleId());
    }

    public boolean hasUserGroup(Group group) {
        return this._search(this._userGroupIds, group.getGroupId());
    }

    public boolean hasUserOrg(Organization organization) {
        return this._search(this._userOrgIds, organization.getOrganizationId());
    }

    public boolean hasUserOrgGroup(Group group) {
        return this._search(this._userOrgGroupIds, group.getGroupId());
    }

    private boolean _search(long[] ids, long id) {
        return Arrays.binarySearch(ids, id) >= 0;
    }

    private long[] _toSortedLongArray(Collection<? extends BaseModel<?>> baseModels) {
        if (baseModels == null || baseModels.isEmpty()) {
            return _EMPTY;
        }
        long[] array = new long[baseModels.size()];
        int index = 0;
        for (BaseModel<?> baseModel : baseModels) {
            array[index++] = (Long)baseModel.getPrimaryKeyObj();
        }
        Arrays.sort(array);
        return array;
    }
}

