/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.url.validator.URLValidator;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.service.base.WebsiteLocalServiceBaseImpl;
import java.util.List;

public class WebsiteLocalServiceImpl
extends WebsiteLocalServiceBaseImpl {
    private static volatile URLValidator _urlValidator = (URLValidator)ServiceProxyFactory.newServiceTrackedInstance(URLValidator.class, WebsiteLocalServiceImpl.class, (String)"_urlValidator", (boolean)true);
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Website addWebsite(long userId, String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, url, typeId, primary);
        long websiteId = this.counterLocalService.increment();
        Website website = this.websitePersistence.create(websiteId);
        website.setUuid(serviceContext.getUuid());
        website.setCompanyId(user.getCompanyId());
        website.setUserId(user.getUserId());
        website.setUserName(user.getFullName());
        website.setClassNameId(classNameId);
        website.setClassPK(classPK);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        return (Website)this.websitePersistence.update((BaseModel)website);
    }

    @Override
    public Website deleteWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        return this.websiteLocalService.deleteWebsite(website);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Website deleteWebsite(Website website) {
        this.websitePersistence.remove((BaseModel)website);
        return website;
    }

    public void deleteWebsites(long companyId, String className, long classPK) {
        List websites = this.websitePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
        for (Website website : websites) {
            this.websiteLocalService.deleteWebsite(website);
        }
    }

    public List<Website> getWebsites() {
        return this.websitePersistence.findAll();
    }

    public List<Website> getWebsites(long companyId, String className, long classPK) {
        return this.websitePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Website updateWebsite(long websiteId, String url, long typeId, boolean primary) throws PortalException {
        this.validate(websiteId, 0L, 0L, 0L, url, typeId, primary);
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        return (Website)this.websitePersistence.update((BaseModel)website);
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, boolean primary) {
        if (primary) {
            List websites = this.websitePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Website website : websites) {
                if (websiteId > 0L && website.getWebsiteId() == websiteId) continue;
                website.setPrimary(false);
                this.websitePersistence.update((BaseModel)website);
            }
        }
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, String url, long typeId, boolean primary) throws PortalException {
        if (!_urlValidator.isValid(url)) {
            throw new WebsiteURLException(url);
        }
        if (websiteId > 0L) {
            Website website = this.websitePersistence.findByPrimaryKey(websiteId);
            companyId = website.getCompanyId();
            classNameId = website.getClassNameId();
            classPK = website.getClassPK();
        }
        this._listTypeLocalService.validate(typeId, classNameId, ".website");
        this.validate(websiteId, companyId, classNameId, classPK, primary);
    }
}

