/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.model.PortletPreferenceValueTable;
import com.liferay.portal.kernel.model.PortletPreferencesTable;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.persistence.LayoutFinder;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.persistence.impl.LayoutFinderBaseImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LayoutFinderImpl
extends LayoutFinderBaseImpl
implements LayoutFinder {
    public List<Layout> findByNullFriendlyURL() {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.friendlyURL.eq((Object)"").or((Expression)LayoutTable.INSTANCE.friendlyURL.isNull())));
            sqlQuery.addEntity("Layout", LayoutImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Layout> findByScopeGroup(long groupId) {
        return this._findByScopeGroup(LayoutTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)InlineSQLHelperUtil.getPermissionWherePredicate(Layout.class, (Column)LayoutTable.INSTANCE.plid, (long[])new long[]{groupId})));
    }

    public List<Layout> findByScopeGroup(long groupId, boolean privateLayout) {
        return this._findByScopeGroup(LayoutTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)LayoutTable.INSTANCE.privateLayout.eq((Object)privateLayout)));
    }

    public List<LayoutReference> findByC_P_P(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        Session session = null;
        try {
            session = this.openSession();
            Column valueExpression = PortletPreferenceValueTable.INSTANCE.smallValue;
            if (preferencesValue.length() > 255) {
                valueExpression = DSLFunctionFactoryUtil.castClobText((Expression)PortletPreferenceValueTable.INSTANCE.largeValue);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{LayoutTable.INSTANCE.plid.as("layoutPlid"), PortletPreferencesTable.INSTANCE.portletId.as("preferencesPortletId")}).from((Table)LayoutTable.INSTANCE).innerJoinON((Table)PortletPreferencesTable.INSTANCE, PortletPreferencesTable.INSTANCE.plid.eq((Expression)LayoutTable.INSTANCE.plid)).innerJoinON((Table)PortletPreferenceValueTable.INSTANCE, PortletPreferenceValueTable.INSTANCE.portletPreferencesId.eq((Expression)PortletPreferencesTable.INSTANCE.portletPreferencesId)).where(LayoutTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)PortletPreferencesTable.INSTANCE.portletId.eq((Object)portletId).or((Expression)PortletPreferencesTable.INSTANCE.portletId.like(portletId.concat("_INSTANCE_%"))).withParentheses()).and((Expression)PortletPreferenceValueTable.INSTANCE.name.eq((Object)preferencesKey)).and((Expression)valueExpression.eq((Object)preferencesValue))));
            sqlQuery.addScalar("layoutPlid", Type.LONG);
            sqlQuery.addScalar("preferencesPortletId", Type.STRING);
            ArrayList<LayoutReference> layoutReferences = new ArrayList<LayoutReference>();
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                Long layoutPlid = (Long)array[0];
                String preferencesPortletId = (String)array[1];
                Layout layout = LayoutUtil.findByPrimaryKey((long)layoutPlid);
                layoutReferences.add(new LayoutReference((LayoutModel)layout, preferencesPortletId));
            }
            ArrayList<LayoutReference> arrayList = layoutReferences;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private List<Layout> _findByScopeGroup(Predicate wherePredicate) {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)LayoutTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.companyId.eq((Expression)LayoutTable.INSTANCE.companyId).and((Expression)GroupTable.INSTANCE.classNameId.eq((Object)PortalUtil.getClassNameId(Layout.class))).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)LayoutTable.INSTANCE.plid))).where(wherePredicate));
            sqlQuery.addEntity("Layout", LayoutImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

