/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.util.PortalUpgradeProcessRegistry;
import com.liferay.portal.upgrade.v7_3_x.PortalUpgradeProcessRegistryImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class PortalUpgradeProcess
extends UpgradeProcess {
    private static final Class<?>[] _PORTAL_UPGRADE_PROCESS_REGISTRIES = new Class[]{com.liferay.portal.upgrade.v7_1_x.PortalUpgradeProcessRegistryImpl.class, com.liferay.portal.upgrade.v7_2_x.PortalUpgradeProcessRegistryImpl.class, PortalUpgradeProcessRegistryImpl.class, com.liferay.portal.upgrade.v7_4_x.PortalUpgradeProcessRegistryImpl.class};
    private static final Log _log = LogFactoryUtil.getLog(PortalUpgradeProcess.class);
    private static final Version _initialSchemaVersion = new Version(0, 1, 0);
    private static final TreeMap<Version, UpgradeProcess> _upgradeProcesses = TreeMapBuilder.put((Object)_initialSchemaVersion, (Object)new DummyUpgradeProcess()).build();

    public static Version getCurrentSchemaVersion(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select schemaVersion from Release_ where servletContextName = ?");){
            preparedStatement.setString(1, "portal");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String schemaVersion = resultSet.getString("schemaVersion");
                    Version version = Version.parseVersion((String)schemaVersion);
                    return version;
                }
            }
        }
        return new Version(0, 0, 0);
    }

    public static Version getLatestSchemaVersion() {
        return _upgradeProcesses.lastKey();
    }

    public static SortedMap<Version, UpgradeProcess> getPendingUpgradeProcesses(Version schemaVersion) {
        return _upgradeProcesses.tailMap(schemaVersion, false);
    }

    public static Version getRequiredSchemaVersion() {
        NavigableSet<Version> reverseSchemaVersions = _upgradeProcesses.descendingKeySet();
        Iterator<Version> iterator = reverseSchemaVersions.iterator();
        Version requiredSchemaVersion = iterator.next();
        while (iterator.hasNext()) {
            Version nextSchemaVersion = iterator.next();
            if (requiredSchemaVersion.getMajor() != nextSchemaVersion.getMajor() || requiredSchemaVersion.getMinor() != nextSchemaVersion.getMinor()) break;
            requiredSchemaVersion = nextSchemaVersion;
        }
        return requiredSchemaVersion;
    }

    public static boolean isInLatestSchemaVersion(Connection connection) throws SQLException {
        Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
        return latestSchemaVersion.equals((Object)PortalUpgradeProcess.getCurrentSchemaVersion(connection));
    }

    public static boolean isInRequiredSchemaVersion(Connection connection) throws SQLException {
        Version currentSchemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(connection);
        Version requiredSchemaVersion = PortalUpgradeProcess.getRequiredSchemaVersion();
        int result = requiredSchemaVersion.compareTo(currentSchemaVersion);
        return result == 0 || result < 0 && requiredSchemaVersion.getMajor() == currentSchemaVersion.getMajor();
    }

    public static boolean supportsRetry(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select buildNumber from Release_ where servletContextName = ?");){
            preparedStatement.setString(1, "portal");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    if (resultSet.getInt("buildNumber") >= 7100) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return false;
    }

    public void upgrade() throws UpgradeException {
        long start = System.currentTimeMillis();
        String message = "Completed upgrade process ";
        try {
            try (Connection connection = this.getConnection();){
                this.connection = connection;
                if (_log.isInfoEnabled()) {
                    String info = "Upgrading " + ClassUtil.getClassName((Object)((Object)this));
                    _log.info((Object)info);
                }
                this.doUpgrade();
            }
            this.connection = null;
        }
        catch (Exception exception) {
            try {
                message = "Failed upgrade process ";
                throw new UpgradeException((Throwable)exception);
            }
            catch (Throwable throwable) {
                this.connection = null;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{message, ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
                }
                throw throwable;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{message, ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
        }
    }

    protected void doUpgrade() throws Exception {
        this._initializeRelease(this.connection);
        for (Version pendingSchemaVersion : this.getPendingSchemaVersions(PortalUpgradeProcess.getCurrentSchemaVersion(this.connection))) {
            this.upgrade(_upgradeProcesses.get(pendingSchemaVersion));
            this.updateSchemaVersion(pendingSchemaVersion);
        }
        this.clearIndexesCache();
    }

    protected Set<Version> getPendingSchemaVersions(Version fromSchemaVersion) {
        NavigableMap<Version, UpgradeProcess> pendingUpgradeProcesses = _upgradeProcesses.tailMap(fromSchemaVersion, false);
        return pendingUpgradeProcesses.keySet();
    }

    protected void updateSchemaVersion(Version newSchemaVersion) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Release_ set schemaVersion = ? where servletContextName = ?");){
            preparedStatement.setString(1, newSchemaVersion.toString());
            preparedStatement.setString(2, "portal");
            preparedStatement.execute();
        }
    }

    private void _initializeRelease(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("update Release_ set schemaVersion = ?, buildNumber = ? where servletContextName = ? and buildNumber < ?");){
            preparedStatement.setString(1, _initialSchemaVersion.toString());
            preparedStatement.setInt(2, 7100);
            preparedStatement.setString(3, "portal");
            preparedStatement.setInt(4, 7100);
            preparedStatement.execute();
        }
    }

    static {
        try {
            for (Class<?> portalUpgradeProcessRegistry : _PORTAL_UPGRADE_PROCESS_REGISTRIES) {
                PortalUpgradeProcessRegistry registry = (PortalUpgradeProcessRegistry)portalUpgradeProcessRegistry.newInstance();
                registry.registerUpgradeProcesses(_upgradeProcesses);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

