/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.DuplicateVocabularyException;
import com.liferay.asset.kernel.exception.DuplicateVocabularyExternalReferenceCodeException;
import com.liferay.asset.kernel.exception.VocabularyNameException;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.service.base.AssetVocabularyLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyLocalServiceImpl
extends AssetVocabularyLocalServiceBaseImpl {
    @BeanReference(type=AssetCategoryLocalService.class)
    private AssetCategoryLocalService _assetCategoryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public AssetVocabulary addDefaultVocabulary(long groupId) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        long defaultUserId = this._userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            titleMap.put(locale, LanguageUtil.get((Locale)locale, (String)PropsValues.ASSET_VOCABULARY_DEFAULT));
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        return this.assetVocabularyLocalService.addVocabulary(defaultUserId, groupId, "", titleMap, null, "", serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType, ServiceContext serviceContext) throws PortalException {
        return this.assetVocabularyLocalService.addVocabulary(null, userId, groupId, titleMap.get(LocaleUtil.getSiteDefault()), title, titleMap, descriptionMap, settings, visibilityType, serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.assetVocabularyLocalService.addVocabulary(userId, groupId, titleMap.get(LocaleUtil.getSiteDefault()), title, titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, long groupId, String title, ServiceContext serviceContext) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        return this.assetVocabularyLocalService.addVocabulary(userId, groupId, title, (Map)HashMapBuilder.put((Object)locale, (Object)title).build(), (Map)HashMapBuilder.put((Object)locale, (Object)"").build(), null, serviceContext);
    }

    public AssetVocabulary addVocabulary(long userId, long groupId, String name, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.addVocabulary(null, userId, groupId, name, title, titleMap, descriptionMap, settings, 0, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary addVocabulary(String externalReferenceCode, long userId, long groupId, String name, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (Validator.isNull((String)name)) {
            name = this._generateVocabularyName(groupId, titleMap.get(LocaleUtil.getSiteDefault()));
        }
        name = this._getVocabularyName(name);
        this.validate(groupId, name);
        long vocabularyId = this.counterLocalService.increment();
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
        vocabulary.setUuid(serviceContext.getUuid());
        vocabulary.setExternalReferenceCode(externalReferenceCode);
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setName(name);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        } else {
            vocabulary.setTitleMap(titleMap);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        vocabulary.setVisibilityType(visibilityType);
        vocabulary = (AssetVocabulary)this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getModelPermissions());
        }
        return vocabulary;
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), modelPermissions);
    }

    public void deleteVocabularies(long groupId) throws PortalException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public AssetVocabulary deleteVocabulary(AssetVocabulary vocabulary) throws PortalException {
        this.assetVocabularyPersistence.remove((BaseModel)vocabulary);
        this._resourceLocalService.deleteResource(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this._assetCategoryLocalService.deleteVocabularyCategories(vocabulary.getVocabularyId());
        return vocabulary;
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
    }

    public AssetVocabulary fetchGroupVocabulary(long groupId, String name) {
        return this.assetVocabularyPersistence.fetchByG_N(groupId, name);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) {
        return this.assetVocabularyPersistence.findByCompanyId(companyId);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupIds);
        if (Validator.isNull((String)className)) {
            return vocabularies;
        }
        long classNameId = this._classNameLocalService.getClassNameId(className);
        return ListUtil.filter((List)vocabularies, assetVocabulary -> assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK));
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, false);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean addDefaultVocabulary) throws PortalException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        if (!vocabularies.isEmpty() || !addDefaultVocabulary) {
            return vocabularies;
        }
        AssetVocabulary vocabulary = this.addDefaultVocabulary(groupId);
        return ListUtil.fromArray((Object[])new AssetVocabulary[]{vocabulary});
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, int visibilityType) {
        return this.assetVocabularyPersistence.findByG_V(groupId, visibilityType);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> orderByComparator) {
        return this.assetVocabularyFinder.findByG_N(groupId, name, start, end, orderByComparator);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.findByGroupId(groupIds);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds, int[] visibilityTypes) {
        return this.assetVocabularyPersistence.findByG_V(groupIds, visibilityTypes);
    }

    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.countByGroupId(groupIds);
    }

    public AssetVocabulary getGroupVocabulary(long groupId, String name) throws PortalException {
        return this.assetVocabularyPersistence.findByG_N(groupId, name);
    }

    public List<AssetVocabulary> getVocabularies(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>(documents.size());
        for (Document document : documents) {
            long vocabularyId = GetterUtil.getLong((String)document.get("assetVocabularyId"));
            AssetVocabulary vocabulary = this.fetchAssetVocabulary(vocabularyId);
            if (vocabulary == null) {
                vocabularies = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetVocabulary.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (vocabularies == null) continue;
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }

    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            vocabularies.add(this.getVocabulary(vocabularyId));
        }
        return vocabularies;
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        return this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public BaseModelSearchResult<AssetVocabulary> searchVocabularies(long companyId, long[] groupIds, String title, int[] visibilityTypes, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, visibilityTypes, start, end, sort);
        return this.searchVocabularies(searchContext);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings) throws PortalException {
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, titleMap, descriptionMap, settings, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, int visibilityType) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        vocabulary.setTitleMap(titleMap);
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        vocabulary.setVisibilityType(visibilityType);
        return (AssetVocabulary)this.assetVocabularyPersistence.update((BaseModel)vocabulary);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        vocabulary.setTitleMap(titleMap);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        return (AssetVocabulary)this.assetVocabularyPersistence.update((BaseModel)vocabulary);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String title, int[] visibilityTypes, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("title", (Serializable)((Object)title));
        searchContext.setAttribute("visibilityType", (Serializable)visibilityTypes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(title);
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected boolean hasVocabulary(long groupId, String name) {
        return this.assetVocabularyPersistence.countByG_N(groupId, name) != 0;
    }

    protected BaseModelSearchResult<AssetVocabulary> searchVocabularies(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetVocabulary> vocabularies = this.getVocabularies(hits);
            if (vocabularies == null) continue;
            return new BaseModelSearchResult(vocabularies, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new VocabularyNameException("Category vocabulary name cannot be null for group " + groupId);
        }
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A category vocabulary with the name " + name + " already exists");
        }
    }

    private String _generateVocabularyName(long groupId, String name) {
        String vocabularyName = this._getVocabularyName(name);
        String curVocabularyName = vocabularyName = StringUtil.replace((String)vocabularyName, (char)' ', (char)'-');
        int count = 0;
        AssetVocabulary vocabulary;
        while ((vocabulary = this.assetVocabularyPersistence.fetchByG_N(groupId, curVocabularyName)) != null) {
            curVocabularyName = curVocabularyName + '-' + count++;
        }
        return curVocabularyName;
    }

    private String _getVocabularyName(String vocabularyName) {
        if (vocabularyName != null) {
            vocabularyName = vocabularyName.trim();
            return StringUtil.toLowerCase((String)vocabularyName);
        }
        return "";
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        AssetVocabulary assetVocabulary = this.assetVocabularyPersistence.fetchByG_ERC(groupId, externalReferenceCode);
        if (assetVocabulary != null) {
            throw new DuplicateVocabularyExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate vocabulary external reference code ", externalReferenceCode, " in group ", groupId}));
        }
    }
}

