/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.model.impl.ExpandoValueBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExpandoValueImpl
extends ExpandoValueBaseImpl {
    private static final String _EXPANDO_COMMA = "[$LIFERAY_EXPANDO_COMMA$]";
    private transient ExpandoColumn _column;

    public List<Locale> getAvailableLocales() throws PortalException {
        if (!this.isColumnLocalized()) {
            return null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String languageId : LocalizationUtil.getAvailableLanguageIds((String)this.getData())) {
            locales.add(LocaleUtil.fromLanguageId((String)languageId));
        }
        return locales;
    }

    public boolean getBoolean() throws PortalException {
        this.validate(1);
        return GetterUtil.getBoolean((String)this.getData());
    }

    public boolean[] getBooleanArray() throws PortalException {
        this.validate(2);
        return GetterUtil.getBooleanValues((String[])StringUtil.split((String)this.getData()));
    }

    public ExpandoColumn getColumn() throws PortalException {
        if (this._column != null) {
            return this._column;
        }
        long columnId = this.getColumnId();
        if (columnId <= 0L) {
            return null;
        }
        return ExpandoColumnLocalServiceUtil.getColumn((long)columnId);
    }

    public Date getDate() throws PortalException {
        this.validate(3);
        return new Date(GetterUtil.getLong((String)this.getData()));
    }

    public Date[] getDateArray() throws PortalException {
        this.validate(4);
        String[] data = StringUtil.split((String)this.getData());
        Date[] dateArray = new Date[data.length];
        for (int i = 0; i < data.length; ++i) {
            dateArray[i] = new Date(GetterUtil.getLong((String)data[i]));
        }
        return dateArray;
    }

    public Locale getDefaultLocale() throws PortalException {
        if (!this.isColumnLocalized()) {
            return null;
        }
        return LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)this.getData()));
    }

    public double getDouble() throws PortalException {
        this.validate(5);
        return GetterUtil.getDouble((String)this.getData());
    }

    public double[] getDoubleArray() throws PortalException {
        this.validate(6);
        return GetterUtil.getDoubleValues((String[])StringUtil.split((String)this.getData()));
    }

    public float getFloat() throws PortalException {
        this.validate(7);
        return GetterUtil.getFloat((String)this.getData());
    }

    public float[] getFloatArray() throws PortalException {
        this.validate(8);
        return GetterUtil.getFloatValues((String[])StringUtil.split((String)this.getData()));
    }

    public JSONObject getGeolocationJSONObject() throws PortalException {
        this.validate(21);
        return JSONFactoryUtil.createJSONObject((String)this.getData());
    }

    public int getInteger() throws PortalException {
        this.validate(9);
        return GetterUtil.getInteger((String)this.getData());
    }

    public int[] getIntegerArray() throws PortalException {
        this.validate(10);
        return GetterUtil.getIntegerValues((String[])StringUtil.split((String)this.getData()));
    }

    public long getLong() throws PortalException {
        this.validate(11);
        return GetterUtil.getLong((String)this.getData());
    }

    public long[] getLongArray() throws PortalException {
        this.validate(12);
        return GetterUtil.getLongValues((String[])StringUtil.split((String)this.getData()));
    }

    public Number getNumber() throws PortalException {
        this.validate(17);
        return GetterUtil.getNumber((String)this.getData());
    }

    public Number[] getNumberArray() throws PortalException {
        this.validate(18);
        return GetterUtil.getNumberValues((String[])StringUtil.split((String)this.getData()));
    }

    public Serializable getSerializable() throws PortalException {
        ExpandoColumn column = this.getColumn();
        int type = column.getType();
        if (type == 1) {
            return Boolean.valueOf(this.getBoolean());
        }
        if (type == 2) {
            return this.getBooleanArray();
        }
        if (type == 3) {
            return this.getDate();
        }
        if (type == 4) {
            return this.getDateArray();
        }
        if (type == 5) {
            return Double.valueOf(this.getDouble());
        }
        if (type == 6) {
            return this.getDoubleArray();
        }
        if (type == 7) {
            return Float.valueOf(this.getFloat());
        }
        if (type == 8) {
            return this.getFloatArray();
        }
        if (type == 9) {
            return Integer.valueOf(this.getInteger());
        }
        if (type == 10) {
            return this.getIntegerArray();
        }
        if (type == 11) {
            return Long.valueOf(this.getLong());
        }
        if (type == 12) {
            return this.getLongArray();
        }
        if (type == 17) {
            return this.getNumber();
        }
        if (type == 18) {
            return this.getNumberArray();
        }
        if (type == 13) {
            return Short.valueOf(this.getShort());
        }
        if (type == 14) {
            return this.getShortArray();
        }
        if (type == 16) {
            return this.getStringArray();
        }
        if (type == 19) {
            return (Serializable)((Object)this.getStringArrayMap());
        }
        if (type == 20) {
            return (Serializable)((Object)this.getStringMap());
        }
        return this.getData();
    }

    public short getShort() throws PortalException {
        this.validate(13);
        return GetterUtil.getShort((String)this.getData());
    }

    public short[] getShortArray() throws PortalException {
        this.validate(14);
        return GetterUtil.getShortValues((String[])StringUtil.split((String)this.getData()));
    }

    public String getString() throws PortalException {
        this.validate(15);
        return this.getData();
    }

    public String getString(Locale locale) throws PortalException {
        this.validate(20);
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getData(languageId);
    }

    public String[] getStringArray() throws PortalException {
        this.validate(16);
        return this.split(this.getData());
    }

    public String[] getStringArray(Locale locale) throws PortalException {
        this.validate(19);
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.split(this.getData(languageId));
    }

    public Map<Locale, String[]> getStringArrayMap() throws PortalException {
        this.validate(19);
        Map stringMap = LocalizationUtil.getLocalizationMap((String)this.getData());
        HashMap<Locale, String[]> stringArrayMap = new HashMap<Locale, String[]>();
        for (Map.Entry entry : stringMap.entrySet()) {
            stringArrayMap.put((Locale)entry.getKey(), this.split((String)entry.getValue()));
        }
        return stringArrayMap;
    }

    public Map<Locale, String> getStringMap() throws PortalException {
        this.validate(20);
        return LocalizationUtil.getLocalizationMap((String)this.getData());
    }

    public void setBoolean(boolean data) throws PortalException {
        this.validate(1);
        this.setData(String.valueOf(data));
    }

    public void setBooleanArray(boolean[] data) throws PortalException {
        this.validate(2);
        this.setData(StringUtil.merge((boolean[])data));
    }

    public void setColumn(ExpandoColumn column) {
        this._column = column;
        this.setColumnId(this._column.getColumnId());
    }

    public void setDate(Date data) throws PortalException {
        this.validate(3);
        this.setData(String.valueOf(data.getTime()));
    }

    public void setDateArray(Date[] data) throws PortalException {
        this.validate(4);
        if (data.length > 0) {
            StringBundler sb = new StringBundler(data.length * 2);
            for (Date date : data) {
                sb.append(date.getTime());
                sb.append(",");
            }
            sb.setIndex(sb.index() - 1);
            this.setData(sb.toString());
        } else {
            this.setData("");
        }
    }

    public void setDouble(double data) throws PortalException {
        this.validate(5);
        this.setData(String.valueOf(data));
    }

    public void setDoubleArray(double[] data) throws PortalException {
        this.validate(6);
        this.setData(StringUtil.merge((double[])data));
    }

    public void setFloat(float data) throws PortalException {
        this.validate(7);
        this.setData(String.valueOf(data));
    }

    public void setFloatArray(float[] data) throws PortalException {
        this.validate(8);
        this.setData(StringUtil.merge((float[])data));
    }

    public void setGeolocationJSONObject(JSONObject dataJSONObject) throws PortalException {
        this.validate(21);
        this.setData(dataJSONObject.toString());
    }

    public void setInteger(int data) throws PortalException {
        this.validate(9);
        this.setData(String.valueOf(data));
    }

    public void setIntegerArray(int[] data) throws PortalException {
        this.validate(10);
        this.setData(StringUtil.merge((int[])data));
    }

    public void setLong(long data) throws PortalException {
        this.validate(11);
        this.setData(String.valueOf(data));
    }

    public void setLongArray(long[] data) throws PortalException {
        this.validate(12);
        this.setData(StringUtil.merge((long[])data));
    }

    public void setNumber(Number data) throws PortalException {
        this.validate(17);
        this.setData(String.valueOf(data));
    }

    public void setNumberArray(Number[] data) throws PortalException {
        this.validate(18);
        this.setData(StringUtil.merge((Object[])data));
    }

    public void setShort(short data) throws PortalException {
        this.validate(13);
        this.setData(String.valueOf(data));
    }

    public void setShortArray(short[] data) throws PortalException {
        this.validate(14);
        this.setData(StringUtil.merge((short[])data));
    }

    public void setString(String data) throws PortalException {
        this.validate(15);
        this.setData(data);
    }

    public void setString(String data, Locale locale, Locale defaultLocale) throws PortalException {
        this.validate(20);
        this.doSetString(data, locale, defaultLocale);
    }

    public void setStringArray(String[] data) throws PortalException {
        this.validate(16);
        this.setData(this.merge(data));
    }

    public void setStringArray(String[] data, Locale locale, Locale defaultLocale) throws PortalException {
        this.validate(19);
        this.doSetString(this.merge(data), locale, defaultLocale);
    }

    public void setStringArrayMap(Map<Locale, String[]> dataMap, Locale defaultLocale) throws PortalException {
        this.validate(19);
        HashMap<Locale, String> stringMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String[]> entry : dataMap.entrySet()) {
            stringMap.put(entry.getKey(), this.merge(entry.getValue()));
        }
        this.doSetStringMap(stringMap, defaultLocale);
    }

    public void setStringMap(Map<Locale, String> dataMap, Locale defaultLocale) throws PortalException {
        this.validate(20);
        this.doSetStringMap(dataMap, defaultLocale);
    }

    protected void doSetString(String data, Locale locale, Locale defaultLocale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        if (Validator.isNotNull((String)data)) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
            data = LocalizationUtil.updateLocalization((String)this.getData(), (String)"Data", (String)data, (String)languageId, (String)defaultLanguageId);
        } else {
            data = LocalizationUtil.removeLocalization((String)this.getData(), (String)"Data", (String)languageId);
        }
        this.setData(data);
    }

    protected void doSetStringMap(Map<Locale, String> dataMap, Locale defaultLocale) {
        if (dataMap == null) {
            return;
        }
        this.setData(LocalizationUtil.updateLocalization(dataMap, (String)this.getData(), (String)"Data", (String)LocaleUtil.toLanguageId((Locale)defaultLocale)));
    }

    protected String getData(String languageId) {
        return LocalizationUtil.getLocalization((String)this.getData(), (String)languageId);
    }

    protected boolean isColumnLocalized() throws PortalException {
        ExpandoColumn column = this.getColumn();
        if (column == null) {
            return false;
        }
        return column.getType() == 19 || column.getType() == 20;
    }

    protected String merge(String[] data) {
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = StringUtil.replace((String)data[i], (char)',', (String)_EXPANDO_COMMA);
            }
        }
        return StringUtil.merge((Object[])data);
    }

    protected String[] split(String data) {
        String[] dataArray = StringUtil.split((String)data);
        for (int i = 0; i < dataArray.length; ++i) {
            dataArray[i] = StringUtil.replace((String)dataArray[i], (String)_EXPANDO_COMMA, (String)",");
        }
        return dataArray;
    }

    protected void validate(int type) throws PortalException {
        ExpandoColumn column = this.getColumn();
        if (column == null || column.getType() == type) {
            return;
        }
        throw new ValueDataException(StringBundler.concat((Object[])new Object[]{"Column ", this.getColumnId(), " has type ", ExpandoColumnConstants.getTypeLabel((int)column.getType()), " and is not compatible with type ", ExpandoColumnConstants.getTypeLabel((int)type)}));
    }
}

