/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the User service. Represents a row in the &quot;User_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>UserModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserImpl
 * @generated
 */
@JSON(strict = true)
public class UserModelImpl extends BaseModelImpl<User> implements UserModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user model instance should use the <code>User</code> interface instead.
	 */
	public static final String TABLE_NAME = "User_";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"userId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"defaultUser", Types.BOOLEAN}, {"contactId", Types.BIGINT},
		{"password_", Types.VARCHAR}, {"passwordEncrypted", Types.BOOLEAN},
		{"passwordReset", Types.BOOLEAN},
		{"passwordModifiedDate", Types.TIMESTAMP}, {"digest", Types.VARCHAR},
		{"reminderQueryQuestion", Types.VARCHAR},
		{"reminderQueryAnswer", Types.VARCHAR},
		{"graceLoginCount", Types.INTEGER}, {"screenName", Types.VARCHAR},
		{"emailAddress", Types.VARCHAR}, {"facebookId", Types.BIGINT},
		{"googleUserId", Types.VARCHAR}, {"ldapServerId", Types.BIGINT},
		{"openId", Types.VARCHAR}, {"portraitId", Types.BIGINT},
		{"languageId", Types.VARCHAR}, {"timeZoneId", Types.VARCHAR},
		{"greeting", Types.VARCHAR}, {"comments", Types.VARCHAR},
		{"firstName", Types.VARCHAR}, {"middleName", Types.VARCHAR},
		{"lastName", Types.VARCHAR}, {"jobTitle", Types.VARCHAR},
		{"loginDate", Types.TIMESTAMP}, {"loginIP", Types.VARCHAR},
		{"lastLoginDate", Types.TIMESTAMP}, {"lastLoginIP", Types.VARCHAR},
		{"lastFailedLoginDate", Types.TIMESTAMP},
		{"failedLoginAttempts", Types.INTEGER}, {"lockout", Types.BOOLEAN},
		{"lockoutDate", Types.TIMESTAMP}, {"agreedToTermsOfUse", Types.BOOLEAN},
		{"emailAddressVerified", Types.BOOLEAN}, {"status", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultUser", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("contactId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("password_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("passwordEncrypted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("passwordReset", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("passwordModifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("digest", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("reminderQueryQuestion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("reminderQueryAnswer", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("graceLoginCount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("screenName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("emailAddress", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("facebookId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("googleUserId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("ldapServerId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("openId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("portraitId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("languageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("timeZoneId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("greeting", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("comments", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("firstName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("middleName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("jobTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("loginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("loginIP", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastLoginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastLoginIP", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastFailedLoginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("failedLoginAttempts", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lockoutDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("agreedToTermsOfUse", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("emailAddressVerified", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table User_ (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,userId LONG not null,companyId LONG,createDate DATE null,modifiedDate DATE null,defaultUser BOOLEAN,contactId LONG,password_ VARCHAR(75) null,passwordEncrypted BOOLEAN,passwordReset BOOLEAN,passwordModifiedDate DATE null,digest VARCHAR(255) null,reminderQueryQuestion VARCHAR(75) null,reminderQueryAnswer VARCHAR(75) null,graceLoginCount INTEGER,screenName VARCHAR(75) null,emailAddress VARCHAR(254) null,facebookId LONG,googleUserId VARCHAR(75) null,ldapServerId LONG,openId VARCHAR(1024) null,portraitId LONG,languageId VARCHAR(75) null,timeZoneId VARCHAR(75) null,greeting VARCHAR(255) null,comments STRING null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,lastName VARCHAR(75) null,jobTitle VARCHAR(100) null,loginDate DATE null,loginIP VARCHAR(75) null,lastLoginDate DATE null,lastLoginIP VARCHAR(75) null,lastFailedLoginDate DATE null,failedLoginAttempts INTEGER,lockout BOOLEAN,lockoutDate DATE null,agreedToTermsOfUse BOOLEAN,emailAddressVerified BOOLEAN,status INTEGER,primary key (userId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table User_";

	public static final String ORDER_BY_JPQL = " ORDER BY user.userId ASC";

	public static final String ORDER_BY_SQL = " ORDER BY User_.userId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CONTACTID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTUSER_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EMAILADDRESS_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FACEBOOKID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GOOGLEUSERID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OPENID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PORTRAITID_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SCREENNAME_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16384L;

	public static final String MAPPING_TABLE_USERS_GROUPS_NAME = "Users_Groups";

	public static final Object[][] MAPPING_TABLE_USERS_GROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_GROUPS_SQL_CREATE =
		"create table Users_Groups (companyId LONG not null,groupId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, userId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_GROUPS = true;

	public static final String MAPPING_TABLE_USERS_ORGS_NAME = "Users_Orgs";

	public static final Object[][] MAPPING_TABLE_USERS_ORGS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"organizationId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_ORGS_SQL_CREATE =
		"create table Users_Orgs (companyId LONG not null,organizationId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (organizationId, userId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_ORGS = true;

	public static final String MAPPING_TABLE_USERS_ROLES_NAME = "Users_Roles";

	public static final Object[][] MAPPING_TABLE_USERS_ROLES_COLUMNS = {
		{"companyId", Types.BIGINT}, {"roleId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_ROLES_SQL_CREATE =
		"create table Users_Roles (companyId LONG not null,roleId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (roleId, userId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_ROLES = true;

	public static final String MAPPING_TABLE_USERS_TEAMS_NAME = "Users_Teams";

	public static final Object[][] MAPPING_TABLE_USERS_TEAMS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"teamId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_TEAMS_SQL_CREATE =
		"create table Users_Teams (companyId LONG not null,teamId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (teamId, userId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_TEAMS = true;

	public static final String MAPPING_TABLE_USERS_USERGROUPS_NAME =
		"Users_UserGroups";

	public static final Object[][] MAPPING_TABLE_USERS_USERGROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userGroupId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_USERGROUPS_SQL_CREATE =
		"create table Users_UserGroups (companyId LONG not null,userId LONG not null,userGroupId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (userId, userGroupId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_USERS_USERGROUPS = true;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.User"));

	public UserModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _userId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setUserId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _userId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return User.class;
	}

	@Override
	public String getModelClassName() {
		return User.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((User)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<User, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<User, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept((User)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<User, Object>> getAttributeGetterFunctions() {
		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<User, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<User, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<User, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<User, Object>>();
		Map<String, BiConsumer<User, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<User, ?>>();

		attributeGetterFunctions.put("mvccVersion", User::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion", (BiConsumer<User, Long>)User::setMvccVersion);
		attributeGetterFunctions.put("ctCollectionId", User::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId", (BiConsumer<User, Long>)User::setCtCollectionId);
		attributeGetterFunctions.put("uuid", User::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<User, String>)User::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode", User::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<User, String>)User::setExternalReferenceCode);
		attributeGetterFunctions.put("userId", User::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<User, Long>)User::setUserId);
		attributeGetterFunctions.put("companyId", User::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<User, Long>)User::setCompanyId);
		attributeGetterFunctions.put("createDate", User::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<User, Date>)User::setCreateDate);
		attributeGetterFunctions.put("modifiedDate", User::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate", (BiConsumer<User, Date>)User::setModifiedDate);
		attributeGetterFunctions.put("defaultUser", User::getDefaultUser);
		attributeSetterBiConsumers.put(
			"defaultUser", (BiConsumer<User, Boolean>)User::setDefaultUser);
		attributeGetterFunctions.put("contactId", User::getContactId);
		attributeSetterBiConsumers.put(
			"contactId", (BiConsumer<User, Long>)User::setContactId);
		attributeGetterFunctions.put("password", User::getPassword);
		attributeSetterBiConsumers.put(
			"password", (BiConsumer<User, String>)User::setPassword);
		attributeGetterFunctions.put(
			"passwordEncrypted", User::getPasswordEncrypted);
		attributeSetterBiConsumers.put(
			"passwordEncrypted",
			(BiConsumer<User, Boolean>)User::setPasswordEncrypted);
		attributeGetterFunctions.put("passwordReset", User::getPasswordReset);
		attributeSetterBiConsumers.put(
			"passwordReset", (BiConsumer<User, Boolean>)User::setPasswordReset);
		attributeGetterFunctions.put(
			"passwordModifiedDate", User::getPasswordModifiedDate);
		attributeSetterBiConsumers.put(
			"passwordModifiedDate",
			(BiConsumer<User, Date>)User::setPasswordModifiedDate);
		attributeGetterFunctions.put("digest", User::getDigest);
		attributeSetterBiConsumers.put(
			"digest", (BiConsumer<User, String>)User::setDigest);
		attributeGetterFunctions.put(
			"reminderQueryQuestion", User::getReminderQueryQuestion);
		attributeSetterBiConsumers.put(
			"reminderQueryQuestion",
			(BiConsumer<User, String>)User::setReminderQueryQuestion);
		attributeGetterFunctions.put(
			"reminderQueryAnswer", User::getReminderQueryAnswer);
		attributeSetterBiConsumers.put(
			"reminderQueryAnswer",
			(BiConsumer<User, String>)User::setReminderQueryAnswer);
		attributeGetterFunctions.put(
			"graceLoginCount", User::getGraceLoginCount);
		attributeSetterBiConsumers.put(
			"graceLoginCount",
			(BiConsumer<User, Integer>)User::setGraceLoginCount);
		attributeGetterFunctions.put("screenName", User::getScreenName);
		attributeSetterBiConsumers.put(
			"screenName", (BiConsumer<User, String>)User::setScreenName);
		attributeGetterFunctions.put("emailAddress", User::getEmailAddress);
		attributeSetterBiConsumers.put(
			"emailAddress", (BiConsumer<User, String>)User::setEmailAddress);
		attributeGetterFunctions.put("facebookId", User::getFacebookId);
		attributeSetterBiConsumers.put(
			"facebookId", (BiConsumer<User, Long>)User::setFacebookId);
		attributeGetterFunctions.put("googleUserId", User::getGoogleUserId);
		attributeSetterBiConsumers.put(
			"googleUserId", (BiConsumer<User, String>)User::setGoogleUserId);
		attributeGetterFunctions.put("ldapServerId", User::getLdapServerId);
		attributeSetterBiConsumers.put(
			"ldapServerId", (BiConsumer<User, Long>)User::setLdapServerId);
		attributeGetterFunctions.put("openId", User::getOpenId);
		attributeSetterBiConsumers.put(
			"openId", (BiConsumer<User, String>)User::setOpenId);
		attributeGetterFunctions.put("portraitId", User::getPortraitId);
		attributeSetterBiConsumers.put(
			"portraitId", (BiConsumer<User, Long>)User::setPortraitId);
		attributeGetterFunctions.put("languageId", User::getLanguageId);
		attributeSetterBiConsumers.put(
			"languageId", (BiConsumer<User, String>)User::setLanguageId);
		attributeGetterFunctions.put("timeZoneId", User::getTimeZoneId);
		attributeSetterBiConsumers.put(
			"timeZoneId", (BiConsumer<User, String>)User::setTimeZoneId);
		attributeGetterFunctions.put("greeting", User::getGreeting);
		attributeSetterBiConsumers.put(
			"greeting", (BiConsumer<User, String>)User::setGreeting);
		attributeGetterFunctions.put("comments", User::getComments);
		attributeSetterBiConsumers.put(
			"comments", (BiConsumer<User, String>)User::setComments);
		attributeGetterFunctions.put("firstName", User::getFirstName);
		attributeSetterBiConsumers.put(
			"firstName", (BiConsumer<User, String>)User::setFirstName);
		attributeGetterFunctions.put("middleName", User::getMiddleName);
		attributeSetterBiConsumers.put(
			"middleName", (BiConsumer<User, String>)User::setMiddleName);
		attributeGetterFunctions.put("lastName", User::getLastName);
		attributeSetterBiConsumers.put(
			"lastName", (BiConsumer<User, String>)User::setLastName);
		attributeGetterFunctions.put("jobTitle", User::getJobTitle);
		attributeSetterBiConsumers.put(
			"jobTitle", (BiConsumer<User, String>)User::setJobTitle);
		attributeGetterFunctions.put("loginDate", User::getLoginDate);
		attributeSetterBiConsumers.put(
			"loginDate", (BiConsumer<User, Date>)User::setLoginDate);
		attributeGetterFunctions.put("loginIP", User::getLoginIP);
		attributeSetterBiConsumers.put(
			"loginIP", (BiConsumer<User, String>)User::setLoginIP);
		attributeGetterFunctions.put("lastLoginDate", User::getLastLoginDate);
		attributeSetterBiConsumers.put(
			"lastLoginDate", (BiConsumer<User, Date>)User::setLastLoginDate);
		attributeGetterFunctions.put("lastLoginIP", User::getLastLoginIP);
		attributeSetterBiConsumers.put(
			"lastLoginIP", (BiConsumer<User, String>)User::setLastLoginIP);
		attributeGetterFunctions.put(
			"lastFailedLoginDate", User::getLastFailedLoginDate);
		attributeSetterBiConsumers.put(
			"lastFailedLoginDate",
			(BiConsumer<User, Date>)User::setLastFailedLoginDate);
		attributeGetterFunctions.put(
			"failedLoginAttempts", User::getFailedLoginAttempts);
		attributeSetterBiConsumers.put(
			"failedLoginAttempts",
			(BiConsumer<User, Integer>)User::setFailedLoginAttempts);
		attributeGetterFunctions.put("lockout", User::getLockout);
		attributeSetterBiConsumers.put(
			"lockout", (BiConsumer<User, Boolean>)User::setLockout);
		attributeGetterFunctions.put("lockoutDate", User::getLockoutDate);
		attributeSetterBiConsumers.put(
			"lockoutDate", (BiConsumer<User, Date>)User::setLockoutDate);
		attributeGetterFunctions.put(
			"agreedToTermsOfUse", User::getAgreedToTermsOfUse);
		attributeSetterBiConsumers.put(
			"agreedToTermsOfUse",
			(BiConsumer<User, Boolean>)User::setAgreedToTermsOfUse);
		attributeGetterFunctions.put(
			"emailAddressVerified", User::getEmailAddressVerified);
		attributeSetterBiConsumers.put(
			"emailAddressVerified",
			(BiConsumer<User, Boolean>)User::setEmailAddressVerified);
		attributeGetterFunctions.put("status", User::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<User, Integer>)User::setStatus);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalCreateDate() {
		return getColumnOriginalValue("createDate");
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalModifiedDate() {
		return getColumnOriginalValue("modifiedDate");
	}

	@JSON
	@Override
	public boolean getDefaultUser() {
		return _defaultUser;
	}

	@JSON
	@Override
	public boolean isDefaultUser() {
		return _defaultUser;
	}

	@Override
	public void setDefaultUser(boolean defaultUser) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultUser = defaultUser;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultUser() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultUser"));
	}

	@JSON
	@Override
	public long getContactId() {
		return _contactId;
	}

	@Override
	public void setContactId(long contactId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_contactId = contactId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalContactId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("contactId"));
	}

	@JSON(include = false)
	@Override
	public String getPassword() {
		if (_password == null) {
			return "";
		}
		else {
			return _password;
		}
	}

	@Override
	public void setPassword(String password) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_password = password;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public boolean isPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public void setPasswordEncrypted(boolean passwordEncrypted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_passwordEncrypted = passwordEncrypted;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordReset() {
		return _passwordReset;
	}

	@Override
	public boolean isPasswordReset() {
		return _passwordReset;
	}

	@Override
	public void setPasswordReset(boolean passwordReset) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_passwordReset = passwordReset;
	}

	@JSON(include = false)
	@Override
	public Date getPasswordModifiedDate() {
		return _passwordModifiedDate;
	}

	@Override
	public void setPasswordModifiedDate(Date passwordModifiedDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_passwordModifiedDate = passwordModifiedDate;
	}

	@JSON(include = false)
	@Override
	public String getDigest() {
		if (_digest == null) {
			return "";
		}
		else {
			return _digest;
		}
	}

	@Override
	public void setDigest(String digest) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_digest = digest;
	}

	@JSON
	@Override
	public String getReminderQueryQuestion() {
		if (_reminderQueryQuestion == null) {
			return "";
		}
		else {
			return _reminderQueryQuestion;
		}
	}

	@Override
	public void setReminderQueryQuestion(String reminderQueryQuestion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reminderQueryQuestion = reminderQueryQuestion;
	}

	@JSON
	@Override
	public String getReminderQueryAnswer() {
		if (_reminderQueryAnswer == null) {
			return "";
		}
		else {
			return _reminderQueryAnswer;
		}
	}

	@Override
	public void setReminderQueryAnswer(String reminderQueryAnswer) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reminderQueryAnswer = reminderQueryAnswer;
	}

	@JSON
	@Override
	public int getGraceLoginCount() {
		return _graceLoginCount;
	}

	@Override
	public void setGraceLoginCount(int graceLoginCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_graceLoginCount = graceLoginCount;
	}

	@JSON
	@Override
	public String getScreenName() {
		if (_screenName == null) {
			return "";
		}
		else {
			return _screenName;
		}
	}

	@Override
	public void setScreenName(String screenName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_screenName = screenName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalScreenName() {
		return getColumnOriginalValue("screenName");
	}

	@JSON
	@Override
	public String getEmailAddress() {
		if (_emailAddress == null) {
			return "";
		}
		else {
			return _emailAddress;
		}
	}

	@Override
	public void setEmailAddress(String emailAddress) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_emailAddress = emailAddress;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalEmailAddress() {
		return getColumnOriginalValue("emailAddress");
	}

	@JSON
	@Override
	public long getFacebookId() {
		return _facebookId;
	}

	@Override
	public void setFacebookId(long facebookId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_facebookId = facebookId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFacebookId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("facebookId"));
	}

	@JSON
	@Override
	public String getGoogleUserId() {
		if (_googleUserId == null) {
			return "";
		}
		else {
			return _googleUserId;
		}
	}

	@Override
	public void setGoogleUserId(String googleUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_googleUserId = googleUserId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalGoogleUserId() {
		return getColumnOriginalValue("googleUserId");
	}

	@JSON
	@Override
	public long getLdapServerId() {
		return _ldapServerId;
	}

	@Override
	public void setLdapServerId(long ldapServerId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ldapServerId = ldapServerId;
	}

	@JSON
	@Override
	public String getOpenId() {
		if (_openId == null) {
			return "";
		}
		else {
			return _openId;
		}
	}

	@Override
	public void setOpenId(String openId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_openId = openId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalOpenId() {
		return getColumnOriginalValue("openId");
	}

	@JSON
	@Override
	public long getPortraitId() {
		return _portraitId;
	}

	@Override
	public void setPortraitId(long portraitId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_portraitId = portraitId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPortraitId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("portraitId"));
	}

	@JSON
	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return "";
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_languageId = languageId;
	}

	@JSON
	@Override
	public String getTimeZoneId() {
		if (_timeZoneId == null) {
			return "";
		}
		else {
			return _timeZoneId;
		}
	}

	@Override
	public void setTimeZoneId(String timeZoneId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_timeZoneId = timeZoneId;
	}

	@JSON
	@Override
	public String getGreeting() {
		if (_greeting == null) {
			return "";
		}
		else {
			return _greeting;
		}
	}

	@Override
	public void setGreeting(String greeting) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_greeting = greeting;
	}

	@JSON
	@Override
	public String getComments() {
		if (_comments == null) {
			return "";
		}
		else {
			return _comments;
		}
	}

	@Override
	public void setComments(String comments) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_comments = comments;
	}

	@JSON
	@Override
	public String getFirstName() {
		if (_firstName == null) {
			return "";
		}
		else {
			return _firstName;
		}
	}

	@Override
	public void setFirstName(String firstName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_firstName = firstName;
	}

	@JSON
	@Override
	public String getMiddleName() {
		if (_middleName == null) {
			return "";
		}
		else {
			return _middleName;
		}
	}

	@Override
	public void setMiddleName(String middleName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_middleName = middleName;
	}

	@JSON
	@Override
	public String getLastName() {
		if (_lastName == null) {
			return "";
		}
		else {
			return _lastName;
		}
	}

	@Override
	public void setLastName(String lastName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastName = lastName;
	}

	@JSON
	@Override
	public String getJobTitle() {
		if (_jobTitle == null) {
			return "";
		}
		else {
			return _jobTitle;
		}
	}

	@Override
	public void setJobTitle(String jobTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_jobTitle = jobTitle;
	}

	@JSON
	@Override
	public Date getLoginDate() {
		return _loginDate;
	}

	@Override
	public void setLoginDate(Date loginDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_loginDate = loginDate;
	}

	@JSON
	@Override
	public String getLoginIP() {
		if (_loginIP == null) {
			return "";
		}
		else {
			return _loginIP;
		}
	}

	@Override
	public void setLoginIP(String loginIP) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_loginIP = loginIP;
	}

	@JSON
	@Override
	public Date getLastLoginDate() {
		return _lastLoginDate;
	}

	@Override
	public void setLastLoginDate(Date lastLoginDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastLoginDate = lastLoginDate;
	}

	@JSON
	@Override
	public String getLastLoginIP() {
		if (_lastLoginIP == null) {
			return "";
		}
		else {
			return _lastLoginIP;
		}
	}

	@Override
	public void setLastLoginIP(String lastLoginIP) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastLoginIP = lastLoginIP;
	}

	@JSON
	@Override
	public Date getLastFailedLoginDate() {
		return _lastFailedLoginDate;
	}

	@Override
	public void setLastFailedLoginDate(Date lastFailedLoginDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastFailedLoginDate = lastFailedLoginDate;
	}

	@JSON
	@Override
	public int getFailedLoginAttempts() {
		return _failedLoginAttempts;
	}

	@Override
	public void setFailedLoginAttempts(int failedLoginAttempts) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_failedLoginAttempts = failedLoginAttempts;
	}

	@JSON
	@Override
	public boolean getLockout() {
		return _lockout;
	}

	@JSON
	@Override
	public boolean isLockout() {
		return _lockout;
	}

	@Override
	public void setLockout(boolean lockout) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockout = lockout;
	}

	@JSON
	@Override
	public Date getLockoutDate() {
		return _lockoutDate;
	}

	@Override
	public void setLockoutDate(Date lockoutDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockoutDate = lockoutDate;
	}

	@JSON
	@Override
	public boolean getAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@JSON
	@Override
	public boolean isAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@Override
	public void setAgreedToTermsOfUse(boolean agreedToTermsOfUse) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_agreedToTermsOfUse = agreedToTermsOfUse;
	}

	@JSON
	@Override
	public boolean getEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@JSON
	@Override
	public boolean isEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@Override
	public void setEmailAddressVerified(boolean emailAddressVerified) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_emailAddressVerified = emailAddressVerified;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(User.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), User.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public User toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, User>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		UserImpl userImpl = new UserImpl();

		userImpl.setMvccVersion(getMvccVersion());
		userImpl.setCtCollectionId(getCtCollectionId());
		userImpl.setUuid(getUuid());
		userImpl.setExternalReferenceCode(getExternalReferenceCode());
		userImpl.setUserId(getUserId());
		userImpl.setCompanyId(getCompanyId());
		userImpl.setCreateDate(getCreateDate());
		userImpl.setModifiedDate(getModifiedDate());
		userImpl.setDefaultUser(isDefaultUser());
		userImpl.setContactId(getContactId());
		userImpl.setPassword(getPassword());
		userImpl.setPasswordEncrypted(isPasswordEncrypted());
		userImpl.setPasswordReset(isPasswordReset());
		userImpl.setPasswordModifiedDate(getPasswordModifiedDate());
		userImpl.setDigest(getDigest());
		userImpl.setReminderQueryQuestion(getReminderQueryQuestion());
		userImpl.setReminderQueryAnswer(getReminderQueryAnswer());
		userImpl.setGraceLoginCount(getGraceLoginCount());
		userImpl.setScreenName(getScreenName());
		userImpl.setEmailAddress(getEmailAddress());
		userImpl.setFacebookId(getFacebookId());
		userImpl.setGoogleUserId(getGoogleUserId());
		userImpl.setLdapServerId(getLdapServerId());
		userImpl.setOpenId(getOpenId());
		userImpl.setPortraitId(getPortraitId());
		userImpl.setLanguageId(getLanguageId());
		userImpl.setTimeZoneId(getTimeZoneId());
		userImpl.setGreeting(getGreeting());
		userImpl.setComments(getComments());
		userImpl.setFirstName(getFirstName());
		userImpl.setMiddleName(getMiddleName());
		userImpl.setLastName(getLastName());
		userImpl.setJobTitle(getJobTitle());
		userImpl.setLoginDate(getLoginDate());
		userImpl.setLoginIP(getLoginIP());
		userImpl.setLastLoginDate(getLastLoginDate());
		userImpl.setLastLoginIP(getLastLoginIP());
		userImpl.setLastFailedLoginDate(getLastFailedLoginDate());
		userImpl.setFailedLoginAttempts(getFailedLoginAttempts());
		userImpl.setLockout(isLockout());
		userImpl.setLockoutDate(getLockoutDate());
		userImpl.setAgreedToTermsOfUse(isAgreedToTermsOfUse());
		userImpl.setEmailAddressVerified(isEmailAddressVerified());
		userImpl.setStatus(getStatus());

		userImpl.resetOriginalValues();

		return userImpl;
	}

	@Override
	public User cloneWithOriginalValues() {
		UserImpl userImpl = new UserImpl();

		userImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		userImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		userImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		userImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		userImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		userImpl.setCompanyId(this.<Long>getColumnOriginalValue("companyId"));
		userImpl.setCreateDate(this.<Date>getColumnOriginalValue("createDate"));
		userImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		userImpl.setDefaultUser(
			this.<Boolean>getColumnOriginalValue("defaultUser"));
		userImpl.setContactId(this.<Long>getColumnOriginalValue("contactId"));
		userImpl.setPassword(this.<String>getColumnOriginalValue("password_"));
		userImpl.setPasswordEncrypted(
			this.<Boolean>getColumnOriginalValue("passwordEncrypted"));
		userImpl.setPasswordReset(
			this.<Boolean>getColumnOriginalValue("passwordReset"));
		userImpl.setPasswordModifiedDate(
			this.<Date>getColumnOriginalValue("passwordModifiedDate"));
		userImpl.setDigest(this.<String>getColumnOriginalValue("digest"));
		userImpl.setReminderQueryQuestion(
			this.<String>getColumnOriginalValue("reminderQueryQuestion"));
		userImpl.setReminderQueryAnswer(
			this.<String>getColumnOriginalValue("reminderQueryAnswer"));
		userImpl.setGraceLoginCount(
			this.<Integer>getColumnOriginalValue("graceLoginCount"));
		userImpl.setScreenName(
			this.<String>getColumnOriginalValue("screenName"));
		userImpl.setEmailAddress(
			this.<String>getColumnOriginalValue("emailAddress"));
		userImpl.setFacebookId(this.<Long>getColumnOriginalValue("facebookId"));
		userImpl.setGoogleUserId(
			this.<String>getColumnOriginalValue("googleUserId"));
		userImpl.setLdapServerId(
			this.<Long>getColumnOriginalValue("ldapServerId"));
		userImpl.setOpenId(this.<String>getColumnOriginalValue("openId"));
		userImpl.setPortraitId(this.<Long>getColumnOriginalValue("portraitId"));
		userImpl.setLanguageId(
			this.<String>getColumnOriginalValue("languageId"));
		userImpl.setTimeZoneId(
			this.<String>getColumnOriginalValue("timeZoneId"));
		userImpl.setGreeting(this.<String>getColumnOriginalValue("greeting"));
		userImpl.setComments(this.<String>getColumnOriginalValue("comments"));
		userImpl.setFirstName(this.<String>getColumnOriginalValue("firstName"));
		userImpl.setMiddleName(
			this.<String>getColumnOriginalValue("middleName"));
		userImpl.setLastName(this.<String>getColumnOriginalValue("lastName"));
		userImpl.setJobTitle(this.<String>getColumnOriginalValue("jobTitle"));
		userImpl.setLoginDate(this.<Date>getColumnOriginalValue("loginDate"));
		userImpl.setLoginIP(this.<String>getColumnOriginalValue("loginIP"));
		userImpl.setLastLoginDate(
			this.<Date>getColumnOriginalValue("lastLoginDate"));
		userImpl.setLastLoginIP(
			this.<String>getColumnOriginalValue("lastLoginIP"));
		userImpl.setLastFailedLoginDate(
			this.<Date>getColumnOriginalValue("lastFailedLoginDate"));
		userImpl.setFailedLoginAttempts(
			this.<Integer>getColumnOriginalValue("failedLoginAttempts"));
		userImpl.setLockout(this.<Boolean>getColumnOriginalValue("lockout"));
		userImpl.setLockoutDate(
			this.<Date>getColumnOriginalValue("lockoutDate"));
		userImpl.setAgreedToTermsOfUse(
			this.<Boolean>getColumnOriginalValue("agreedToTermsOfUse"));
		userImpl.setEmailAddressVerified(
			this.<Boolean>getColumnOriginalValue("emailAddressVerified"));
		userImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));

		return userImpl;
	}

	@Override
	public int compareTo(User user) {
		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof User)) {
			return false;
		}

		User user = (User)object;

		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<User> toCacheModel() {
		UserCacheModel userCacheModel = new UserCacheModel();

		userCacheModel.mvccVersion = getMvccVersion();

		userCacheModel.ctCollectionId = getCtCollectionId();

		userCacheModel.uuid = getUuid();

		String uuid = userCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			userCacheModel.uuid = null;
		}

		userCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode = userCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			userCacheModel.externalReferenceCode = null;
		}

		userCacheModel.userId = getUserId();

		userCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			userCacheModel.createDate = createDate.getTime();
		}
		else {
			userCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			userCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			userCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.defaultUser = isDefaultUser();

		userCacheModel.contactId = getContactId();

		userCacheModel.password = getPassword();

		String password = userCacheModel.password;

		if ((password != null) && (password.length() == 0)) {
			userCacheModel.password = null;
		}

		userCacheModel.passwordEncrypted = isPasswordEncrypted();

		userCacheModel.passwordReset = isPasswordReset();

		Date passwordModifiedDate = getPasswordModifiedDate();

		if (passwordModifiedDate != null) {
			userCacheModel.passwordModifiedDate =
				passwordModifiedDate.getTime();
		}
		else {
			userCacheModel.passwordModifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.digest = getDigest();

		String digest = userCacheModel.digest;

		if ((digest != null) && (digest.length() == 0)) {
			userCacheModel.digest = null;
		}

		userCacheModel.reminderQueryQuestion = getReminderQueryQuestion();

		String reminderQueryQuestion = userCacheModel.reminderQueryQuestion;

		if ((reminderQueryQuestion != null) &&
			(reminderQueryQuestion.length() == 0)) {

			userCacheModel.reminderQueryQuestion = null;
		}

		userCacheModel.reminderQueryAnswer = getReminderQueryAnswer();

		String reminderQueryAnswer = userCacheModel.reminderQueryAnswer;

		if ((reminderQueryAnswer != null) &&
			(reminderQueryAnswer.length() == 0)) {

			userCacheModel.reminderQueryAnswer = null;
		}

		userCacheModel.graceLoginCount = getGraceLoginCount();

		userCacheModel.screenName = getScreenName();

		String screenName = userCacheModel.screenName;

		if ((screenName != null) && (screenName.length() == 0)) {
			userCacheModel.screenName = null;
		}

		userCacheModel.emailAddress = getEmailAddress();

		String emailAddress = userCacheModel.emailAddress;

		if ((emailAddress != null) && (emailAddress.length() == 0)) {
			userCacheModel.emailAddress = null;
		}

		userCacheModel.facebookId = getFacebookId();

		userCacheModel.googleUserId = getGoogleUserId();

		String googleUserId = userCacheModel.googleUserId;

		if ((googleUserId != null) && (googleUserId.length() == 0)) {
			userCacheModel.googleUserId = null;
		}

		userCacheModel.ldapServerId = getLdapServerId();

		userCacheModel.openId = getOpenId();

		String openId = userCacheModel.openId;

		if ((openId != null) && (openId.length() == 0)) {
			userCacheModel.openId = null;
		}

		userCacheModel.portraitId = getPortraitId();

		userCacheModel.languageId = getLanguageId();

		String languageId = userCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			userCacheModel.languageId = null;
		}

		userCacheModel.timeZoneId = getTimeZoneId();

		String timeZoneId = userCacheModel.timeZoneId;

		if ((timeZoneId != null) && (timeZoneId.length() == 0)) {
			userCacheModel.timeZoneId = null;
		}

		userCacheModel.greeting = getGreeting();

		String greeting = userCacheModel.greeting;

		if ((greeting != null) && (greeting.length() == 0)) {
			userCacheModel.greeting = null;
		}

		userCacheModel.comments = getComments();

		String comments = userCacheModel.comments;

		if ((comments != null) && (comments.length() == 0)) {
			userCacheModel.comments = null;
		}

		userCacheModel.firstName = getFirstName();

		String firstName = userCacheModel.firstName;

		if ((firstName != null) && (firstName.length() == 0)) {
			userCacheModel.firstName = null;
		}

		userCacheModel.middleName = getMiddleName();

		String middleName = userCacheModel.middleName;

		if ((middleName != null) && (middleName.length() == 0)) {
			userCacheModel.middleName = null;
		}

		userCacheModel.lastName = getLastName();

		String lastName = userCacheModel.lastName;

		if ((lastName != null) && (lastName.length() == 0)) {
			userCacheModel.lastName = null;
		}

		userCacheModel.jobTitle = getJobTitle();

		String jobTitle = userCacheModel.jobTitle;

		if ((jobTitle != null) && (jobTitle.length() == 0)) {
			userCacheModel.jobTitle = null;
		}

		Date loginDate = getLoginDate();

		if (loginDate != null) {
			userCacheModel.loginDate = loginDate.getTime();
		}
		else {
			userCacheModel.loginDate = Long.MIN_VALUE;
		}

		userCacheModel.loginIP = getLoginIP();

		String loginIP = userCacheModel.loginIP;

		if ((loginIP != null) && (loginIP.length() == 0)) {
			userCacheModel.loginIP = null;
		}

		Date lastLoginDate = getLastLoginDate();

		if (lastLoginDate != null) {
			userCacheModel.lastLoginDate = lastLoginDate.getTime();
		}
		else {
			userCacheModel.lastLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.lastLoginIP = getLastLoginIP();

		String lastLoginIP = userCacheModel.lastLoginIP;

		if ((lastLoginIP != null) && (lastLoginIP.length() == 0)) {
			userCacheModel.lastLoginIP = null;
		}

		Date lastFailedLoginDate = getLastFailedLoginDate();

		if (lastFailedLoginDate != null) {
			userCacheModel.lastFailedLoginDate = lastFailedLoginDate.getTime();
		}
		else {
			userCacheModel.lastFailedLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.failedLoginAttempts = getFailedLoginAttempts();

		userCacheModel.lockout = isLockout();

		Date lockoutDate = getLockoutDate();

		if (lockoutDate != null) {
			userCacheModel.lockoutDate = lockoutDate.getTime();
		}
		else {
			userCacheModel.lockoutDate = Long.MIN_VALUE;
		}

		userCacheModel.agreedToTermsOfUse = isAgreedToTermsOfUse();

		userCacheModel.emailAddressVerified = isEmailAddressVerified();

		userCacheModel.status = getStatus();

		return userCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((User)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((User)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, User>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					User.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _userId;
	private long _companyId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _defaultUser;
	private long _contactId;
	private String _password;
	private boolean _passwordEncrypted;
	private boolean _passwordReset;
	private Date _passwordModifiedDate;
	private String _digest;
	private String _reminderQueryQuestion;
	private String _reminderQueryAnswer;
	private int _graceLoginCount;
	private String _screenName;
	private String _emailAddress;
	private long _facebookId;
	private String _googleUserId;
	private long _ldapServerId;
	private String _openId;
	private long _portraitId;
	private String _languageId;
	private String _timeZoneId;
	private String _greeting;
	private String _comments;
	private String _firstName;
	private String _middleName;
	private String _lastName;
	private String _jobTitle;
	private Date _loginDate;
	private String _loginIP;
	private Date _lastLoginDate;
	private String _lastLoginIP;
	private Date _lastFailedLoginDate;
	private int _failedLoginAttempts;
	private boolean _lockout;
	private Date _lockoutDate;
	private boolean _agreedToTermsOfUse;
	private boolean _emailAddressVerified;
	private int _status;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<User, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((User)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("defaultUser", _defaultUser);
		_columnOriginalValues.put("contactId", _contactId);
		_columnOriginalValues.put("password_", _password);
		_columnOriginalValues.put("passwordEncrypted", _passwordEncrypted);
		_columnOriginalValues.put("passwordReset", _passwordReset);
		_columnOriginalValues.put(
			"passwordModifiedDate", _passwordModifiedDate);
		_columnOriginalValues.put("digest", _digest);
		_columnOriginalValues.put(
			"reminderQueryQuestion", _reminderQueryQuestion);
		_columnOriginalValues.put("reminderQueryAnswer", _reminderQueryAnswer);
		_columnOriginalValues.put("graceLoginCount", _graceLoginCount);
		_columnOriginalValues.put("screenName", _screenName);
		_columnOriginalValues.put("emailAddress", _emailAddress);
		_columnOriginalValues.put("facebookId", _facebookId);
		_columnOriginalValues.put("googleUserId", _googleUserId);
		_columnOriginalValues.put("ldapServerId", _ldapServerId);
		_columnOriginalValues.put("openId", _openId);
		_columnOriginalValues.put("portraitId", _portraitId);
		_columnOriginalValues.put("languageId", _languageId);
		_columnOriginalValues.put("timeZoneId", _timeZoneId);
		_columnOriginalValues.put("greeting", _greeting);
		_columnOriginalValues.put("comments", _comments);
		_columnOriginalValues.put("firstName", _firstName);
		_columnOriginalValues.put("middleName", _middleName);
		_columnOriginalValues.put("lastName", _lastName);
		_columnOriginalValues.put("jobTitle", _jobTitle);
		_columnOriginalValues.put("loginDate", _loginDate);
		_columnOriginalValues.put("loginIP", _loginIP);
		_columnOriginalValues.put("lastLoginDate", _lastLoginDate);
		_columnOriginalValues.put("lastLoginIP", _lastLoginIP);
		_columnOriginalValues.put("lastFailedLoginDate", _lastFailedLoginDate);
		_columnOriginalValues.put("failedLoginAttempts", _failedLoginAttempts);
		_columnOriginalValues.put("lockout", _lockout);
		_columnOriginalValues.put("lockoutDate", _lockoutDate);
		_columnOriginalValues.put("agreedToTermsOfUse", _agreedToTermsOfUse);
		_columnOriginalValues.put(
			"emailAddressVerified", _emailAddressVerified);
		_columnOriginalValues.put("status", _status);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("password_", "password");
		attributeNames.put("groups_", "groups");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("defaultUser", 256L);

		columnBitmasks.put("contactId", 512L);

		columnBitmasks.put("password_", 1024L);

		columnBitmasks.put("passwordEncrypted", 2048L);

		columnBitmasks.put("passwordReset", 4096L);

		columnBitmasks.put("passwordModifiedDate", 8192L);

		columnBitmasks.put("digest", 16384L);

		columnBitmasks.put("reminderQueryQuestion", 32768L);

		columnBitmasks.put("reminderQueryAnswer", 65536L);

		columnBitmasks.put("graceLoginCount", 131072L);

		columnBitmasks.put("screenName", 262144L);

		columnBitmasks.put("emailAddress", 524288L);

		columnBitmasks.put("facebookId", 1048576L);

		columnBitmasks.put("googleUserId", 2097152L);

		columnBitmasks.put("ldapServerId", 4194304L);

		columnBitmasks.put("openId", 8388608L);

		columnBitmasks.put("portraitId", 16777216L);

		columnBitmasks.put("languageId", 33554432L);

		columnBitmasks.put("timeZoneId", 67108864L);

		columnBitmasks.put("greeting", 134217728L);

		columnBitmasks.put("comments", 268435456L);

		columnBitmasks.put("firstName", 536870912L);

		columnBitmasks.put("middleName", 1073741824L);

		columnBitmasks.put("lastName", 2147483648L);

		columnBitmasks.put("jobTitle", 4294967296L);

		columnBitmasks.put("loginDate", 8589934592L);

		columnBitmasks.put("loginIP", 17179869184L);

		columnBitmasks.put("lastLoginDate", 34359738368L);

		columnBitmasks.put("lastLoginIP", 68719476736L);

		columnBitmasks.put("lastFailedLoginDate", 137438953472L);

		columnBitmasks.put("failedLoginAttempts", 274877906944L);

		columnBitmasks.put("lockout", 549755813888L);

		columnBitmasks.put("lockoutDate", 1099511627776L);

		columnBitmasks.put("agreedToTermsOfUse", 2199023255552L);

		columnBitmasks.put("emailAddressVerified", 4398046511104L);

		columnBitmasks.put("status", 8796093022208L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private User _escapedModel;

}