/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.db.partition.DBPartitionUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;

public abstract class BaseDB
implements DB {
    protected static final String ALTER_COLUMN_NAME = "alter_column_name ";
    protected static final String ALTER_COLUMN_TYPE = "alter_column_type ";
    protected static final String ALTER_TABLE_NAME = "alter_table_name ";
    protected static final String CREATE_TABLE = "create table ";
    protected static final String DROP_INDEX = "drop index";
    protected static final String DROP_PRIMARY_KEY = "drop primary key";
    protected static final String[] RENAME_TABLE_TEMPLATE = new String[]{"@old-table@", "@new-table@"};
    protected static final String[] REWORD_TEMPLATE = new String[]{"@table@", "@old-column@", "@new-column@", "@type@", "@nullable@"};
    protected static final int[] SQL_VARCHAR_TYPES = new int[]{-16, -1, -9, 12};
    protected static final String[] TEMPLATE = new String[]{"##", "TRUE", "FALSE", "'01/01/1970'", "CURRENT_TIMESTAMP", " BLOB", " SBLOB", " BOOLEAN", " DATE", " DOUBLE", " INTEGER", " LONG", " STRING", " TEXT", " VARCHAR", " IDENTITY", "COMMIT_TRANSACTION"};
    protected static final Pattern columnTypePattern = Pattern.compile("(^\\w+)", 2);
    private static final boolean _SUPPORTS_ALTER_COLUMN_NAME = true;
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = true;
    private static final boolean _SUPPORTS_INLINE_DISTINCT = true;
    private static final boolean _SUPPORTS_QUERYING_AFTER_EXCEPTION = true;
    private static final boolean _SUPPORTS_SCROLLABLE_RESULTS = true;
    private static final boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN = true;
    private static final Log _log = LogFactoryUtil.getLog(BaseDB.class);
    private static final Pattern _columnLengthPattern = Pattern.compile("([^,(\\s]+)\\[\\$COLUMN_LENGTH:(\\d+)\\$\\]");
    private static final Pattern _templatePattern;
    private final DBType _dbType;
    private final int _majorVersion;
    private final int _minorVersion;
    private final Map<String, Integer> _sqlTypes = new HashMap<String, Integer>();
    private final Map<String, Integer> _sqlVarcharSizes = new HashMap<String, Integer>();
    private boolean _supportsStringCaseSensitiveQuery = true;
    private final Map<String, String> _templates = new HashMap<String, String>();

    public void addIndexes(Connection connection, List<IndexMetadata> indexMetadatas) throws IOException, SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        HashMap columnTableSizes = new HashMap();
        for (IndexMetadata indexMetadata : indexMetadatas) {
            String normalizedTabledName = dbInspector.normalizeName(indexMetadata.getTableName(), databaseMetaData);
            if (columnTableSizes.get(normalizedTabledName) == null) {
                try (ResultSet resultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), normalizedTabledName, null);){
                    HashMap<String, Integer> columnSizes = new HashMap<String, Integer>();
                    while (resultSet.next()) {
                        int columnType = resultSet.getInt("DATA_TYPE");
                        if (!ArrayUtil.contains((int[])SQL_VARCHAR_TYPES, (int)columnType)) continue;
                        columnSizes.put(dbInspector.normalizeName(resultSet.getString("COLUMN_NAME"), databaseMetaData), resultSet.getInt("COLUMN_SIZE"));
                    }
                    columnTableSizes.put(normalizedTabledName, columnSizes);
                }
            }
            String[] columnNames = indexMetadata.getColumnNames();
            int[] columnSizes = new int[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                columnSizes[i] = MapUtil.getInteger((Map)((Map)columnTableSizes.get(normalizedTabledName)), (String)columnNames[i], (int)0);
            }
            this.runSQL(this._applyMaxStringIndexLengthLimitation(indexMetadata.getCreateSQL(columnSizes)));
        }
    }

    public void alterColumnName(Connection connection, String tableName, String oldColumnName, String newColumnDefinition) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(ALTER_COLUMN_NAME);
        sb.append(tableName);
        sb.append(" ");
        sb.append(oldColumnName);
        sb.append(" ");
        sb.append(newColumnDefinition);
        this.runSQL(connection, sb.toString());
    }

    public void alterColumnType(Connection connection, String tableName, String columnName, String newColumnType) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(ALTER_COLUMN_TYPE);
        sb.append(tableName);
        sb.append(" ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(newColumnType);
        this.runSQL(connection, sb.toString());
    }

    public void alterTableAddColumn(Connection connection, String tableName, String columnName, String columnType) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" add ");
        sb.append(columnName);
        sb.append(" ");
        sb.append(columnType);
        this.runSQL(connection, sb.toString());
    }

    public void alterTableDropColumn(Connection connection, String tableName, String columnName) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" drop column ");
        sb.append(columnName);
        this.runSQL(connection, sb.toString());
    }

    public abstract String buildSQL(String var1) throws IOException, SQLException;

    public List<IndexMetadata> dropIndexes(Connection connection, String tableName, String columnName) throws IOException, SQLException {
        List<IndexMetadata> indexMetadatas = this.getIndexes(connection, tableName, columnName, false);
        for (IndexMetadata indexMetadata : indexMetadatas) {
            this.runSQL(connection, indexMetadata.getDropSQL());
        }
        return indexMetadatas;
    }

    public DBType getDBType() {
        return this._dbType;
    }

    public List<Index> getIndexes(Connection connection) throws SQLException {
        List<IndexMetadata> indexes = this.getIndexes(connection, null, null, false);
        Stream stream = indexes.stream();
        return stream.map(index -> new Index(index.getIndexName(), index.getTableName(), index.isUnique())).collect(Collectors.toList());
    }

    public ResultSet getIndexResultSet(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        return databaseMetaData.getIndexInfo(dbInspector.getCatalog(), dbInspector.getSchema(), tableName, false, false);
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public String[] getPrimaryKeyColumnNames(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        String normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        Object[] columnNames = new String[]{};
        try (ResultSet resultSet = databaseMetaData.getPrimaryKeys(dbInspector.getCatalog(), dbInspector.getSchema(), normalizedTableName);){
            while (resultSet.next()) {
                columnNames = (String[])ArrayUtil.append((Object[])columnNames, (Object)dbInspector.normalizeName(resultSet.getString("COLUMN_NAME"), databaseMetaData));
            }
        }
        return columnNames;
    }

    public Integer getSQLType(String templateType) {
        return this._sqlTypes.get(templateType);
    }

    public Integer getSQLVarcharSize(String templateType) {
        return this._sqlVarcharSizes.get(templateType);
    }

    public String getTemplateBlob() {
        return this.getTemplate()[5];
    }

    public String getTemplateFalse() {
        return this.getTemplate()[2];
    }

    public String getTemplateTrue() {
        return this.getTemplate()[1];
    }

    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion;
    }

    public boolean isSupportsAlterColumnName() {
        return true;
    }

    public boolean isSupportsAlterColumnType() {
        return true;
    }

    public boolean isSupportsInlineDistinct() {
        return true;
    }

    public boolean isSupportsQueryingAfterException() {
        return true;
    }

    public boolean isSupportsScrollableResults() {
        return true;
    }

    public boolean isSupportsStringCaseSensitiveQuery() {
        return this._supportsStringCaseSensitiveQuery;
    }

    public boolean isSupportsUpdateWithInnerJoin() {
        return true;
    }

    public void process(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        DBPartitionUtil.forEachCompanyId(unsafeConsumer);
    }

    public void removePrimaryKey(Connection connection, String tableName) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        String normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", normalizedTableName, " drop primary key"}));
    }

    public void runSQL(Connection connection, String sql) throws IOException, SQLException {
        this.runSQL(connection, new String[]{sql});
    }

    public void runSQL(Connection connection, String[] sqls) throws IOException, SQLException {
        try (Statement s = connection.createStatement();){
            for (String sql : sqls) {
                if (Validator.isNull((String)(sql = this.buildSQL(sql)))) continue;
                if ((sql = SQLTransformer.transform(sql.trim())).endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.endsWith("\ngo")) {
                    sql = sql.substring(0, sql.length() - 3);
                }
                if (sql.endsWith("\n/")) {
                    sql = sql.substring(0, sql.length() - 2);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)sql);
                }
                try {
                    s.executeUpdate(sql);
                }
                catch (SQLException sqlException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"SQL: ", sql, "\nSQL state: ", sqlException.getSQLState(), "\nVendor: ", this.getDBType(), "\nVendor error code: ", sqlException.getErrorCode(), "\nVendor error message: ", sqlException.getMessage()}));
                    }
                    throw sqlException;
                }
            }
        }
    }

    public void runSQL(String sql) throws IOException, SQLException {
        this.runSQL(new String[]{sql});
    }

    public void runSQL(String[] sqls) throws IOException, SQLException {
        try (Connection connection = DataAccess.getConnection();){
            this.runSQL(connection, sqls);
        }
    }

    public void runSQLTemplateString(Connection connection, String template, boolean failOnError) throws IOException, NamingException, SQLException {
        if ((template = StringUtil.trim((String)template)) == null || template.isEmpty()) {
            return;
        }
        if (!template.endsWith(";")) {
            template = template + ";";
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(template));){
            StringBundler sb = new StringBundler();
            String line = null;
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("##")) continue;
                if (line.startsWith("@include ")) {
                    int pos = line.indexOf(" ");
                    int end = line.length();
                    if (StringUtil.endsWith((String)line, (String)";")) {
                        --end;
                    }
                    String includeFileName = line.substring(pos + 1, end);
                    InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + includeFileName);
                    if (inputStream == null) {
                        inputStream = classLoader.getResourceAsStream(includeFileName);
                    }
                    String include = StringUtil.read((InputStream)inputStream);
                    include = this.replaceTemplate(include);
                    this.runSQLTemplateString(include, true);
                    continue;
                }
                sb.append(line);
                sb.append("\n");
                if (!line.endsWith(";")) continue;
                String sql = sb.toString();
                sb.setIndex(0);
                try {
                    if (!sql.equals("COMMIT_TRANSACTION;\n")) {
                        this.runSQL(connection, sql);
                        continue;
                    }
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Skip commit sql");
                }
                catch (IOException ioException) {
                    if (failOnError) {
                        throw ioException;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)ioException);
                }
                catch (SecurityException securityException) {
                    if (failOnError) {
                        throw securityException;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)securityException);
                }
                catch (SQLException sqlException) {
                    if (failOnError) {
                        throw sqlException;
                    }
                    String message = GetterUtil.getString((String)sqlException.getMessage());
                    if (!message.startsWith("Duplicate key name") && _log.isWarnEnabled()) {
                        _log.warn((Object)(message + ": " + this.buildSQL(sql)));
                    }
                    if (!message.startsWith("Duplicate entry") && !message.startsWith("Specified key was too long")) continue;
                    _log.error((Object)line);
                }
            }
        }
    }

    public void runSQLTemplateString(String template, boolean failOnError) throws IOException, NamingException, SQLException {
        try (Connection connection = DataAccess.getConnection();){
            this.runSQLTemplateString(connection, template, failOnError);
        }
    }

    public void setSupportsStringCaseSensitiveQuery(boolean supportsStringCaseSensitiveQuery) {
        if (_log.isDebugEnabled()) {
            if (supportsStringCaseSensitiveQuery) {
                _log.debug((Object)"Database supports case sensitive queries");
            } else {
                _log.debug((Object)"Database does not support case sensitive queries");
            }
        }
        this._supportsStringCaseSensitiveQuery = supportsStringCaseSensitiveQuery;
        SQLTransformer.reloadSQLTransformer();
    }

    public void updateIndexes(Connection connection, String tablesSQL, String indexesSQL, boolean dropIndexes) throws Exception {
        this.process((UnsafeConsumer<Long, Exception>)((UnsafeConsumer)companyId -> {
            if (Validator.isNotNull((Long)companyId) && _log.isInfoEnabled()) {
                _log.info((Object)("Updating database indexes for company " + companyId));
            }
            List<Index> indexes = this.getIndexes(connection);
            HashSet<String> validIndexNames = null;
            if (dropIndexes) {
                validIndexNames = this.dropIndexes(connection, tablesSQL, indexesSQL, indexes);
            } else {
                validIndexNames = new HashSet();
                for (Index index : indexes) {
                    String indexName = StringUtil.toUpperCase((String)index.getIndexName());
                    validIndexNames.add(indexName);
                }
            }
            this._addIndexes(connection, this._applyMaxStringIndexLengthLimitation(indexesSQL), validIndexNames);
        }));
    }

    protected BaseDB(DBType dbType, int majorVersion, int minorVersion) {
        this._dbType = dbType;
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        String[] actual = this.getTemplate();
        for (int i = 0; i < TEMPLATE.length; ++i) {
            this._templates.put(TEMPLATE[i], actual[i]);
        }
        String[] templateTypes = (String[])ArrayUtil.clone((Object[])TEMPLATE, (int)5, (int)15);
        for (int i = 0; i < templateTypes.length; ++i) {
            this._sqlTypes.put(StringUtil.trim((String)templateTypes[i]), this.getSQLTypes()[i]);
        }
        String[] sqlTypeStringAndText = (String[])ArrayUtil.clone((Object[])TEMPLATE, (int)12, (int)14);
        for (int i = 0; i < sqlTypeStringAndText.length; ++i) {
            this._sqlVarcharSizes.put(StringUtil.trim((String)sqlTypeStringAndText[i]), this.getSQLVarcharSizes()[i]);
        }
    }

    protected void addPrimaryKey(Connection connection, String tableName, String[] columnNames) throws IOException, SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        StringBundler sb = new StringBundler();
        sb.append("alter table ");
        sb.append(dbInspector.normalizeName(tableName, databaseMetaData));
        sb.append(" add primary key (");
        for (String columnName : columnNames) {
            sb.append(columnName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        this.runSQL(sb.toString());
    }

    protected String[] buildColumnNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        String nullable = "";
        if (words.length == 7) {
            nullable = "not null;";
        }
        return new String[]{words[1], words[2], words[3], words[4], nullable};
    }

    protected String[] buildColumnTypeTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        String nullable = "";
        if (words.length == 6) {
            nullable = "not null";
        } else if (words.length == 5) {
            nullable = "null";
        } else if (words.length == 4 && words[3].endsWith(";")) {
            words[3] = words[3].substring(0, words[3].length() - 1);
        }
        return new String[]{words[1], words[2], "", words[3], nullable};
    }

    protected String[] buildTableNameTokens(String line) {
        String[] words = StringUtil.split((String)line, (char)' ');
        return new String[]{words[1], words[2]};
    }

    protected Set<String> dropIndexes(Connection connection, String tablesSQL, String indexesSQL, List<Index> indexes) throws IOException, SQLException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Dropping stale indexes");
        }
        HashSet<String> validIndexNames = new HashSet<String>();
        if (indexes.isEmpty()) {
            return validIndexNames;
        }
        String tablesSQLLowerCase = StringUtil.toLowerCase((String)tablesSQL);
        String indexesSQLLowerCase = StringUtil.toLowerCase((String)indexesSQL);
        String[] lines = StringUtil.splitLines((String)indexesSQL);
        HashSet<String> indexNames = new HashSet<String>();
        for (String line : lines) {
            if (Validator.isNull((String)line)) continue;
            IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata((String)line);
            indexNames.add(StringUtil.toLowerCase((String)indexMetadata.getIndexName()));
        }
        for (Index index : indexes) {
            boolean unique;
            String indexNameUpperCase = StringUtil.toUpperCase((String)index.getIndexName());
            String indexNameLowerCase = StringUtil.toLowerCase((String)indexNameUpperCase);
            String tableName = index.getTableName();
            String tableNameLowerCase = StringUtil.toLowerCase((String)tableName);
            validIndexNames.add(indexNameUpperCase);
            if (indexNames.contains(indexNameLowerCase) ? (unique = index.isUnique()) && indexesSQLLowerCase.contains("create unique index " + indexNameLowerCase + " ") || !unique && indexesSQLLowerCase.contains("create index " + indexNameLowerCase + " ") : !tablesSQLLowerCase.contains(CREATE_TABLE + tableNameLowerCase + " (")) continue;
            validIndexNames.remove(indexNameUpperCase);
            String sql = StringBundler.concat((String[])new String[]{"drop index ", indexNameUpperCase, " on ", tableName});
            if (_log.isInfoEnabled()) {
                _log.info((Object)sql);
            }
            this.runSQL(connection, sql);
        }
        return validIndexNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IndexMetadata> getIndexes(Connection connection, String tableName, String columnName, boolean onlyUnique) throws SQLException {
        String normalizedColumnName;
        ArrayList<IndexMetadata> indexMetadatas = new ArrayList<IndexMetadata>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        DBInspector dbInspector = new DBInspector(connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        String normalizedTableName = tableName;
        if (normalizedTableName != null) {
            normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        }
        if ((normalizedColumnName = columnName) != null) {
            normalizedColumnName = dbInspector.normalizeName(columnName, databaseMetaData);
        }
        try (ResultSet tableResultSet = databaseMetaData.getTables(catalog, schema, normalizedTableName, new String[]{"TABLE"});){
            while (tableResultSet.next()) {
                ResultSet indexResultSet;
                block28: {
                    normalizedTableName = dbInspector.normalizeName(tableResultSet.getString("TABLE_NAME"), databaseMetaData);
                    indexResultSet = databaseMetaData.getIndexInfo(catalog, schema, normalizedTableName, onlyUnique, false);
                    Throwable throwable = null;
                    try {
                        boolean unique = false;
                        Object[] columnNames = new String[]{};
                        String previousIndexName = null;
                        while (indexResultSet.next()) {
                            String lowerCaseIndexName;
                            String indexName = indexResultSet.getString("INDEX_NAME");
                            if (indexName == null || !(lowerCaseIndexName = StringUtil.toLowerCase((String)indexName)).startsWith("liferay_") && !lowerCaseIndexName.startsWith("ix_")) continue;
                            if (previousIndexName != null && !previousIndexName.equals(indexName)) {
                                if (normalizedColumnName == null || ArrayUtil.contains((Object[])columnNames, (Object)normalizedColumnName)) {
                                    indexMetadatas.add(new IndexMetadata(previousIndexName, normalizedTableName, unique, (String[])columnNames));
                                }
                                columnNames = new String[]{};
                            }
                            previousIndexName = indexName;
                            unique = !indexResultSet.getBoolean("NON_UNIQUE");
                            columnNames = (String[])ArrayUtil.append((Object[])columnNames, (Object)dbInspector.normalizeName(indexResultSet.getString("COLUMN_NAME"), databaseMetaData));
                        }
                        if (previousIndexName != null && (normalizedColumnName == null || ArrayUtil.contains((Object[])columnNames, (Object)normalizedColumnName))) {
                            indexMetadatas.add(new IndexMetadata(previousIndexName, normalizedTableName, unique, (String[])columnNames));
                        }
                        if (indexResultSet == null) continue;
                        if (throwable == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (indexResultSet == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    indexResultSet.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            indexResultSet.close();
                            throw throwable3;
                        }
                    }
                    try {
                        indexResultSet.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                indexResultSet.close();
            }
            return new ArrayList<IndexMetadata>(indexMetadatas);
        }
    }

    protected abstract int[] getSQLTypes();

    protected int[] getSQLVarcharSizes() {
        return new int[]{-1, -1};
    }

    protected abstract String[] getTemplate();

    protected String limitColumnLength(String column, int length) {
        return StringBundler.concat((Object[])new Object[]{column, "\\(", length, "\\)"});
    }

    protected String replaceTemplate(String template) {
        if (Validator.isNull((String)template)) {
            return null;
        }
        StringBundler sb = null;
        int endIndex = 0;
        Matcher matcher = _templatePattern.matcher(template);
        while (matcher.find()) {
            int startIndex = matcher.start();
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(template.substring(endIndex, startIndex));
            endIndex = matcher.end();
            String matched = template.substring(startIndex, endIndex);
            sb.append(this._templates.get(matched));
        }
        if (sb == null) {
            return this._applyMaxStringIndexLengthLimitation(template);
        }
        if (template.length() > endIndex) {
            sb.append(template.substring(endIndex));
        }
        return this._applyMaxStringIndexLengthLimitation(sb.toString());
    }

    protected abstract String reword(String var1) throws IOException, SQLException;

    private void _addIndexes(Connection connection, String indexesSQL, Set<String> validIndexNames) throws IOException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding indexes");
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(indexesSQL));){
            String sql = null;
            while ((sql = unsyncBufferedReader.readLine()) != null) {
                int y;
                int x;
                String indexName;
                if (Validator.isNull((String)sql) || validIndexNames.contains(indexName = sql.substring((x = sql.lastIndexOf(" ", (y = sql.indexOf(" on ")) - 1)) + 1, y))) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)sql);
                }
                try {
                    this.runSQL(connection, sql);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)(exception.getMessage() + ": " + sql));
                }
            }
        }
    }

    private String _applyMaxStringIndexLengthLimitation(String template) {
        if (!template.contains("[$COLUMN_LENGTH:")) {
            return template;
        }
        DBType dbType = this.getDBType();
        int stringIndexMaxLength = GetterUtil.getInteger((String)PropsUtil.get((String)"database.string.index.max.length", (Filter)new Filter(dbType.getName())), (int)-1);
        Matcher matcher = _columnLengthPattern.matcher(template);
        if (stringIndexMaxLength < 0) {
            return matcher.replaceAll("$1");
        }
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int length = Integer.valueOf(matcher.group(2));
            if (length > stringIndexMaxLength) {
                matcher.appendReplacement(sb, this.limitColumnLength(matcher.group(1), stringIndexMaxLength));
                continue;
            }
            matcher.appendReplacement(sb, matcher.group(1));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        StringBundler sb = new StringBundler(TEMPLATE.length * 5 - 6);
        for (int i = 0; i < TEMPLATE.length; ++i) {
            String variable = TEMPLATE[i];
            if (variable.equals("##") || variable.equals("'01/01/1970'")) {
                sb.append(variable);
            } else {
                sb.append("(?<!\\[\\$)");
                sb.append(variable);
                sb.append("(?!\\$\\])");
                sb.append("\\b");
            }
            sb.append("|");
        }
        sb.setIndex(sb.index() - 1);
        _templatePattern = Pattern.compile(sb.toString());
    }
}

