/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.util.TextFormatter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterMethodImpl;

public class LiferayPropertyAccessor
implements PropertyAccessStrategy {
    public PropertyAccess buildPropertyAccess(Class containerJavaType, String propertyName) {
        return new LiferayPropertyAccess(this, containerJavaType, propertyName);
    }

    public static class LiferayPropertyAccess
    implements PropertyAccess {
        private static final Log _log = LogFactoryUtil.getLog(LiferayPropertyAccess.class);
        private static final Map<Class<?>, ModelMutators> _modelMutators = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
        private final Getter _getter;
        private final PropertyAccessStrategy _propertyAccessStrategy;
        private final Setter _setter;

        public LiferayPropertyAccess(PropertyAccessStrategy propertyAccessStrategy, Class<?> clazz, String propertyName) {
            this._propertyAccessStrategy = propertyAccessStrategy;
            this._getter = this._createGetter(clazz, propertyName);
            this._setter = this._createSetter(clazz, propertyName);
        }

        public Getter getGetter() {
            return this._getter;
        }

        public PropertyAccessStrategy getPropertyAccessStrategy() {
            return this._propertyAccessStrategy;
        }

        public Setter getSetter() {
            return this._setter;
        }

        protected String formatPropertyName(String propertyName) {
            return TextFormatter.format((String)propertyName, (int)6);
        }

        private Getter _createGetter(Class<?> clazz, String propertyName) throws PropertyNotFoundException {
            LiferayPropertyMutator liferayPropertyMutator = this._getLiferayPropertyMutator(clazz, propertyName);
            if (liferayPropertyMutator != null) {
                return liferayPropertyMutator;
            }
            String methodNameSuffix = this.formatPropertyName(propertyName);
            String getterMethodName = "get".concat(methodNameSuffix);
            try {
                Method getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
                return new LiferayPropertyGetter(getterMethod, propertyName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Getter not found for ", clazz.getName(), "#", propertyName}), (Throwable)noSuchMethodException);
                }
                Method getterMethod = ReflectHelper.findGetterMethod(clazz, (String)propertyName);
                return new GetterMethodImpl(clazz, propertyName, getterMethod);
            }
        }

        private Setter _createSetter(Class<?> clazz, String propertyName) throws PropertyNotFoundException {
            LiferayPropertyMutator liferayPropertyMutator = this._getLiferayPropertyMutator(clazz, propertyName);
            if (liferayPropertyMutator != null) {
                return liferayPropertyMutator;
            }
            String methodNameSuffix = this.formatPropertyName(propertyName);
            String getterMethodName = "get".concat(methodNameSuffix);
            String setterMethodName = "set".concat(methodNameSuffix);
            try {
                Method getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
                Method setterMethod = clazz.getMethod(setterMethodName, getterMethod.getReturnType());
                return new LiferayPropertySetter(setterMethod, propertyName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Setter not found for ", clazz.getName(), "#", propertyName}), (Throwable)noSuchMethodException);
                }
                Method getterMethod = ReflectHelper.findGetterMethod(clazz, (String)propertyName);
                Method setterMethod = ReflectHelper.findSetterMethod(clazz, (String)propertyName, getterMethod.getReturnType());
                return new SetterMethodImpl(clazz, propertyName, setterMethod);
            }
        }

        private LiferayPropertyMutator _getLiferayPropertyMutator(Class<?> clazz, String name) {
            ModelMutators modelMutators = _modelMutators.computeIfAbsent(clazz, modelClass -> {
                Map attributeSetterBiConsumers;
                Map attributeGetterFunctions;
                block4: {
                    if (!BaseModelImpl.class.isAssignableFrom((Class<?>)modelClass)) {
                        return new ModelMutators(null, null);
                    }
                    Class superClass = modelClass.getSuperclass();
                    while (BaseModelImpl.class != superClass) {
                        modelClass = superClass;
                        superClass = modelClass.getSuperclass();
                    }
                    attributeGetterFunctions = null;
                    attributeSetterBiConsumers = null;
                    try {
                        Field attributeGetterFunctionsField = modelClass.getDeclaredField("_attributeGetterFunctions");
                        attributeGetterFunctionsField.setAccessible(true);
                        attributeGetterFunctions = (Map)attributeGetterFunctionsField.get(null);
                        Field attributeSetterBiConsumersField = modelClass.getDeclaredField("_attributeSetterBiConsumers");
                        attributeSetterBiConsumersField.setAccessible(true);
                        attributeSetterBiConsumers = (Map)attributeSetterBiConsumersField.get(null);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        if (!_log.isDebugEnabled()) break block4;
                        _log.debug((Throwable)reflectiveOperationException);
                    }
                }
                return new ModelMutators(attributeGetterFunctions, attributeSetterBiConsumers);
            });
            Map attributeGetterFunctions = modelMutators._attributeGetterFunctions;
            Map attributeSetterBiConsumers = modelMutators._attributeSetterBiConsumers;
            if (attributeSetterBiConsumers == null) {
                return null;
            }
            Function getterFunction = (Function)attributeGetterFunctions.get(name);
            BiConsumer setterBiConsumer = (BiConsumer)attributeSetterBiConsumers.get(name);
            if (getterFunction == null || setterBiConsumer == null) {
                return null;
            }
            return new LiferayPropertyMutator(getterFunction, setterBiConsumer);
        }

        private static class ModelMutators {
            private final Map<String, Function<Object, Object>> _attributeGetterFunctions;
            private final Map<String, BiConsumer<Object, Object>> _attributeSetterBiConsumers;

            private ModelMutators(Map<String, Function<Object, Object>> attributeGetterFunctions, Map<String, BiConsumer<Object, Object>> attributeSetterBiConsumers) {
                this._attributeGetterFunctions = attributeGetterFunctions;
                this._attributeSetterBiConsumers = attributeSetterBiConsumers;
            }
        }

        private static class LiferayPropertySetter
        implements Setter {
            private final Method _method;
            private final String _propertyName;

            public Method getMethod() {
                return this._method;
            }

            public String getMethodName() {
                return this._method.getName();
            }

            public void set(Object target, Object value, SessionFactoryImplementor sessionFactoryImplementor) throws PropertyAccessException {
                try {
                    this._method.invoke(target, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exception) {
                    throw new PropertyAccessException((Throwable)exception, exception.getMessage(), true, this._method.getDeclaringClass(), this._propertyName);
                }
            }

            private LiferayPropertySetter(Method method, String propertyName) {
                this._method = method;
                this._propertyName = propertyName;
            }
        }

        private static class LiferayPropertyMutator
        implements Getter,
        Setter {
            private final Function<Object, Object> _getterFunction;
            private final BiConsumer<Object, Object> _setterBiConsumer;

            public Object get(Object target) {
                return this._getterFunction.apply(target);
            }

            public Object getForInsert(Object target, Map mergeMap, SharedSessionContractImplementor sharedSessionContractImplementor) {
                return this._getterFunction.apply(target);
            }

            public Member getMember() {
                return null;
            }

            public Method getMethod() {
                return null;
            }

            public String getMethodName() {
                return null;
            }

            public Class getReturnType() {
                return null;
            }

            public void set(Object target, Object value, SessionFactoryImplementor factory) {
                this._setterBiConsumer.accept(target, value);
            }

            private LiferayPropertyMutator(Function<Object, Object> getterFunction, BiConsumer<Object, Object> setterBiConsumer) {
                this._getterFunction = getterFunction;
                this._setterBiConsumer = setterBiConsumer;
            }
        }

        private static class LiferayPropertyGetter
        implements Getter {
            private final Method _method;
            private final String _propertyName;

            public Object get(Object target) throws PropertyAccessException {
                try {
                    return this._method.invoke(target, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    throw new PropertyAccessException((Throwable)exception, exception.getMessage(), false, this._method.getDeclaringClass(), this._propertyName);
                }
            }

            public Object getForInsert(Object target, Map mergeMap, SharedSessionContractImplementor sharedSessionContractImplementor) throws PropertyAccessException {
                return this.get(target);
            }

            public Member getMember() {
                return this._method;
            }

            public Method getMethod() {
                return this._method;
            }

            public String getMethodName() {
                return this._method.getName();
            }

            public Class getReturnType() {
                return this._method.getReturnType();
            }

            private LiferayPropertyGetter(Method method, String propertyName) {
                this._method = method;
                this._propertyName = propertyName;
            }
        }
    }
}

