/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.MVCPortletAutoDeployer;
import com.liferay.portal.deploy.auto.PluginAutoDeployListenerHelper;
import com.liferay.portal.deploy.auto.PortletAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class PortletAutoDeployListener
extends BaseAutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(PortletAutoDeployListener.class);
    private boolean _mvcDeployer;

    protected AutoDeployer buildAutoDeployer() throws AutoDeployException {
        PortletAutoDeployer autoDeployer = new PortletAutoDeployer();
        if (this._mvcDeployer) {
            autoDeployer = new MVCPortletAutoDeployer();
        }
        if (_log.isDebugEnabled()) {
            Class<?> clazz = autoDeployer.getClass();
            _log.debug((Object)("Using deployer " + clazz.getName()));
        }
        return autoDeployer;
    }

    protected String getPluginPathInfoMessage(File file) {
        return "Copying portlets for " + file.getPath();
    }

    protected String getSuccessMessage(File file) {
        return "Portlets for " + file.getPath() + " copied successfully";
    }

    protected boolean isDeployable(File file) throws AutoDeployException {
        PluginAutoDeployListenerHelper pluginAutoDeployListenerHelper = new PluginAutoDeployListenerHelper(file);
        if (pluginAutoDeployListenerHelper.isPortletPlugin()) {
            return true;
        }
        if (pluginAutoDeployListenerHelper.isMatchingFile("index_mvc.jsp")) {
            this._mvcDeployer = true;
            return true;
        }
        String fileName = file.getName();
        return !pluginAutoDeployListenerHelper.isHookPlugin() && !pluginAutoDeployListenerHelper.isMatchingFile("WEB-INF/liferay-layout-templates.xml") && !pluginAutoDeployListenerHelper.isThemePlugin() && !pluginAutoDeployListenerHelper.isWebPlugin() && fileName.endsWith(".war");
    }
}

