/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        Object[] extJarFiles;
        Path libPath;
        Path extPath;
        File extDir;
        if (ServerDetector.isTomcat() && (extDir = (extPath = (libPath = Paths.get(System.getProperty("catalina.base"), "lib")).resolve("ext")).toFile()).exists() && (extJarFiles = extDir.listFiles()).length != 0) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Files ", Arrays.toString(extJarFiles), " in ", extDir, " are no longer read. Move them to ", libPath, " or ", PropsValues.LIFERAY_SHIELDED_CONTAINER_LIB_PORTAL_DIR, "."}));
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        extJarFiles = null;
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/events/dependencies/startup.txt");){
            System.out.println(StreamUtil.toString((InputStream)inputStream));
        }
        catch (Throwable object) {
            extJarFiles = object;
            throw object;
        }
        System.out.println("Starting " + ReleaseInfo.getReleaseInfo() + "\n");
        StartupHelperUtil.printPatchLevel();
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MYSQL && GetterUtil.getFloat((String)db.getVersionString()) < 5.6f) {
            _log.error((Object)"Please upgrade to at least MySQL 5.6.4. The portal no longer supports older versions of MySQL.");
            System.exit(1);
        }
        StartupHelperUtil.verifyRequiredSchemaVersion();
        DBUpgrader.checkReleaseState();
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        final ServiceRegistration moduleServiceLifecycleServiceRegistration = bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)"database.initialized").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            protected void doPortalInit() {
            }
        }, (int)1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        StartupHelperUtil.initResourceActions();
        if (StartupHelperUtil.isDBNew()) {
            DBUpgrader.verify();
            DLFileEntryTypeLocalServiceUtil.getBasicDocumentDLFileEntryType();
        }
        if (PropsValues.DATABASE_INDEXES_UPDATE_ON_STARTUP) {
            StartupHelperUtil.updateIndexes(true);
        }
    }
}

