/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.osgi.framework.BundleContext;

public class Log4jLogContextLogWrapper
extends LogWrapper {
    private static volatile ServiceTrackerList<LogContext> _serviceTrackerList;

    public Log4jLogContextLogWrapper(Log log) {
        super(log);
        this.setLogWrapperClassName(Log4jLogContextLogWrapper.class.getName());
    }

    public void debug(Object message) {
        this._populateThreadContext();
        super.debug(message);
        this._cleanThreadContext();
    }

    public void debug(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.debug(message, throwable);
        this._cleanThreadContext();
    }

    public void debug(Throwable throwable) {
        this._populateThreadContext();
        super.debug(null, throwable);
        this._cleanThreadContext();
    }

    public void error(Object message) {
        this._populateThreadContext();
        super.error(message);
        this._cleanThreadContext();
    }

    public void error(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.error(message, throwable);
        this._cleanThreadContext();
    }

    public void error(Throwable throwable) {
        this._populateThreadContext();
        super.error(null, throwable);
        this._cleanThreadContext();
    }

    public void fatal(Object message) {
        this._populateThreadContext();
        super.fatal(message);
        this._cleanThreadContext();
    }

    public void fatal(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.fatal(message, throwable);
        this._cleanThreadContext();
    }

    public void fatal(Throwable throwable) {
        this._populateThreadContext();
        super.fatal(null, throwable);
        this._cleanThreadContext();
    }

    public void info(Object message) {
        this._populateThreadContext();
        super.info(message);
        this._cleanThreadContext();
    }

    public void info(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.info(message, throwable);
        this._cleanThreadContext();
    }

    public void info(Throwable throwable) {
        this._populateThreadContext();
        super.info(null, throwable);
        this._cleanThreadContext();
    }

    public void trace(Object message) {
        this._populateThreadContext();
        super.trace(message);
        this._cleanThreadContext();
    }

    public void trace(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.trace(message, throwable);
        this._cleanThreadContext();
    }

    public void trace(Throwable throwable) {
        this._populateThreadContext();
        super.trace(null, throwable);
        this._cleanThreadContext();
    }

    public void warn(Object message) {
        this._populateThreadContext();
        super.warn(message);
        this._cleanThreadContext();
    }

    public void warn(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.warn(message, throwable);
        this._cleanThreadContext();
    }

    public void warn(Throwable throwable) {
        this._populateThreadContext();
        super.warn(null, throwable);
        this._cleanThreadContext();
    }

    private void _cleanThreadContext() {
        ThreadContext.clearMap();
    }

    private void _populateThreadContext() {
        ServiceTrackerList<LogContext> serviceTrackerList = _serviceTrackerList;
        if (serviceTrackerList == null) {
            return;
        }
        for (LogContext logContext : serviceTrackerList) {
            Map context = logContext.getContext();
            for (Map.Entry entry : context.entrySet()) {
                ThreadContext.put((String)(logContext.getName() + "." + (String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
    }

    static {
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                ServiceTrackerList serviceTrackerList = _serviceTrackerList;
                _serviceTrackerList = null;
                if (serviceTrackerList != null) {
                    serviceTrackerList.close();
                }
            }

            protected void doPortalInit() {
                _serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), LogContext.class);
            }
        }, (int)0);
    }
}

