/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.impl.LayoutSetPrototypeBaseImpl;
import java.io.IOException;

public class LayoutSetPrototypeImpl
extends LayoutSetPrototypeBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeImpl.class);
    private UnicodeProperties _settingsUnicodeProperties;

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getLayoutSetPrototypeGroup((long)this.getCompanyId(), (long)this.getLayoutSetPrototypeId());
    }

    public long getGroupId() throws PortalException {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public LayoutSet getLayoutSet() throws PortalException {
        return LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroup().getGroupId(), (boolean)true);
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsUnicodeProperties == null) {
            this._settingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._settingsUnicodeProperties.load(super.getSettings());
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return this._settingsUnicodeProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsUnicodeProperties = this.getSettingsProperties();
        return settingsUnicodeProperties.getProperty(key);
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    @Override
    public void setSettings(String settings) {
        this._settingsUnicodeProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsUnicodeProperties) {
        this._settingsUnicodeProperties = settingsUnicodeProperties;
        super.setSettings(settingsUnicodeProperties.toString());
    }
}

