/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.model.VirtualHostTable;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.service.persistence.VirtualHostUtil;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelperUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.VirtualHostImpl;
import com.liferay.portal.model.impl.VirtualHostModelImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VirtualHostPersistenceImpl
extends BasePersistenceImpl<VirtualHost>
implements VirtualHostPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = VirtualHostImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "virtualHost.companyId = ?";
    private FinderPath _finderPathFetchByHostname;
    private FinderPath _finderPathCountByHostname;
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_2 = "virtualHost.hostname = ?";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_3 = "(virtualHost.hostname IS NULL OR virtualHost.hostname = '')";
    private FinderPath _finderPathWithPaginationFindByC_L;
    private FinderPath _finderPathWithoutPaginationFindByC_L;
    private FinderPath _finderPathCountByC_L;
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "virtualHost.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETID_2 = "virtualHost.layoutSetId = ?";
    private FinderPath _finderPathFetchByC_L_D;
    private FinderPath _finderPathCountByC_L_D;
    private static final String _FINDER_COLUMN_C_L_D_COMPANYID_2 = "virtualHost.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_D_LAYOUTSETID_2 = "virtualHost.layoutSetId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_D_DEFAULTVIRTUALHOST_2 = "virtualHost.defaultVirtualHost = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private static final String _SQL_SELECT_VIRTUALHOST = "SELECT virtualHost FROM VirtualHost virtualHost";
    private static final String _SQL_SELECT_VIRTUALHOST_WHERE = "SELECT virtualHost FROM VirtualHost virtualHost WHERE ";
    private static final String _SQL_COUNT_VIRTUALHOST = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost";
    private static final String _SQL_COUNT_VIRTUALHOST_WHERE = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "virtualHost.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VirtualHost exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No VirtualHost exists with the key {";
    private static final Log _log;

    public List<VirtualHost> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<VirtualHost> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<VirtualHost> findByCompanyId(long companyId, int start, int end, OrderByComparator<VirtualHost> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<VirtualHost> findByCompanyId(long companyId, int start, int end, OrderByComparator<VirtualHost> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (VirtualHost virtualHost : list) {
                if (companyId == virtualHost.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY virtualHost.virtualHostId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public VirtualHost findByCompanyId_First(long companyId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (virtualHost != null) {
            return virtualHost;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchVirtualHostException(sb.toString());
    }

    public VirtualHost fetchByCompanyId_First(long companyId, OrderByComparator<VirtualHost> orderByComparator) {
        List<VirtualHost> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public VirtualHost findByCompanyId_Last(long companyId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (virtualHost != null) {
            return virtualHost;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchVirtualHostException(sb.toString());
    }

    public VirtualHost fetchByCompanyId_Last(long companyId, OrderByComparator<VirtualHost> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<VirtualHost> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public VirtualHost[] findByCompanyId_PrevAndNext(long virtualHostId, long companyId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByPrimaryKey(virtualHostId);
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost[] array = new VirtualHostImpl[]{this.getByCompanyId_PrevAndNext(session, virtualHost, companyId, orderByComparator, true), virtualHost, this.getByCompanyId_PrevAndNext(session, virtualHost, companyId, orderByComparator, false)};
            VirtualHost[] virtualHostArray = array;
            return virtualHostArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected VirtualHost getByCompanyId_PrevAndNext(Session session, VirtualHost virtualHost, long companyId, OrderByComparator<VirtualHost> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY virtualHost.virtualHostId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)virtualHost)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (VirtualHost)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (VirtualHost virtualHost : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)virtualHost);
        }
    }

    public int countByCompanyId(long companyId) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByCompanyId;
            finderArgs = new Object[]{companyId};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHost findByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByHostname(hostname);
        if (virtualHost == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("hostname=");
            sb.append(hostname);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchVirtualHostException(sb.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByHostname(String hostname) {
        return this.fetchByHostname(hostname, true);
    }

    public VirtualHost fetchByHostname(String hostname, boolean useFinderCache) {
        VirtualHost virtualHost;
        hostname = Objects.toString(hostname, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{hostname};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByHostname, (Object[])finderArgs);
        }
        if (result instanceof VirtualHost && !Objects.equals(hostname, (virtualHost = (VirtualHost)result).getHostname())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname.isEmpty()) {
                sb.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                sb.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindHostname) {
                    queryPos.add(hostname);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache && productionMode) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByHostname, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByHostname(hostname);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByHostname(String hostname) {
        hostname = Objects.toString(hostname, "");
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByHostname;
            finderArgs = new Object[]{hostname};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname.isEmpty()) {
                sb.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                sb.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindHostname) {
                    queryPos.add(hostname);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<VirtualHost> findByC_L(long companyId, long layoutSetId) {
        return this.findByC_L(companyId, layoutSetId, -1, -1, null);
    }

    public List<VirtualHost> findByC_L(long companyId, long layoutSetId, int start, int end) {
        return this.findByC_L(companyId, layoutSetId, start, end, null);
    }

    public List<VirtualHost> findByC_L(long companyId, long layoutSetId, int start, int end, OrderByComparator<VirtualHost> orderByComparator) {
        return this.findByC_L(companyId, layoutSetId, start, end, orderByComparator, true);
    }

    public List<VirtualHost> findByC_L(long companyId, long layoutSetId, int start, int end, OrderByComparator<VirtualHost> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByC_L;
                finderArgs = new Object[]{companyId, layoutSetId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByC_L;
            finderArgs = new Object[]{companyId, layoutSetId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (VirtualHost virtualHost : list) {
                if (companyId == virtualHost.getCompanyId() && layoutSetId == virtualHost.getLayoutSetId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            sb.append("virtualHost.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY virtualHost.virtualHostId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(layoutSetId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public VirtualHost findByC_L_First(long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByC_L_First(companyId, layoutSetId, orderByComparator);
        if (virtualHost != null) {
            return virtualHost;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", layoutSetId=");
        sb.append(layoutSetId);
        sb.append("}");
        throw new NoSuchVirtualHostException(sb.toString());
    }

    public VirtualHost fetchByC_L_First(long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator) {
        List<VirtualHost> list = this.findByC_L(companyId, layoutSetId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public VirtualHost findByC_L_Last(long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByC_L_Last(companyId, layoutSetId, orderByComparator);
        if (virtualHost != null) {
            return virtualHost;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", layoutSetId=");
        sb.append(layoutSetId);
        sb.append("}");
        throw new NoSuchVirtualHostException(sb.toString());
    }

    public VirtualHost fetchByC_L_Last(long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator) {
        int count = this.countByC_L(companyId, layoutSetId);
        if (count == 0) {
            return null;
        }
        List<VirtualHost> list = this.findByC_L(companyId, layoutSetId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public VirtualHost[] findByC_L_PrevAndNext(long virtualHostId, long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByPrimaryKey(virtualHostId);
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost[] array = new VirtualHostImpl[]{this.getByC_L_PrevAndNext(session, virtualHost, companyId, layoutSetId, orderByComparator, true), virtualHost, this.getByC_L_PrevAndNext(session, virtualHost, companyId, layoutSetId, orderByComparator, false)};
            VirtualHost[] virtualHostArray = array;
            return virtualHostArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected VirtualHost getByC_L_PrevAndNext(Session session, VirtualHost virtualHost, long companyId, long layoutSetId, OrderByComparator<VirtualHost> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
        sb.append("virtualHost.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY virtualHost.virtualHostId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(layoutSetId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)virtualHost)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (VirtualHost)list.get(1);
        }
        return null;
    }

    public void removeByC_L(long companyId, long layoutSetId) {
        for (VirtualHost virtualHost : this.findByC_L(companyId, layoutSetId, -1, -1, null)) {
            this.remove((BaseModel)virtualHost);
        }
    }

    public int countByC_L(long companyId, long layoutSetId) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_L;
            finderArgs = new Object[]{companyId, layoutSetId};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            sb.append("virtualHost.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(layoutSetId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHost findByC_L_D(long companyId, long layoutSetId, boolean defaultVirtualHost) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByC_L_D(companyId, layoutSetId, defaultVirtualHost);
        if (virtualHost == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", layoutSetId=");
            sb.append(layoutSetId);
            sb.append(", defaultVirtualHost=");
            sb.append(defaultVirtualHost);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchVirtualHostException(sb.toString());
        }
        return virtualHost;
    }

    public VirtualHost fetchByC_L_D(long companyId, long layoutSetId, boolean defaultVirtualHost) {
        return this.fetchByC_L_D(companyId, layoutSetId, defaultVirtualHost, true);
    }

    public VirtualHost fetchByC_L_D(long companyId, long layoutSetId, boolean defaultVirtualHost, boolean useFinderCache) {
        VirtualHost virtualHost;
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{companyId, layoutSetId, defaultVirtualHost};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByC_L_D, finderArgs);
        }
        if (result instanceof VirtualHost && (companyId != (virtualHost = (VirtualHost)result).getCompanyId() || layoutSetId != virtualHost.getLayoutSetId() || defaultVirtualHost != virtualHost.isDefaultVirtualHost())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            sb.append("virtualHost.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_L_D_LAYOUTSETID_2);
            sb.append(_FINDER_COLUMN_C_L_D_DEFAULTVIRTUALHOST_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(layoutSetId);
                queryPos.add(defaultVirtualHost);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_L_D, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!productionMode || !useFinderCache) {
                                finderArgs = new Object[]{companyId, layoutSetId, defaultVirtualHost};
                            }
                            _log.warn((Object)("VirtualHostPersistenceImpl.fetchByC_L_D(long, long, boolean, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    public VirtualHost removeByC_L_D(long companyId, long layoutSetId, boolean defaultVirtualHost) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByC_L_D(companyId, layoutSetId, defaultVirtualHost);
        return (VirtualHost)this.remove((BaseModel)virtualHost);
    }

    public int countByC_L_D(long companyId, long layoutSetId, boolean defaultVirtualHost) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_L_D;
            finderArgs = new Object[]{companyId, layoutSetId, defaultVirtualHost};
            count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            sb.append("virtualHost.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_L_D_LAYOUTSETID_2);
            sb.append(_FINDER_COLUMN_C_L_D_DEFAULTVIRTUALHOST_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(layoutSetId);
                queryPos.add(defaultVirtualHost);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHostPersistenceImpl() {
        this.setModelClass(VirtualHost.class);
        this.setModelImplClass(VirtualHostImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)VirtualHostTable.INSTANCE);
    }

    public void cacheResult(VirtualHost virtualHost) {
        if (virtualHost.getCtCollectionId() != 0L) {
            return;
        }
        EntityCacheUtil.putResult(VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey()), (Serializable)virtualHost);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByHostname, (Object[])new Object[]{virtualHost.getHostname()}, (Object)virtualHost);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_L_D, (Object[])new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId(), virtualHost.isDefaultVirtualHost()}, (Object)virtualHost);
    }

    public void cacheResult(List<VirtualHost> virtualHosts) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && virtualHosts.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (VirtualHost virtualHost : virtualHosts) {
            if (virtualHost.getCtCollectionId() != 0L || EntityCacheUtil.getResult(VirtualHostImpl.class, (Serializable)Long.valueOf(virtualHost.getPrimaryKey())) != null) continue;
            this.cacheResult(virtualHost);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(VirtualHostImpl.class);
        FinderCacheUtil.clearCache(VirtualHostImpl.class);
    }

    public void clearCache(VirtualHost virtualHost) {
        EntityCacheUtil.removeResult(VirtualHostImpl.class, (BaseModel)virtualHost);
    }

    public void clearCache(List<VirtualHost> virtualHosts) {
        for (VirtualHost virtualHost : virtualHosts) {
            EntityCacheUtil.removeResult(VirtualHostImpl.class, (BaseModel)virtualHost);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(VirtualHostImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(VirtualHostImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(VirtualHostModelImpl virtualHostModelImpl) {
        Object[] args = new Object[]{virtualHostModelImpl.getHostname()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByHostname, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByHostname, (Object[])args, (Object)((Object)virtualHostModelImpl));
        args = new Object[]{virtualHostModelImpl.getCompanyId(), virtualHostModelImpl.getLayoutSetId(), virtualHostModelImpl.isDefaultVirtualHost()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathCountByC_L_D, (Object[])args, (Object)1L);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_L_D, (Object[])args, (Object)((Object)virtualHostModelImpl));
    }

    public VirtualHost create(long virtualHostId) {
        VirtualHostImpl virtualHost = new VirtualHostImpl();
        virtualHost.setNew(true);
        virtualHost.setPrimaryKey(virtualHostId);
        virtualHost.setCompanyId(CompanyThreadLocal.getCompanyId());
        return virtualHost;
    }

    public VirtualHost remove(long virtualHostId) throws NoSuchVirtualHostException {
        return this.remove(Long.valueOf(virtualHostId));
    }

    public VirtualHost remove(Serializable primaryKey) throws NoSuchVirtualHostException {
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
            if (virtualHost == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            VirtualHost virtualHost2 = (VirtualHost)this.remove((BaseModel)virtualHost);
            return virtualHost2;
        }
        catch (NoSuchVirtualHostException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected VirtualHost removeImpl(VirtualHost virtualHost) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)virtualHost)) {
                virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, virtualHost.getPrimaryKeyObj());
            }
            if (virtualHost != null && CTPersistenceHelperUtil.isRemove((CTModel)virtualHost)) {
                session.delete((Object)virtualHost);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (virtualHost != null) {
            this.clearCache(virtualHost);
        }
        return virtualHost;
    }

    public VirtualHost updateImpl(VirtualHost virtualHost) {
        boolean isNew = virtualHost.isNew();
        if (!(virtualHost instanceof VirtualHostModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(virtualHost.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)virtualHost);
                throw new IllegalArgumentException("Implement ModelWrapper in virtualHost proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom VirtualHost implementation " + virtualHost.getClass());
        }
        VirtualHostModelImpl virtualHostModelImpl = (VirtualHostModelImpl)virtualHost;
        Session session = null;
        try {
            session = this.openSession();
            if (CTPersistenceHelperUtil.isInsert((CTModel)virtualHost)) {
                if (!isNew) {
                    session.evict(VirtualHostImpl.class, virtualHost.getPrimaryKeyObj());
                }
                session.save((Object)virtualHost);
            } else {
                virtualHost = (VirtualHost)session.merge((Object)virtualHost);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (virtualHost.getCtCollectionId() != 0L) {
            if (isNew) {
                virtualHost.setNew(false);
            }
            virtualHost.resetOriginalValues();
            return virtualHost;
        }
        EntityCacheUtil.putResult(VirtualHostImpl.class, (BaseModel)virtualHostModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(virtualHostModelImpl);
        if (isNew) {
            virtualHost.setNew(false);
        }
        virtualHost.resetOriginalValues();
        return virtualHost;
    }

    public VirtualHost findByPrimaryKey(Serializable primaryKey) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByPrimaryKey(primaryKey);
        if (virtualHost == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return virtualHost;
    }

    public VirtualHost findByPrimaryKey(long virtualHostId) throws NoSuchVirtualHostException {
        return this.findByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public VirtualHost fetchByPrimaryKey(Serializable primaryKey) {
        if (CTPersistenceHelperUtil.isProductionMode(VirtualHost.class, (Serializable)primaryKey)) {
            return (VirtualHost)super.fetchByPrimaryKey(primaryKey);
        }
        VirtualHost virtualHost = null;
        Session session = null;
        try {
            session = this.openSession();
            virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
            if (virtualHost != null) {
                this.cacheResult(virtualHost);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return virtualHost;
    }

    public VirtualHost fetchByPrimaryKey(long virtualHostId) {
        return this.fetchByPrimaryKey(Long.valueOf(virtualHostId));
    }

    public Map<Serializable, VirtualHost> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (CTPersistenceHelperUtil.isProductionMode(VirtualHost.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, VirtualHost> map = new HashMap<Serializable, VirtualHost>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            VirtualHost virtualHost = this.fetchByPrimaryKey(primaryKey);
            if (virtualHost != null) {
                map.put(primaryKey, virtualHost);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (VirtualHost virtualHost : query.list()) {
                map.put(virtualHost.getPrimaryKeyObj(), virtualHost);
                this.cacheResult(virtualHost);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<VirtualHost> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<VirtualHost> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator, boolean useFinderCache) {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_VIRTUALHOST);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_VIRTUALHOST;
                sql = sql.concat(" ORDER BY virtualHost.virtualHostId DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (VirtualHost virtualHost : this.findAll()) {
            this.remove((BaseModel)virtualHost);
        }
    }

    public int countAll() {
        boolean productionMode = CTPersistenceHelperUtil.isProductionMode(VirtualHost.class);
        Long count = null;
        if (productionMode) {
            count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_VIRTUALHOST);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "virtualHostId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_VIRTUALHOST;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return VirtualHostModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "VirtualHost";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByHostname = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByHostname", new String[]{String.class.getName()}, new String[]{"hostname"}, true);
        this._finderPathCountByHostname = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByHostname", new String[]{String.class.getName()}, new String[]{"hostname"}, false);
        this._finderPathWithPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_L", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "layoutSetId"}, true);
        this._finderPathWithoutPaginationFindByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_L", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "layoutSetId"}, true);
        this._finderPathCountByC_L = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "layoutSetId"}, false);
        this._finderPathFetchByC_L_D = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_L_D", new String[]{Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "layoutSetId", "defaultVirtualHost"}, true);
        this._finderPathCountByC_L_D = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L_D", new String[]{Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "layoutSetId", "defaultVirtualHost"}, false);
        this._setVirtualHostUtilPersistence(this);
    }

    public void destroy() {
        this._setVirtualHostUtilPersistence(null);
        EntityCacheUtil.removeCache((String)VirtualHostImpl.class.getName());
    }

    private void _setVirtualHostUtilPersistence(VirtualHostPersistence virtualHostPersistence) {
        try {
            Field field = VirtualHostUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, virtualHostPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("layoutSetId");
        ctStrictColumnNames.add("hostname");
        ctStrictColumnNames.add("defaultVirtualHost");
        ctStrictColumnNames.add("languageId");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("virtualHostId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"hostname"});
        _log = LogFactoryUtil.getLog(VirtualHostPersistenceImpl.class);
    }
}

