/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang.time.StopWatch;

public class SetupWizardSampleDataUtil {
    private static final Object[][] _ORGANIZATION_ARRAYS = new Object[][]{{"Chicago", "USA", "IL", "organization", "ORD"}, {"Consulting", "USA", "CA", "organization"}, {"Dalian", "CHN", null, "organization", "DLC"}, {"Engineering", "USA", "CA", "organization"}, {"Frankfurt", "DEU", null, "organization", "FRA"}, {"Hong Kong", "CHN", null, "organization", "HKG"}, {"Kuala Lumpur", "MYS", null, "organization", "KUL"}, {"Los Angeles", "USA", "CA", "organization", "LAX"}, {"Madrid", "ESP", null, "organization", "MAD"}, {"Marketing", "USA", "CA", "organization"}, {"New York", "USA", "NY", "organization", "NYC"}, {"Saint Paulo", "BRA", null, "organization", "GRU"}, {"Sales", "USA", "CA", "organization"}, {"San Francisco", "USA", "CA", "organization", "SFO"}, {"Support", "USA", "CA", "organization"}};
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardSampleDataUtil.class);

    public static void addSampleData(long companyId) throws Exception {
        SetupWizardSampleDataUtil.addSampleData(companyId, PropsValues.COMPANY_DEFAULT_NAME, PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME, PropsValues.ADMIN_EMAIL_FROM_ADDRESS, false);
    }

    public static void addSampleData(long companyId, String companyName, String adminUserFirstName, String adminUserLastName, String adminUserEmailAddress, boolean resetPassword) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Adding sample data");
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
        User defaultUser = company.getDefaultUser();
        company = SetupWizardSampleDataUtil.updateCompany(company, companyName, LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), defaultUser.getTimeZoneId());
        User adminUser = SetupWizardSampleDataUtil.updateAdminUser(company, LocaleUtil.getDefault(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), adminUserEmailAddress, adminUserFirstName, adminUserLastName, resetPassword);
        Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)0L, (String)company.getLegalName(), (boolean)true);
        GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)"/main");
        Layout extranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)false, (long)0L, (String)(company.getLegalName() + " Extranet"), null, null, (String)"portlet", (boolean)false, (String)"/extranet", (ServiceContext)new ServiceContext());
        LayoutLocalServiceUtil.updateLayout((long)extranetLayout.getGroupId(), (boolean)false, (long)extranetLayout.getLayoutId(), (String)extranetLayout.getTypeSettings());
        Layout intranetLayout = LayoutLocalServiceUtil.addLayout((long)defaultUser.getUserId(), (long)organization.getGroupId(), (boolean)true, (long)0L, (String)(company.getLegalName() + " Intranet"), null, null, (String)"portlet", (boolean)false, (String)"/intranet", (ServiceContext)new ServiceContext());
        LayoutLocalServiceUtil.updateLayout((long)intranetLayout.getGroupId(), (boolean)true, (long)intranetLayout.getLayoutId(), (String)intranetLayout.getTypeSettings());
        OrganizationLocalServiceUtil.addUserOrganization((long)adminUser.getUserId(), (Organization)organization);
        SetupWizardSampleDataUtil.addOrganizations(companyName, defaultUser, organization);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished adding data in " + stopWatch.getTime() + " ms"));
        }
    }

    public static User updateAdminUser(Company company, Locale locale, String languageId, String emailAddress, String firstName, String lastName, boolean resetPassword) throws PortalException {
        String screenName;
        block5: {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            screenName = GetterUtil.getString((String)PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX, (String)"test");
            try {
                screenName = screenNameGenerator.generate(0L, 0L, emailAddress);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        User adminUser = UserLocalServiceUtil.fetchUserByEmailAddress((long)company.getCompanyId(), (String)emailAddress);
        if (adminUser != null) {
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullNameGenerator.getFullName(firstName, null, lastName), (boolean)false);
            Contact contact = adminUser.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(contact.getBirthday());
            int birthdayMonth = birthdayCal.get(2);
            int birthdayDay = birthdayCal.get(5);
            int birthdayYear = birthdayCal.get(1);
            adminUser = UserLocalServiceUtil.updateUser((long)adminUser.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)adminUser.getReminderQueryQuestion(), (String)adminUser.getReminderQueryAnswer(), (String)screenName, (String)emailAddress, (boolean)false, null, (String)languageId, (String)adminUser.getTimeZoneId(), (String)greeting, (String)adminUser.getComments(), (String)firstName, (String)adminUser.getMiddleName(), (String)lastName, (long)contact.getPrefixId(), (long)contact.getSuffixId(), (boolean)contact.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getFacebookSn(), (String)contact.getJabberSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getJobTitle(), null, null, null, null, null, (ServiceContext)new ServiceContext());
        } else {
            User user;
            UserLocalServiceUtil.addDefaultAdminUser((long)company.getCompanyId(), (String)screenName, (String)emailAddress, (Locale)locale, (String)firstName, (String)"", (String)lastName);
            adminUser = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)emailAddress);
            String defaultAdminEmailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + PropsValues.COMPANY_DEFAULT_WEB_ID;
            if (!emailAddress.equals(defaultAdminEmailAddress) && (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)company.getCompanyId(), (String)defaultAdminEmailAddress)) != null) {
                UserLocalServiceUtil.updateStatus((long)user.getUserId(), (int)5, (ServiceContext)new ServiceContext());
            }
        }
        return UserLocalServiceUtil.updatePasswordReset((long)adminUser.getUserId(), (boolean)resetPassword);
    }

    public static Company updateCompany(Company company, String companyName, String languageId, String timeZoneId) throws Exception {
        company.setName(companyName);
        company.setLegalName(companyName + ", Inc.");
        company = CompanyLocalServiceUtil.updateCompany((Company)company);
        CompanyLocalServiceUtil.updateDisplay((long)company.getCompanyId(), (String)languageId, (String)timeZoneId);
        return company;
    }

    protected static void addOrganizations(String companyName, User defaultUser, Organization parentOrganization) throws Exception {
        for (Object[] organizationArray : _ORGANIZATION_ARRAYS) {
            String name = companyName + organizationArray[0];
            String a3 = (String)organizationArray[1];
            String regionCode = (String)organizationArray[2];
            Country country = CountryServiceUtil.getCountryByA3((String)a3);
            long countryId = country.getCountryId();
            long regionId = 0L;
            if (regionCode != null) {
                Region region = RegionServiceUtil.getRegion((long)countryId, (String)regionCode);
                regionId = region.getRegionId();
            }
            String type = (String)organizationArray[3];
            Organization organization = OrganizationLocalServiceUtil.addOrganization((long)defaultUser.getUserId(), (long)parentOrganization.getOrganizationId(), (String)name, (String)type, (long)regionId, (long)countryId, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, (String)"", (boolean)true, null);
            GroupLocalServiceUtil.updateFriendlyURL((long)organization.getGroupId(), (String)FriendlyURLNormalizerUtil.normalize((String)("/" + organizationArray[0])));
            if (organizationArray.length <= 4) continue;
            String organizationPrefix = (String)organizationArray[4];
            long[] groupIds = new long[]{organization.getGroupId()};
            long[] organizationIds = new long[]{parentOrganization.getOrganizationId(), organization.getOrganizationId()};
            for (int i = 1; i <= 10; ++i) {
                StringBundler sb = new StringBundler(5);
                String defaultUserEmailAddress = defaultUser.getEmailAddress();
                String[] defaultUserEmailAddressParts = defaultUserEmailAddress.split("@");
                sb.append(defaultUserEmailAddressParts[0]);
                sb.append(".");
                sb.append(organizationPrefix);
                sb.append(".");
                sb.append(i);
                String screenName = sb.toString();
                String emailAddress = screenName + "@" + defaultUserEmailAddressParts[1];
                String lastName = organizationPrefix + " " + i;
                User user = UserLocalServiceUtil.addUser((long)0L, (long)defaultUser.getCompanyId(), (boolean)false, (String)"test", (String)"test", (boolean)false, (String)screenName, (String)emailAddress, (Locale)LocaleUtil.getDefault(), (String)"Test", null, (String)lastName, (long)0L, (long)0L, (boolean)true, (int)0, (int)1, (int)1970, null, (long[])groupIds, (long[])organizationIds, null, null, (boolean)false, (ServiceContext)new ServiceContext());
                user.setPasswordReset(false);
                user.setAgreedToTermsOfUse(true);
                UserLocalServiceUtil.updateUser((User)user);
            }
        }
    }
}

