/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.dao.init.DBInitUtil;
import com.liferay.portal.deploy.hot.CustomJspBagRegistryUtil;
import com.liferay.portal.deploy.hot.ServiceWrapperRegistry;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.module.framework.ModuleFrameworkUtil;
import com.liferay.portal.spring.aop.DynamicProxyCreator;
import com.liferay.portal.spring.compat.CompatBeanDefinitionRegistryPostProcessor;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.spring.context.PortalApplicationContext;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static final Field _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD;
    private static final Log _log;
    private static String _portalServletContextName;
    private static String _portalServletContextPath;
    private ArrayApplicationContext _arrayApplicationContext;
    private ServiceWrapperRegistry _serviceWrapperRegistry;

    public static String getPortalServletContextName() {
        return _portalServletContextName;
    }

    public static String getPortalServletContextPath() {
        return _portalServletContextPath;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        ModuleFrameworkUtil.unregisterContext(applicationContext);
        ThreadLocalCacheManager.destroy();
        if (this._serviceWrapperRegistry != null) {
            this._serviceWrapperRegistry.close();
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        try {
            PortalLifecycleUtil.reset();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        this.closeDataSource("counterDataSource");
        this.closeDataSource("liferayDataSource");
        super.contextDestroyed(servletContextEvent);
        this._cleanUpJDBCDrivers();
        try {
            ModuleFrameworkUtil.stopFramework(PropsValues.MODULE_FRAMEWORK_STOP_WAIT_TIMEOUT);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        ModuleFrameworkUtil.unregisterContext((Object)this._arrayApplicationContext);
        this._arrayApplicationContext.close();
        ClassLoaderPool.unregister((String)_portalServletContextName);
        ServletContextClassLoaderPool.unregister((String)_portalServletContextName);
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        Log4JUtil.shutdownLog4J();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Class.forName(SystemProperties.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        ServletContext servletContext = servletContextEvent.getServletContext();
        PortalClassPathUtil.initializeClassPaths(servletContext);
        InitUtil.init();
        this._logJVMArguments();
        _portalServletContextName = servletContext.getServletContextName();
        if (_portalServletContextName == null) {
            _portalServletContextName = "";
        }
        _portalServletContextPath = servletContext.getContextPath();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = tempDir.getAbsolutePath();
        Path tempDirPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        if (!Files.exists(tempDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(tempDirPath, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                _log.error((Object)("Unable to create " + tempDirPath), (Throwable)ioException);
            }
        }
        try {
            ModuleFrameworkUtil.initFramework();
            DBInitUtil.init();
            this._arrayApplicationContext = new ArrayApplicationContext(PropsValues.SPRING_INFRASTRUCTURE_CONFIGS);
            servletContext.setAttribute(PortalApplicationContext.PARENT_APPLICATION_CONTEXT, (Object)this._arrayApplicationContext);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        ClassLoaderPool.register((String)_portalServletContextName, (ClassLoader)portalClassLoader);
        ServletContextClassLoaderPool.register((String)_portalServletContextName, (ClassLoader)portalClassLoader);
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(MessageBus.class);
        serviceLatch.waitFor(PortalExecutorManager.class);
        serviceLatch.waitFor(SchedulerEngineHelper.class);
        serviceLatch.openOn(() -> {
            this._serviceWrapperRegistry = new ServiceWrapperRegistry();
        });
        FutureTask<Void> springInitTask = null;
        if (PropsValues.MODULE_FRAMEWORK_CONCURRENT_STARTUP_ENABLED) {
            springInitTask = new FutureTask<Void>(() -> {
                super.contextInitialized(servletContextEvent);
                return null;
            });
            Thread springInitThread = new Thread(springInitTask, "Portal Spring Init Thread");
            springInitThread.setContextClassLoader(portalClassLoader);
            springInitThread.setDaemon(true);
            springInitThread.start();
        }
        try {
            ModuleFrameworkUtil.registerContext((Object)this._arrayApplicationContext);
            ModuleFrameworkUtil.startFramework();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (springInitTask == null) {
            super.contextInitialized(servletContextEvent);
        } else {
            try {
                springInitTask.get();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        InitUtil.registerSpringInitialized();
        ServletContextPool.put((String)_portalServletContextName, (ServletContext)servletContext);
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocatorImpl);
        for (ClassLoader classLoader = portalClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        }
        this.clearFilteredPropertyDescriptorsCache(applicationContext.getAutowireCapableBeanFactory());
        DynamicProxyCreator dynamicProxyCreator = DynamicProxyCreator.getDynamicProxyCreator();
        dynamicProxyCreator.clear();
        if (PropsValues.UPGRADE_DATABASE_AUTO_RUN) {
            StartupHelperUtil.setUpgrading(true);
            try {
                DBUpgrader.upgradePortal();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        ModuleFrameworkUtil.registerContext(applicationContext);
        CustomJspBagRegistryUtil.getCustomJspBags();
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    protected void closeDataSource(String name) {
        DataSource dataSource = (DataSource)PortalBeanLocatorUtil.locate((String)name);
        if (dataSource instanceof DelegatingDataSource) {
            DelegatingDataSource delegatingDataSource = (DelegatingDataSource)dataSource;
            dataSource = delegatingDataSource.getTargetDataSource();
        }
        if (dataSource instanceof Closeable) {
            try {
                Closeable closeable = (Closeable)((Object)dataSource);
                closeable.close();
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator = (ConfigurableApplicationContextConfigurator)this._arrayApplicationContext.getBean("configurableApplicationContextConfigurator", ConfigurableApplicationContextConfigurator.class);
        configurableApplicationContextConfigurator.configure((ConfigurableApplicationContext)configurableWebApplicationContext);
        configurableWebApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new CompatBeanDefinitionRegistryPostProcessor());
    }

    private void _cleanUpJDBCDrivers() {
        block6: {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                Class<?> driverClass = driver.getClass();
                if (!PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)driverClass.getClassLoader())) continue;
                try {
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException sqlException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to deregister driver " + driver), (Throwable)sqlException);
                }
            }
            DB db = DBManagerUtil.getDB();
            DBType dbType = db.getDBType();
            if (dbType == DBType.MYSQL) {
                try {
                    Class<?> clazz = Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
                    Method method = clazz.getMethod("checkedShutdown", new Class[0]);
                    method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to cleanly shut down MySQL", (Throwable)exception);
                }
            }
        }
    }

    private void _logJVMArguments() {
        if (!_log.isInfoEnabled()) {
            return;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        StringBundler sb = new StringBundler(inputArguments.size() * 2);
        sb.append("JVM arguments: ");
        for (String inputArgument : inputArguments) {
            sb.append(inputArgument);
            sb.append(" ");
        }
        if (!inputArguments.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        _log.info((Object)sb.toString());
    }

    static {
        _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
        _portalServletContextName = "";
        _portalServletContextPath = "/";
        try {
            _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception exception) {
            throw new LoggedExceptionInInitializerError((Throwable)exception);
        }
    }
}

