/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.postgresql.PostgreSQLJDBCUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang.time.StopWatch;

public class Table {
    private static final String[][] _SAFE_TABLE_CHARS = new String[][]{{",", "\n", "\r"}, {"_SAFE_TABLE_COMMA_CHARACTER_", "_SAFE_TABLE_NEWLINE_CHARACTER_", "_SAFE_TABLE_RETURN_CHARACTER_"}};
    private static final String _SAFE_TABLE_COMMA_CHARACTER = "_SAFE_TABLE_COMMA_CHARACTER_";
    private static final String _SAFE_TABLE_NEWLINE_CHARACTER = "_SAFE_TABLE_NEWLINE_CHARACTER_";
    private static final String _SAFE_TABLE_RETURN_CHARACTER = "_SAFE_TABLE_RETURN_CHARACTER_";
    private static final Log _log = LogFactoryUtil.getLog(Table.class);
    private Object[][] _columns;
    private String _createSQL;
    private int[] _order;
    private String _selectSQL;
    private final String _tableName;
    private String _tempFileName;
    private long _totalRows;

    public Table(String tableName) {
        this._tableName = tableName;
    }

    public Table(String tableName, Object[][] columns) {
        this._tableName = tableName;
        this.setColumns(columns);
    }

    public void appendColumn(StringBuilder sb, Object value, boolean last) throws Exception {
        if (value == null) {
            throw new UpgradeException(StringBundler.concat((String[])new String[]{"Nulls should never be inserted into the database. ", "Attempted to append column to ", sb.toString(), "."}));
        }
        if (value instanceof byte[]) {
            sb.append(Base64.encode((byte[])((byte[])value)));
        } else if (value instanceof Clob || value instanceof String) {
            value = StringUtil.replace((String)((String)value), (String[])_SAFE_TABLE_CHARS[0], (String[])_SAFE_TABLE_CHARS[1]);
            sb.append(value);
        } else if (value instanceof Date) {
            DateFormat df = DateUtil.getISOFormat();
            sb.append(df.format(value));
        } else {
            sb.append(value);
        }
        sb.append(",");
        if (last) {
            sb.append("\n");
        }
    }

    public void appendColumn(StringBuilder sb, ResultSet resultSet, String name, Integer type, boolean last) throws Exception {
        Object value = null;
        try {
            value = this.getValue(resultSet, name, type);
        }
        catch (SQLException sqlException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)sqlException);
            }
            if (name.equals("uuid_")) {
                sb.append(PortalUUIDUtil.generate());
            }
            sb.append(",");
            if (last) {
                sb.append("\n");
            }
            return;
        }
        this.appendColumn(sb, value, last);
    }

    public void generateTempFile() throws Exception {
        try (Connection connection = DataAccess.getConnection();){
            this.generateTempFile(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateTempFile(Connection connection) throws Exception {
        boolean empty = true;
        String tempFileName = String.valueOf(Files.createTempFile(Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]), "temp-db-" + this._tableName + "-", null, new FileAttribute[0]));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Starting backup of ", this._tableName, " to ", tempFileName}));
        }
        try (UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(tempFileName));
             PreparedStatement preparedStatement = this.getSelectPreparedStatement(connection);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String data = null;
                try {
                    data = this.getExportedData(resultSet);
                    unsyncBufferedWriter.write(data);
                    ++this._totalRows;
                    empty = false;
                }
                catch (StagnantRowException stagnantRowException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Skipping stagnant data in ", this._tableName, ": ", stagnantRowException.getMessage()}));
                }
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Finished backup of ", this._tableName, " to ", tempFileName, " in ", stopWatch.getTime(), " ms"}));
            }
        }
        catch (Exception exception) {
            FileUtil.delete((String)tempFileName);
            throw exception;
        }
        if (!empty) {
            this._tempFileName = tempFileName;
            return;
        }
        FileUtil.delete((String)tempFileName);
    }

    public Object[][] getColumns() {
        return this._columns;
    }

    public String getCreateSQL() throws Exception {
        return this._createSQL;
    }

    public String getDeleteSQL() throws Exception {
        return "DELETE FROM " + this._tableName;
    }

    public String getExportedData(ResultSet resultSet) throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[][] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            boolean last = false;
            if (i + 1 == columns.length) {
                last = true;
            }
            this.appendColumn(sb, resultSet, (String)columns[i][0], (Integer)columns[i][1], last);
        }
        return sb.toString();
    }

    public String getInsertSQL() throws Exception {
        int i;
        String sql = "INSERT INTO " + this.getInsertTableName() + " (";
        for (i = 0; i < this._order.length; ++i) {
            int pos = this._order[i];
            sql = sql + this._columns[pos][0];
            sql = i + 1 < this._columns.length ? sql + ", " : sql + ") VALUES (";
        }
        for (i = 0; i < this._columns.length; ++i) {
            sql = sql + "?";
            sql = i + 1 < this._columns.length ? sql + ", " : sql + ")";
        }
        return sql;
    }

    public String getInsertTableName() throws Exception {
        String createSQL = this.getCreateSQL();
        if (Validator.isNotNull((String)createSQL)) {
            String createSQLLowerCase = StringUtil.toLowerCase((String)createSQL);
            int x = createSQLLowerCase.indexOf("create table ");
            if (x == -1) {
                return this._tableName;
            }
            int y = createSQL.indexOf(" ", x += 13);
            return StringUtil.trim((String)createSQL.substring(x, y));
        }
        return this._tableName;
    }

    public int[] getOrder() {
        return this._order;
    }

    public PreparedStatement getSelectPreparedStatement(Connection connection) throws Exception {
        return connection.prepareStatement(this.getSelectSQL());
    }

    public String getSelectSQL() throws Exception {
        if (this._selectSQL == null) {
            return "select * from " + this._tableName;
        }
        return this._selectSQL;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTempFileName() {
        return this._tempFileName;
    }

    public long getTotalRows() {
        return this._totalRows;
    }

    public Object getValue(ResultSet resultSet, String name, Integer type) throws Exception {
        Object value;
        block70: {
            value = null;
            int t = type;
            if (t == -5) {
                try {
                    value = GetterUtil.getLong((Object)resultSet.getLong(name));
                }
                catch (SQLException sqlException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)sqlException);
                    }
                    value = GetterUtil.getLong((String)resultSet.getString(name));
                }
            } else if (t == -7) {
                value = GetterUtil.getBoolean((Object)resultSet.getBoolean(name));
            } else if (t == 2004 || t == -4) {
                DB db = DBManagerUtil.getDB();
                DBType dbType = db.getDBType();
                value = dbType.equals((Object)DBType.POSTGRESQL) && PostgreSQLJDBCUtil.isPGStatement(resultSet.getStatement()) ? (Object)PostgreSQLJDBCUtil.getLargeObject(resultSet, name) : (Object)resultSet.getBytes(name);
                if (value == null) {
                    value = new byte[0];
                }
            } else if (t == 16) {
                value = GetterUtil.getBoolean((Object)resultSet.getBoolean(name));
            } else if (t == 2005) {
                try {
                    Clob clob = resultSet.getClob(name);
                    if (clob == null) {
                        value = "";
                        break block70;
                    }
                    try (Reader reader = clob.getCharacterStream();
                         UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
                        StringBundler sb = new StringBundler();
                        String line = null;
                        while ((line = unsyncBufferedReader.readLine()) != null) {
                            if (sb.length() != 0) {
                                sb.append(_SAFE_TABLE_NEWLINE_CHARACTER);
                            }
                            sb.append(line);
                        }
                        value = sb.toString();
                    }
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    value = GetterUtil.getString((String)resultSet.getString(name));
                }
            } else if (t == 3) {
                try {
                    value = resultSet.getBigDecimal(name);
                }
                catch (SQLException sqlException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)sqlException);
                    }
                    value = resultSet.getString(name);
                }
                value = GetterUtil.get((Object)value, (Number)BigDecimal.ZERO);
            } else if (t == 8) {
                value = GetterUtil.getDouble((Object)resultSet.getDouble(name));
            } else if (t == 6) {
                value = Float.valueOf(GetterUtil.getFloat((Object)Float.valueOf(resultSet.getFloat(name))));
            } else if (t == 4) {
                value = GetterUtil.getInteger((Object)resultSet.getInt(name));
            } else if (t == -1) {
                value = GetterUtil.getString((String)resultSet.getString(name));
            } else if (t == 2) {
                value = GetterUtil.getLong((Object)resultSet.getLong(name));
            } else if (t == 5) {
                value = GetterUtil.getShort((Object)resultSet.getShort(name));
            } else if (t == 93) {
                block71: {
                    try {
                        value = resultSet.getTimestamp(name);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block71;
                        _log.debug((Throwable)exception);
                    }
                }
                if (value == null) {
                    value = "null";
                }
            } else if (t == -6) {
                value = GetterUtil.getShort((Object)resultSet.getShort(name));
            } else if (t == 12) {
                value = GetterUtil.getString((String)resultSet.getString(name));
            } else {
                throw new UpgradeException("Upgrade code using unsupported class type " + type);
            }
        }
        return value;
    }

    public void populateTable() throws Exception {
        try (Connection connection = DataAccess.getConnection();){
            this.populateTable(connection);
        }
    }

    public void populateTable(Connection connection) throws Exception {
        if (this._tempFileName == null) {
            return;
        }
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)this.getInsertSQL());
             UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(this._tempFileName));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Object[][] columns;
                String[] values = StringUtil.split((String)line);
                if (values.length != (columns = this.getColumns()).length) {
                    throw new UpgradeException(StringBundler.concat((String[])new String[]{"Column lengths differ between temp file and ", "schema. Attempted to insert row ", line, "."}));
                }
                int[] order = this.getOrder();
                for (int i = 0; i < order.length; ++i) {
                    int pos = order[i];
                    this.setColumn(preparedStatement, i, (Integer)columns[pos][1], values[pos]);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this.getTableName() + " table populated with data"));
        }
    }

    public void populateTableRows(PreparedStatement preparedStatement, boolean batch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating rows for " + this.getTableName()));
        }
        if (batch) {
            preparedStatement.executeBatch();
        } else {
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    public void setColumn(PreparedStatement preparedStatement, int index, Integer type, String value) throws Exception {
        ++index;
        int t = type;
        if (t == -5) {
            preparedStatement.setLong(index, GetterUtil.getLong((String)value));
        } else if (t == 2004 || t == -4) {
            byte[] valueBytes = Base64.decode((String)value);
            if (PostgreSQLJDBCUtil.isPGStatement(preparedStatement)) {
                PostgreSQLJDBCUtil.setLargeObject(preparedStatement, index, valueBytes);
            } else {
                preparedStatement.setBytes(index, valueBytes);
            }
        } else if (t == 16) {
            preparedStatement.setBoolean(index, GetterUtil.getBoolean((String)value));
        } else if (t == 2005 || t == -1 || t == 12) {
            value = StringUtil.replace((String)value, (String[])_SAFE_TABLE_CHARS[1], (String[])_SAFE_TABLE_CHARS[0]);
            preparedStatement.setString(index, value);
        } else if (t == 3) {
            preparedStatement.setBigDecimal(index, (BigDecimal)GetterUtil.get((Object)value, (Number)BigDecimal.ZERO));
        } else if (t == 8) {
            preparedStatement.setDouble(index, GetterUtil.getDouble((String)value));
        } else if (t == 6) {
            preparedStatement.setFloat(index, GetterUtil.getFloat((String)value));
        } else if (t == 4) {
            preparedStatement.setInt(index, GetterUtil.getInteger((String)value));
        } else if (t == 5) {
            preparedStatement.setShort(index, GetterUtil.getShort((String)value));
        } else if (t == 93) {
            if ("null".equals(value)) {
                preparedStatement.setTimestamp(index, null);
            } else {
                DateFormat dateFormat = DateUtil.getISOFormat();
                Date date = dateFormat.parse(value);
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            }
        } else if (t == -6) {
            preparedStatement.setShort(index, GetterUtil.getShort((String)value));
        } else {
            throw new UpgradeException("Upgrade code using unsupported class type " + type);
        }
    }

    public void setColumns(Object[][] columns) {
        this._columns = columns;
        this._order = new int[this._columns.length];
        int clobCount = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            int pos;
            Integer type = (Integer)columns[i][1];
            if (type == 2005) {
                pos = this._columns.length - ++clobCount;
                this._order[pos] = i;
                continue;
            }
            pos = i - clobCount;
            this._order[pos] = i;
        }
    }

    public void setCreateSQL(String createSQL) throws Exception {
        this._createSQL = createSQL;
    }

    public void setSelectSQL(String selectSQL) throws Exception {
        this._selectSQL = selectSQL;
    }

    public void updateColumnValue(String columnName, String oldValue, String newValue) {
        String sql = StringBundler.concat((String[])new String[]{"update ", this._tableName, " set ", columnName, " = ? where ", columnName, " = ?"});
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, newValue);
            preparedStatement.setString(2, oldValue);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            _log.error((Throwable)sqlException);
            throw new RuntimeException("Unable to execute " + sql, sqlException);
        }
    }
}

