/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_3_x;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDLFileEntryType
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeSchema();
        this._populateFields();
    }

    private void _populateFields() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select uuid_, fileEntryTypeId, groupId, fileEntryTypeKey from DLFileEntryType where (dataDefinitionId IS NULL OR dataDefinitionId = 0)");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select structureId FROM DDMStructure where groupId = ? AND classNameId = ? AND (structureKey = ? OR structureKey = ? OR structureKey = ? ) ");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update DLFileEntryType set dataDefinitionId = ? where fileEntryTypeId = ? ");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            long classNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
            while (resultSet1.next()) {
                preparedStatement2.setLong(1, resultSet1.getLong(3));
                preparedStatement2.setLong(2, classNameId);
                preparedStatement2.setString(3, DLUtil.getDDMStructureKey((String)resultSet1.getString(1)));
                preparedStatement2.setString(4, DLUtil.getDeprecatedDDMStructureKey((long)resultSet1.getLong(2)));
                preparedStatement2.setString(5, resultSet1.getString(4));
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                Throwable throwable = null;
                try {
                    if (!resultSet2.next()) continue;
                    preparedStatement3.setLong(1, resultSet2.getLong(1));
                    preparedStatement3.setLong(2, resultSet1.getLong(2));
                    preparedStatement3.addBatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultSet2 == null) continue;
                    if (throwable != null) {
                        try {
                            resultSet2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resultSet2.close();
                }
            }
            preparedStatement3.executeBatch();
        }
    }

    private void _upgradeSchema() throws Exception {
        this.alterTableAddColumn("DLFileEntryType", "dataDefinitionId", "LONG");
    }
}

