/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TextExtractor;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{PropsUtil.get("dl.store.file.impl.safe.file.name.2.ampersand"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.close.parenthesis"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.open.parenthesis"), PropsUtil.get("dl.store.file.impl.safe.file.name.2.semicolon")};
    private static final Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static final FileImpl _fileImpl = new FileImpl();

    public static FileImpl getInstance() {
        return _fileImpl;
    }

    public String appendParentheticalSuffix(String fileName, String suffix) {
        String fileNameWithoutExtension = this.stripExtension(fileName);
        String fileNameWithParentheticalSuffix = StringUtil.appendParentheticalSuffix((String)fileNameWithoutExtension, (String)suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNull((String)extension)) {
            return fileNameWithParentheticalSuffix;
        }
        return StringBundler.concat((String[])new String[]{fileNameWithParentheticalSuffix, ".", extension});
    }

    public String appendSuffix(String fileName, String suffix) {
        StringBundler sb = new StringBundler(4);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(fileNameWithoutExtension);
        sb.append(suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        java.io.File directory;
        if (!source.exists() || !source.isDirectory()) {
            return;
        }
        this.mkdirs(destination);
        LinkedList<java.io.File> queue = new LinkedList<java.io.File>();
        queue.add(source);
        String basePath = source.getPath();
        int prefixLength = basePath.length() + 1;
        while ((directory = (java.io.File)queue.poll()) != null) {
            for (java.io.File file : directory.listFiles()) {
                String path = file.getPath();
                java.io.File targetFile = new java.io.File(destination, path.substring(prefixLength));
                if (file.isFile()) {
                    StreamUtil.transfer((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(targetFile));
                    continue;
                }
                targetFile.mkdir();
                queue.add(file);
            }
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    public void copyFile(java.io.File source, java.io.File destination) throws IOException {
        if (!source.exists()) {
            return;
        }
        this.mkdirsParentFile(destination);
        StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
    }

    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(new java.io.File(source), new java.io.File(destination));
    }

    public java.io.File createTempFile() {
        return this.createTempFile("");
    }

    public java.io.File createTempFile(byte[] bytes) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, bytes, false);
        return file;
    }

    public java.io.File createTempFile(InputStream inputStream) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, inputStream);
        return file;
    }

    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    public java.io.File createTempFile(String prefix, String extension) {
        return new java.io.File(this.createTempFileName(prefix, extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null, null);
    }

    public String createTempFileName(String extension) {
        return this.createTempFileName(null, extension);
    }

    public String createTempFileName(String prefix, String extension) {
        StringBundler sb = new StringBundler(7);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        if (Validator.isNotNull((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}));
        if (Validator.isFileExtension((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public java.io.File createTempFolder() throws IOException {
        java.io.File file = new java.io.File(this.createTempFileName());
        this.mkdirs(file);
        return file;
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(java.io.File file) {
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    public void deltree(java.io.File directory) {
        if (directory.isDirectory()) {
            java.io.File curDirectory;
            LinkedList<java.io.File> deleteDeque = new LinkedList<java.io.File>();
            deleteDeque.push(directory);
            LinkedList<java.io.File> visitQueue = new LinkedList<java.io.File>();
            visitQueue.add(directory);
            while ((curDirectory = (java.io.File)visitQueue.poll()) != null) {
                for (java.io.File file : curDirectory.listFiles()) {
                    if (file.isFile()) {
                        file.delete();
                        continue;
                    }
                    visitQueue.add(file);
                    deleteDeque.push(file);
                }
            }
            deleteDeque.forEach(java.io.File::delete);
        } else {
            directory.delete();
        }
    }

    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(java.io.File file) {
        return file.exists();
    }

    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    public String extractText(InputStream inputStream) {
        return this.extractText(inputStream, -1);
    }

    public String extractText(InputStream inputStream, int maxStringLength) {
        return TextExtractorHolder._textExtractor.extractText(inputStream, maxStringLength);
    }

    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
        return this.getBytes(clazz.getResourceAsStream(fileName));
    }

    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public byte[] getBytes(InputStream inputStream) throws IOException {
        return this.getBytes(inputStream, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize, (boolean)cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase((String)fileName.substring(pos + 1));
        }
        return "";
    }

    public String getMD5Checksum(java.io.File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigesterUtil.digestHex((String)"MD5", (InputStream)fileInputStream);
            return string;
        }
    }

    public String getPath(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        if (x == -1 && y == -1) {
            return "/";
        }
        return fullFileName.substring(0, Math.max(x, y));
    }

    public String getShortFileName(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        return fullFileName.substring(Math.max(x, y) + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            if (fileChannel.size() != (long)length) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            int bufferIndex = 0;
            int bufferLength = -1;
            while (true) {
                if ((bufferLength = fileChannel.read(byteBuffer)) > 0 && bufferIndex < length) {
                } else {
                    boolean bl;
                    if (bufferIndex != length || bufferLength != -1) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                for (int i = 0; i < bufferLength; ++i) {
                    if (buffer[i] == bytes[bufferIndex++]) continue;
                    boolean bl = false;
                    return bl;
                }
                byteBuffer.clear();
            }
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Throwable)exception);
            return false;
        }
    }

    public boolean isSameContent(java.io.File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (CharBuffer)CharBuffer.wrap(s));
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            dirs.add(fileArray[i].getName());
        }
        return dirs.toArray(new String[0]);
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            files.add(fileArray[i].getName());
        }
        return files.toArray(new String[0]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    public void mkdirs(java.io.File file) {
        file.mkdirs();
    }

    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        if (file.exists() && file.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Directory " + pathName + " already exists"));
            }
            return;
        }
        this.mkdirs(file);
    }

    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        try {
            if (source.isDirectory()) {
                if (!source.renameTo(destination)) {
                    this.copyDirectory(source, destination);
                    this.deltree(source);
                }
            } else if (!source.renameTo(destination)) {
                this.copyFile(source, destination);
                this.delete(source);
            }
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            return false;
        }
        return true;
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (char)'\\', (char)'/');
    }

    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        for (java.io.File file : files) {
            if (file.isDirectory()) {
                directoryList.add(file);
                continue;
            }
            fileList.add(file);
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[0]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public String stripParentheticalSuffix(String fileName) {
        StringBundler sb = new StringBundler(3);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(StringUtil.stripParentheticalSuffix((String)fileNameWithoutExtension));
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list;
        block15: {
            list = new ArrayList<String>();
            try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
                String line = null;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block15;
                _log.debug((Throwable)ioException);
            }
        }
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fileInputStream) {
        Properties properties;
        block2: {
            properties = new Properties();
            try {
                properties.load(fileInputStream);
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)ioException);
            }
        }
        return properties;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            return new Properties();
        }
    }

    public void touch(java.io.File file) throws IOException {
        if (file.exists()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            file.createNewFile();
        }
    }

    public void touch(String fileName) throws IOException {
        this.touch(new java.io.File(fileName));
    }

    public void unzip(java.io.File source, java.io.File destination) {
        try (FileInputStream inputStream = new FileInputStream(source);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                java.io.File destinationFile = new java.io.File(destination, entry.getName());
                if (entry.isDirectory()) {
                    destinationFile.mkdirs();
                    continue;
                }
                java.io.File parentFile = destinationFile.getParentFile();
                parentFile.mkdirs();
                FileOutputStream outputStream = new FileOutputStream(destinationFile);
                Throwable throwable = null;
                try {
                    StreamUtil.transfer((InputStream)zipInputStream, (OutputStream)outputStream, (boolean)false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputStream).close();
                }
            }
        }
        catch (IOException ioException) {
            ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        this.write(file, bytes, 0, bytes.length, append);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        this.write(file, bytes, offset, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.mkdirsParentFile(file);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, append);){
            fileOutputStream.write(bytes, offset, length);
        }
    }

    public void write(java.io.File file, InputStream inputStream) throws IOException {
        this.mkdirsParentFile(file);
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
    }

    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        this.mkdirsParentFile(file);
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");){
            writer.write(s);
        }
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    public void write(String fileName, InputStream inputStream) throws IOException {
        this.write(new java.io.File(fileName), inputStream);
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    protected void mkdirsParentFile(java.io.File file) throws IOException {
        block3: {
            java.io.File parentFile = file.getParentFile();
            if (parentFile == null) {
                return;
            }
            try {
                this.mkdirs(parentFile);
            }
            catch (SecurityException securityException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)securityException);
            }
        }
    }

    private static class TextExtractorHolder {
        private static volatile TextExtractor _textExtractor = (TextExtractor)ServiceProxyFactory.newServiceTrackedInstance(TextExtractor.class, TextExtractorHolder.class, (String)"_textExtractor", (boolean)true);

        private TextExtractorHolder() {
        }
    }
}

