/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.model.impl.LayoutTypeControllerImpl;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class LayoutTypeControllerTracker {
    private static final String[] _LAYOUT_TYPES = new String[]{"portlet"};
    private static final ServiceTrackerMap<String, LayoutTypeController> _serviceTrackerMap;

    public static LayoutTypeController getLayoutTypeController(Layout layout) {
        return LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
    }

    public static LayoutTypeController getLayoutTypeController(String type) {
        LayoutTypeController layoutTypeController = (LayoutTypeController)_serviceTrackerMap.getService((Object)type);
        if (layoutTypeController != null) {
            return layoutTypeController;
        }
        return (LayoutTypeController)_serviceTrackerMap.getService((Object)"portlet");
    }

    public static Map<String, LayoutTypeController> getLayoutTypeControllers() {
        HashMap<String, LayoutTypeController> layoutTypeControllers = new HashMap<String, LayoutTypeController>();
        for (String type : _serviceTrackerMap.keySet()) {
            layoutTypeControllers.put(type, (LayoutTypeController)_serviceTrackerMap.getService((Object)type));
        }
        return layoutTypeControllers;
    }

    public static String[] getTypes() {
        Set types = _serviceTrackerMap.keySet();
        return types.toArray(new String[0]);
    }

    static {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        for (String type : _LAYOUT_TYPES) {
            bundleContext.registerService(LayoutTypeController.class, (Object)new LayoutTypeControllerImpl(type), (Dictionary)HashMapDictionaryBuilder.put((Object)"layout.type", (Object)type).put((Object)"service.ranking", (Object)Integer.MIN_VALUE).build());
        }
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, LayoutTypeController.class, (String)"layout.type");
    }
}

