/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Autocomplete;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    public AssetCategory addCategory(long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), groupId, parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(null, this.getUserId(), groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public AssetCategory addCategory(long groupId, String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), groupId, 0L, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), groupId, title, vocabularyId, serviceContext);
    }

    public AssetCategory addCategory(String externalReferenceCode, long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), groupId, parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(externalReferenceCode, this.getUserId(), groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public void deleteCategories(long[] categoryIds) throws PortalException {
        for (long categoryId : categoryIds) {
            AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        }
        this.assetCategoryLocalService.deleteCategories(categoryIds);
    }

    public void deleteCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    public AssetCategory fetchCategory(long categoryId) throws PortalException {
        AssetCategory category = this.assetCategoryLocalService.fetchCategory(categoryId);
        if (category != null) {
            AssetCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        }
        return category;
    }

    public AssetCategory getAssetCategoryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        AssetCategory category = this.assetCategoryLocalService.getAssetCategoryByExternalReferenceCode(groupId, externalReferenceCode);
        AssetCategoryPermission.check(this.getPermissionChecker(), category.getCategoryId(), "VIEW");
        return category;
    }

    public List<AssetCategory> getCategories(long classNameId, long classPK, int start, int end) {
        return this.assetCategoryFinder.filterFindByC_C(classNameId, classPK, start, end);
    }

    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    public int getCategoriesCount(long classNameId, long classPK) {
        return this.assetCategoryFinder.filterCountByC_C(classNameId, classPK);
    }

    public AssetCategory getCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    public String getCategoryPath(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        AssetCategory category = this.getCategory(categoryId);
        return category.getPath(LocaleUtil.getMostRelevantLocale());
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) throws PortalException {
        AssetCategory parent;
        if (parentCategoryId != 0L && (parent = this.assetCategoryLocalService.fetchAssetCategory(parentCategoryId)) != null) {
            return this.assetCategoryPersistence.filterFindByG_P(parent.getGroupId(), parentCategoryId, start, end, orderByComparator);
        }
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, orderByComparator));
    }

    public int getChildCategoriesCount(long parentCategoryId) throws PortalException {
        AssetCategory parent;
        if (parentCategoryId != 0L && (parent = this.assetCategoryLocalService.fetchAssetCategory(parentCategoryId)) != null) {
            return this.assetCategoryPersistence.filterCountByG_P(parent.getGroupId(), parentCategoryId);
        }
        return this.assetCategoryPersistence.countByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, orderByComparator));
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, orderByComparator));
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, parentCategoryId, vocabularyId, start, end, orderByComparator);
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, orderByComparator);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, orderByComparator);
    }

    public int getVocabularyCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, long parentCategory, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, parentCategory, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
        }
        return this.assetCategoryPersistence.filterCountByG_LikeN_V(groupId, name, vocabularyId);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) throws PortalException {
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, orderByComparator));
        return new AssetCategoryDisplay(categories, categories.size(), start, end);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) throws PortalException {
        List<AssetCategory> categories = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, orderByComparator);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, orderByComparator);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        return new AssetCategoryDisplay(categories, total, start, end);
    }

    public List<AssetCategory> getVocabularyRootCategories(long groupId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, 0L, vocabularyId, start, end, orderByComparator);
    }

    public int getVocabularyRootCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, 0L, vocabularyId);
    }

    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    public List<AssetCategory> search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        String name = CustomSQLUtil.keywords((String)keywords)[0];
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, orderByComparator);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, orderByComparator);
    }

    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws PortalException {
        List<AssetCategory> categories = this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
        categories = this.filterCategories(categories);
        return Autocomplete.arrayToJSONArray(categories, (String)"name", (String)"name");
    }

    public JSONArray search(long[] groupIds, String name, long[] vocabularyIds, int start, int end) throws PortalException {
        JSONArray jsonArray = null;
        jsonArray = Validator.isNull((String)name) ? this.toJSONArray(this.assetCategoryPersistence.filterFindByG_V(groupIds, vocabularyIds, start, end)) : this.toJSONArray(this.assetCategoryPersistence.filterFindByG_LikeN_V(groupIds, name, vocabularyIds, start, end));
        return jsonArray;
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{vocabularyId}, start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long parentCategoryId, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{parentCategoryId}, new long[]{vocabularyId}, start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, long parentCategoryId, int start, int end, Sort sort) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{vocabularyId}, new long[]{parentCategoryId}, start, end, sort);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, parentCategoryIds, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, long[] parentCategoryIds, int start, int end, Sort sort) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, vocabularyIds, parentCategoryIds, start, end, sort);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            AssetCategory category = (AssetCategory)iterator.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            iterator.remove();
        }
        return categories;
    }

    protected JSONArray toJSONArray(List<AssetCategory> categories) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetCategory category : categories) {
            String categoryJSON = JSONFactoryUtil.looseSerialize((Object)category);
            JSONObject categoryJSONObject = JSONFactoryUtil.createJSONObject((String)categoryJSON);
            categoryJSONObject.put("path", this.getCategoryPath(category.getCategoryId()));
            jsonArray.put(categoryJSONObject);
        }
        return jsonArray;
    }
}

